/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.application.cacheservice;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.set.application.cacheservice.CacheImpl;
import org.eclipse.set.basis.cache.Cache;
import org.eclipse.set.core.services.Services;
import org.eclipse.set.core.services.cache.CacheService;
import org.eclipse.set.core.services.cache.NoCacheService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

@Component(property={"event.topics=modelsession/change/model"}, service={EventHandler.class, CacheService.class})
public class CacheServiceImpl
implements CacheService,
EventHandler {
    private final Map<String, Cache> caches = new HashMap<String, Cache>();

    public CacheServiceImpl() {
        Services.setCacheService((CacheService)this);
        Services.setNoCacheService((NoCacheService)new NoCacheService());
    }

    public Cache getCache(String cacheId) {
        this.caches.computeIfAbsent(cacheId, CacheImpl::new);
        return this.caches.get(cacheId);
    }

    public Cache getCache(String cacheId, String containerCacheId) throws IllegalArgumentException {
        String cacheKey = cacheId + "/" + containerCacheId;
        this.caches.computeIfAbsent(cacheKey, CacheImpl::new);
        return this.caches.get(cacheKey);
    }

    private void invalidate() {
        this.caches.values().forEach(Cache::invalidate);
    }

    public void handleEvent(Event event) {
        this.invalidate();
    }
}

