/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.application.initializationservice;

import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.set.basis.guid.Guid;
import org.eclipse.set.core.services.initialization.InitializationStep;
import org.eclipse.set.ppmodel.extensions.PlanProSchnittstelleExtensions;
import org.eclipse.set.toolboxmodel.Basisobjekte.BasisobjekteFactory;
import org.eclipse.set.toolboxmodel.Basisobjekte.Identitaet_TypeClass;
import org.eclipse.set.toolboxmodel.PlanPro.DocumentRoot;
import org.eclipse.set.toolboxmodel.PlanPro.PlanPro_Schnittstelle;
import org.eclipse.set.toolboxmodel.PlanPro.PlanPro_Schnittstelle_Allg_AttributeGroup;
import org.eclipse.set.utils.ToolboxConfiguration;
import org.eclipse.set.utils.ToolboxVersion;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true)
public class CommonPlanProInitialization
implements InitializationStep {
    private static final int PRIORITY = 100;

    private static XMLGregorianCalendar currentTime() {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(new Date());
        XMLGregorianCalendar xc = null;
        try {
            xc = DatatypeFactory.newInstance().newXMLGregorianCalendar(gc);
        }
        catch (DatatypeConfigurationException e) {
            throw new RuntimeException(e);
        }
        return xc;
    }

    public int getPriority() {
        return 100;
    }

    public <M, C extends InitializationStep.Configuration> void init(M model, C configuaration) {
        if (!(model instanceof DocumentRoot)) {
            return;
        }
        DocumentRoot documentRoot = (DocumentRoot)model;
        PlanPro_Schnittstelle planProSchnittstelle = PlanProSchnittstelleExtensions.createEmptyModel();
        documentRoot.setPlanProSchnittstelle(planProSchnittstelle);
        PlanPro_Schnittstelle_Allg_AttributeGroup planProSchnittstelleAllg = planProSchnittstelle.getPlanProSchnittstelleAllg();
        planProSchnittstelleAllg.getErzeugungZeitstempel().setWert(CommonPlanProInitialization.currentTime());
        planProSchnittstelleAllg.getWerkzeugName().setWert(configuaration.getBrandingService().getNames().getToolName());
        ToolboxVersion version = ToolboxConfiguration.getToolboxVersion();
        planProSchnittstelleAllg.getWerkzeugVersion().setWert(version.getShortVersion());
        Identitaet_TypeClass id = BasisobjekteFactory.eINSTANCE.createIdentitaet_TypeClass();
        id.setWert(Guid.create().toString());
        planProSchnittstelle.setIdentitaet(id);
    }
}

