/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.application.splash;

import javax.inject.Inject;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.set.core.services.splash.SplashScreenService;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class SplashScreenServiceImpl
implements SplashScreenService {
    private final boolean stopSplash = true;
    @Inject
    IApplicationContext applicationContext;
    @Inject
    IEventBroker eventBroker;

    private static void createSplash(Shell shell, ImageDescriptor descriptor) {
        Label label = new Label((Composite)shell, 2048);
        LocalResourceManager localResourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)shell);
        Image image = localResourceManager.createImage(descriptor);
        label.setImage(image);
        ProgressBar progressBar = new ProgressBar((Composite)shell, 2);
        progressBar.setLayoutData((Object)GridDataFactory.fillDefaults().create());
    }

    private static void setPosition(Shell shell) {
        Rectangle displaySize = shell.getMonitor().getBounds();
        Point shellSize = shell.computeSize(-1, -1);
        int x = (displaySize.width - shellSize.x) / 2;
        int y = (displaySize.height - shellSize.y) / 2;
        int width = shellSize.x;
        int height = shellSize.y;
        shell.setBounds(x, y, width, height);
    }

    public void show(ImageDescriptor descriptor) {
        final Shell shell = new Shell(8);
        shell.setLayout((Layout)GridLayoutFactory.swtDefaults().margins(0, 0).spacing(0, 0).create());
        this.eventBroker.subscribe("org/eclipse/e4/ui/LifeCycle/appStartupComplete", new EventHandler(){

            public void handleEvent(Event event) {
                shell.close();
                shell.dispose();
                SplashScreenServiceImpl.this.eventBroker.unsubscribe((EventHandler)this);
            }
        });
        this.applicationContext.applicationRunning();
        SplashScreenServiceImpl.createSplash(shell, descriptor);
        SplashScreenServiceImpl.setPosition(shell);
        shell.pack();
        shell.open();
    }
}

