/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.ppmodel.extensions;

import com.google.common.collect.Iterables;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.set.model.planpro.Ansteuerung_Element.Stell_Bereich;
import org.eclipse.set.model.planpro.BasisTypen.Bezeichnung_Element_AttributeGroup;
import org.eclipse.set.model.planpro.BasisTypen.Kennzahl_TypeClass;
import org.eclipse.set.model.planpro.BasisTypen.Oertlicher_Elementname_TypeClass;
import org.eclipse.set.model.planpro.Basisobjekte.Basis_Objekt;
import org.eclipse.set.model.planpro.Basisobjekte.Bereich_Objekt;
import org.eclipse.set.model.planpro.Basisobjekte.Bereich_Objekt_Teilbereich_AttributeGroup;
import org.eclipse.set.model.planpro.Basisobjekte.Identitaet_TypeClass;
import org.eclipse.set.model.planpro.Basisobjekte.Punkt_Objekt;
import org.eclipse.set.model.planpro.Gleis.Gleis_Abschnitt;
import org.eclipse.set.model.planpro.Gleis.Gleis_Schaltgruppe;
import org.eclipse.set.model.planpro.Ortung.Bezeichnung_Kennbuchstabe_TypeClass;
import org.eclipse.set.model.planpro.Ortung.ENUMBezeichnungKennbuchstabe;
import org.eclipse.set.model.planpro.Ortung.FMA_Anlage;
import org.eclipse.set.model.planpro.Ortung.FMA_Anlage_Bezeichnung_AttributeGroup;
import org.eclipse.set.model.planpro.Ortung.FMA_Anlage_Kaskade_AttributeGroup;
import org.eclipse.set.model.planpro.Ortung.FMA_Kaskade_Bezeichnung_TypeClass;
import org.eclipse.set.model.planpro.Ortung.FMA_Komponente;
import org.eclipse.set.model.planpro.Ortung.FMA_Komponente_Achszaehlpunkt_AttributeGroup;
import org.eclipse.set.model.planpro.Ortung.Schaltmittel_Zuordnung;
import org.eclipse.set.model.planpro.Verweise.ID_Gleis_Abschnitt_TypeClass;
import org.eclipse.set.model.planpro.Verweise.ID_Schalter_TypeClass;
import org.eclipse.set.model.planpro.Weichen_und_Gleissperren.Gleis_Abschluss;
import org.eclipse.set.ppmodel.extensions.BasisAttributExtensions;
import org.eclipse.set.ppmodel.extensions.BasisObjektExtensions;
import org.eclipse.set.ppmodel.extensions.BereichObjektExtensions;
import org.eclipse.set.ppmodel.extensions.FmaKomponenteExtensions;
import org.eclipse.set.ppmodel.extensions.GleisAbschnittExtensions;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class FmaAnlageExtensions
extends BasisObjektExtensions {
    public static Set<FMA_Komponente> getFmaKomponenten(FMA_Anlage anlage) {
        Functions.Function1 _function = it -> {
            boolean _xblockexpression = false;
            FMA_Komponente_Achszaehlpunkt_AttributeGroup _fMAKomponenteAchszaehlpunkt = it.getFMAKomponenteAchszaehlpunkt();
            _xblockexpression = FmaKomponenteExtensions.belongsTo(it, anlage);
            return _xblockexpression;
        };
        return IterableExtensions.toSet((Iterable)IterableExtensions.filter((Iterable)BasisAttributExtensions.getContainer((EObject)anlage).getFMAKomponente(), (Functions.Function1)_function));
    }

    public static Set<Punkt_Objekt> getFmaGrenzen(FMA_Anlage anlage) {
        Set<FMA_Komponente> _fmaKomponenten = FmaAnlageExtensions.getFmaKomponenten(anlage);
        Set<Gleis_Abschluss> _gleisAbschluesse = FmaAnlageExtensions.getGleisAbschluesse(anlage);
        return IterableExtensions.toSet((Iterable)Iterables.concat(_fmaKomponenten, _gleisAbschluesse));
    }

    public static Set<Gleis_Abschluss> getGleisAbschluesse(FMA_Anlage anlage) {
        ID_Gleis_Abschnitt_TypeClass _iDGleisAbschnitt = anlage.getIDGleisAbschnitt();
        Gleis_Abschnitt _value = null;
        if (_iDGleisAbschnitt != null) {
            _value = _iDGleisAbschnitt.getValue();
        }
        return IterableExtensions.toSet(BereichObjektExtensions.filterContained((Bereich_Objekt)_value, BasisAttributExtensions.getContainer((EObject)anlage).getGleisAbschluss()));
    }

    public static String getTableName(FMA_Anlage anlage) {
        String kaskadeBez;
        ID_Gleis_Abschnitt_TypeClass _iDGleisAbschnitt = anlage.getIDGleisAbschnitt();
        Gleis_Abschnitt _value = null;
        if (_iDGleisAbschnitt != null) {
            _value = _iDGleisAbschnitt.getValue();
        }
        String name = _value.getBezeichnung().getBezeichnungTabelle().getWert();
        FMA_Anlage_Kaskade_AttributeGroup _fMAAnlageKaskade = null;
        if (anlage != null) {
            _fMAAnlageKaskade = anlage.getFMAAnlageKaskade();
        }
        FMA_Kaskade_Bezeichnung_TypeClass _fMAKaskadeBezeichnung = null;
        if (_fMAAnlageKaskade != null) {
            _fMAKaskadeBezeichnung = _fMAAnlageKaskade.getFMAKaskadeBezeichnung();
        }
        String _wert = null;
        if (_fMAKaskadeBezeichnung != null) {
            _wert = _fMAKaskadeBezeichnung.getWert();
        }
        if ((kaskadeBez = _wert) == null) {
            kaskadeBez = "";
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(name);
        _builder.append(kaskadeBez);
        return _builder.toString();
    }

    public static String getBzBezeichner(FMA_Anlage anlage) {
        ID_Gleis_Abschnitt_TypeClass _iDGleisAbschnitt = anlage.getIDGleisAbschnitt();
        Gleis_Abschnitt _value = null;
        if (_iDGleisAbschnitt != null) {
            _value = _iDGleisAbschnitt.getValue();
        }
        Gleis_Abschnitt gleisabschnitt = _value;
        Bezeichnung_Element_AttributeGroup _bezeichnung = null;
        if (gleisabschnitt != null) {
            _bezeichnung = gleisabschnitt.getBezeichnung();
        }
        Kennzahl_TypeClass _kennzahl = null;
        if (_bezeichnung != null) {
            _kennzahl = _bezeichnung.getKennzahl();
        }
        String _wert = null;
        if (_kennzahl != null) {
            _wert = _kennzahl.getWert();
        }
        String kennzahl = _wert;
        FMA_Anlage_Bezeichnung_AttributeGroup _bezeichnung_1 = null;
        if (anlage != null) {
            _bezeichnung_1 = anlage.getBezeichnung();
        }
        Bezeichnung_Kennbuchstabe_TypeClass _bezeichnungKennbuchstabe = null;
        if (_bezeichnung_1 != null) {
            _bezeichnungKennbuchstabe = _bezeichnung_1.getBezeichnungKennbuchstabe();
        }
        ENUMBezeichnungKennbuchstabe _wert_1 = null;
        if (_bezeichnungKennbuchstabe != null) {
            _wert_1 = _bezeichnungKennbuchstabe.getWert();
        }
        String _string = null;
        if (_wert_1 != null) {
            _string = _wert_1.toString();
        }
        String kennbuchstabe = _string;
        Bezeichnung_Element_AttributeGroup _bezeichnung_2 = null;
        if (gleisabschnitt != null) {
            _bezeichnung_2 = gleisabschnitt.getBezeichnung();
        }
        Oertlicher_Elementname_TypeClass _oertlicherElementname = null;
        if (_bezeichnung_2 != null) {
            _oertlicherElementname = _bezeichnung_2.getOertlicherElementname();
        }
        String _wert_2 = null;
        if (_oertlicherElementname != null) {
            _wert_2 = _oertlicherElementname.getWert();
        }
        String elementbezeichner = _wert_2;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(kennzahl);
        _builder.append(kennbuchstabe);
        _builder.append(elementbezeichner);
        return _builder.toString();
    }

    public static List<Schaltmittel_Zuordnung> getSchaltmittelZuordnungen(FMA_Anlage anlage) {
        Functions.Function1 _function = it -> {
            ID_Schalter_TypeClass _iDSchalter = it.getIDSchalter();
            Basis_Objekt _value = null;
            if (_iDSchalter != null) {
                _value = _iDSchalter.getValue();
            }
            Identitaet_TypeClass _identitaet = null;
            if (_value != null) {
                _identitaet = _value.getIdentitaet();
            }
            String _wert = null;
            if (_identitaet != null) {
                _wert = _identitaet.getWert();
            }
            Identitaet_TypeClass _identitaet_1 = null;
            if (anlage != null) {
                _identitaet_1 = anlage.getIdentitaet();
            }
            String _wert_1 = null;
            if (_identitaet_1 != null) {
                _wert_1 = _identitaet_1.getWert();
            }
            return Objects.equals(_wert, _wert_1);
        };
        return IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)BasisAttributExtensions.getContainer((EObject)anlage).getSchaltmittelZuordnung(), (Functions.Function1)_function));
    }

    public static List<Gleis_Schaltgruppe> getGleisSchaltgruppen(FMA_Anlage anlage) {
        ID_Gleis_Abschnitt_TypeClass _iDGleisAbschnitt = anlage.getIDGleisAbschnitt();
        Gleis_Abschnitt _value = null;
        if (_iDGleisAbschnitt != null) {
            _value = _iDGleisAbschnitt.getValue();
        }
        Gleis_Abschnitt gleisabschnitt = _value;
        Functions.Function1 _function = it -> BereichObjektExtensions.intersectsStrictly((Bereich_Objekt)it, (Bereich_Objekt)gleisabschnitt);
        return IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)BasisAttributExtensions.getContainer((EObject)anlage).getGleisSchaltgruppe(), (Functions.Function1)_function));
    }

    public static boolean isBelongToControlArea(FMA_Anlage anlage, Stell_Bereich area) {
        ID_Gleis_Abschnitt_TypeClass _iDGleisAbschnitt = null;
        if (anlage != null) {
            _iDGleisAbschnitt = anlage.getIDGleisAbschnitt();
        }
        Gleis_Abschnitt _value = null;
        if (_iDGleisAbschnitt != null) {
            _value = _iDGleisAbschnitt.getValue();
        }
        Gleis_Abschnitt gleisAbschnitt = _value;
        BigDecimal overlappingDistance = GleisAbschnittExtensions.getOverlappingDistance(gleisAbschnitt, (List<Bereich_Objekt_Teilbereich_AttributeGroup>)area.getBereichObjektTeilbereich());
        int _compareTo = BereichObjektExtensions.getLength((Bereich_Objekt)area).divide(BigDecimal.TWO).compareTo(overlappingDistance);
        return _compareTo < 0;
    }

    public static Stell_Bereich getRelevantAreaControl(FMA_Anlage anlage) {
        ID_Gleis_Abschnitt_TypeClass _iDGleisAbschnitt = null;
        if (anlage != null) {
            _iDGleisAbschnitt = anlage.getIDGleisAbschnitt();
        }
        Gleis_Abschnitt _value = null;
        if (_iDGleisAbschnitt != null) {
            _value = _iDGleisAbschnitt.getValue();
        }
        Gleis_Abschnitt gleisAbschnitt = _value;
        return BereichObjektExtensions.getMostOverlapControlArea((Bereich_Objekt)gleisAbschnitt);
    }
}

