/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.ppmodel.extensions;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.set.basis.geometry.Chord;
import org.eclipse.set.basis.geometry.Circle;
import org.eclipse.set.basis.geometry.GeoPosition;
import org.eclipse.set.basis.geometry.Geometries;
import org.eclipse.set.basis.geometry.GeometryException;
import org.eclipse.set.basis.geometry.SegmentPosition;
import org.eclipse.set.basis.graph.DirectedElement;
import org.eclipse.set.model.planpro.BasisTypen.ENUMWirkrichtung;
import org.eclipse.set.model.planpro.Basisobjekte.Basis_Objekt;
import org.eclipse.set.model.planpro.Geodaten.ENUMGEOForm;
import org.eclipse.set.model.planpro.Geodaten.ENUMGEOKoordinatensystem;
import org.eclipse.set.model.planpro.Geodaten.GEO_Form_TypeClass;
import org.eclipse.set.model.planpro.Geodaten.GEO_Kante;
import org.eclipse.set.model.planpro.Geodaten.GEO_Kante_Allg_AttributeGroup;
import org.eclipse.set.model.planpro.Geodaten.GEO_Knoten;
import org.eclipse.set.model.planpro.Geodaten.GEO_Radius_A_TypeClass;
import org.eclipse.set.model.planpro.Geodaten.GEO_Radius_B_TypeClass;
import org.eclipse.set.model.planpro.Geodaten.TOP_Kante;
import org.eclipse.set.model.planpro.Verweise.ID_GEO_Art_TypeClass;
import org.eclipse.set.model.planpro.Verweise.ID_GEO_Knoten_TypeClass;
import org.eclipse.set.ppmodel.extensions.BasisAttributExtensions;
import org.eclipse.set.ppmodel.extensions.BasisObjektExtensions;
import org.eclipse.set.ppmodel.extensions.GeoKnotenExtensions;
import org.eclipse.set.ppmodel.extensions.geometry.GEOKanteGeometryExtensions;
import org.eclipse.set.ppmodel.extensions.utils.LineStringExtensions;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.locationtech.jts.algorithm.distance.DistanceToPoint;
import org.locationtech.jts.algorithm.distance.PointPairDistance;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoKanteExtensions
extends BasisObjektExtensions {
    private static final Logger logger = LoggerFactory.getLogger(GeoKanteExtensions.class);

    public static GeoPosition getCoordinate(GEO_Kante geoKante, GEO_Knoten startGeoKnoten, double abstand, double seitlicherAbstand, ENUMWirkrichtung wirkrichtung) {
        LineString geometry = GEOKanteGeometryExtensions.getGeometry(geoKante);
        double edgeLength = Math.abs(geoKante.getGEOKanteAllg().getGEOLaenge().getWert().doubleValue());
        double distance = abstand;
        double geoLength = geometry.getLength();
        if (geoLength < edgeLength) {
            distance = abstand * (geoLength / edgeLength);
        }
        SegmentPosition position = Geometries.getSegmentPosition((LineString)geometry, (Coordinate)GeoKnotenExtensions.getCoordinate(startGeoKnoten), (double)distance);
        LineSegment tangent = GeoKanteExtensions.getTangent(geoKante, position);
        return GeoKanteExtensions.getCoordinate(tangent, position, seitlicherAbstand, wirkrichtung);
    }

    public static GeoPosition getCoordinate(LineSegment tangent, SegmentPosition position, double seitlicherAbstand, ENUMWirkrichtung wirkrichtung) {
        LineSegment lateralSegement = Geometries.clone((LineSegment)tangent);
        Geometries.translate((LineSegment)lateralSegement, (Coordinate)lateralSegement.p0, (Coordinate)position.getCoordinate());
        double angle = 0.0;
        angle = seitlicherAbstand < 0.0 ? 90.0 : -90.0;
        Geometries.turn((LineSegment)lateralSegement, (double)angle);
        Geometries.scale((LineSegment)lateralSegement, (double)Math.abs(seitlicherAbstand));
        DirectedElement directedLineSegment = position.getDirectedLineSegment();
        LineSegment direction = Geometries.clone((LineSegment)((LineSegment)directedLineSegment.getElement()));
        double rotation = Geometries.getRotationToVertical((LineSegment)direction);
        return new GeoPosition(lateralSegement.p1, rotation, wirkrichtung);
    }

    public static boolean isCRSConsistent(GEO_Kante geoKante) {
        ENUMGEOKoordinatensystem crsB;
        ENUMGEOKoordinatensystem crsA = GeoKnotenExtensions.getCRS(GeoKanteExtensions.getGeoKnotenA(geoKante));
        return crsA == (crsB = GeoKnotenExtensions.getCRS(GeoKanteExtensions.getGeoKnotenB(geoKante)));
    }

    public static GEO_Knoten getHead(DirectedElement<GEO_Kante> edge) {
        GEO_Knoten _xifexpression = null;
        boolean _isForwards = edge.isForwards();
        if (_isForwards) {
            GEO_Kante _element = null;
            if (edge != null) {
                _element = (GEO_Kante)edge.getElement();
            }
            GEO_Knoten _geoKnotenB = null;
            if (_element != null) {
                _geoKnotenB = GeoKanteExtensions.getGeoKnotenB(_element);
            }
            _xifexpression = _geoKnotenB;
        } else {
            GEO_Kante _element_1 = null;
            if (edge != null) {
                _element_1 = (GEO_Kante)edge.getElement();
            }
            GEO_Knoten _geoKnotenA = null;
            if (_element_1 != null) {
                _geoKnotenA = GeoKanteExtensions.getGeoKnotenA(_element_1);
            }
            _xifexpression = _geoKnotenA;
        }
        return _xifexpression;
    }

    public static GEO_Knoten getTail(DirectedElement<GEO_Kante> edge) {
        GEO_Knoten _xifexpression = null;
        boolean _isForwards = edge.isForwards();
        if (_isForwards) {
            GEO_Kante _element = null;
            if (edge != null) {
                _element = (GEO_Kante)edge.getElement();
            }
            GEO_Knoten _geoKnotenA = null;
            if (_element != null) {
                _geoKnotenA = GeoKanteExtensions.getGeoKnotenA(_element);
            }
            _xifexpression = _geoKnotenA;
        } else {
            GEO_Kante _element_1 = null;
            if (edge != null) {
                _element_1 = (GEO_Kante)edge.getElement();
            }
            GEO_Knoten _geoKnotenB = null;
            if (_element_1 != null) {
                _geoKnotenB = GeoKanteExtensions.getGeoKnotenB(_element_1);
            }
            _xifexpression = _geoKnotenB;
        }
        return _xifexpression;
    }

    public static GEO_Knoten getGeoKnotenA(GEO_Kante kante) {
        ID_GEO_Knoten_TypeClass _iDGEOKnotenA = kante.getIDGEOKnotenA();
        GEO_Knoten _value = null;
        if (_iDGEOKnotenA != null) {
            _value = _iDGEOKnotenA.getValue();
        }
        return _value;
    }

    public static GEO_Knoten getGeoKnotenB(GEO_Kante kante) {
        ID_GEO_Knoten_TypeClass _iDGEOKnotenB = kante.getIDGEOKnotenB();
        GEO_Knoten _value = null;
        if (_iDGEOKnotenB != null) {
            _value = _iDGEOKnotenB.getValue();
        }
        return _value;
    }

    public static boolean isLoop(GEO_Kante kante) {
        String _wert = GeoKanteExtensions.getGeoKnotenA(kante).getIdentitaet().getWert();
        String _wert_1 = GeoKanteExtensions.getGeoKnotenB(kante).getIdentitaet().getWert();
        return Objects.equals(_wert, _wert_1);
    }

    public static TOP_Kante topKante(GEO_Kante kante) {
        Basis_Objekt result = GeoKanteExtensions.getGeoArt(kante);
        if (result instanceof TOP_Kante) {
            return (TOP_Kante)result;
        }
        return null;
    }

    public static Basis_Objekt getGeoArt(GEO_Kante kante) {
        ID_GEO_Art_TypeClass _iDGEOArt = kante.getIDGEOArt();
        Basis_Objekt _value = null;
        if (_iDGEOArt != null) {
            _value = _iDGEOArt.getValue();
        }
        return _value;
    }

    public static GEO_Knoten getOpposite(GEO_Kante kante, GEO_Knoten geoKnoten) {
        String _wert_3;
        String _wert_1;
        String _wert = GeoKanteExtensions.getGeoKnotenA(kante).getIdentitaet().getWert();
        boolean _equals = Objects.equals(_wert, _wert_1 = geoKnoten.getIdentitaet().getWert());
        if (_equals) {
            return GeoKanteExtensions.getGeoKnotenB(kante);
        }
        String _wert_2 = GeoKanteExtensions.getGeoKnotenB(kante).getIdentitaet().getWert();
        boolean _equals_1 = Objects.equals(_wert_2, _wert_3 = geoKnoten.getIdentitaet().getWert());
        if (_equals_1) {
            return GeoKanteExtensions.getGeoKnotenA(kante);
        }
        String _wert_4 = geoKnoten.getIdentitaet().getWert();
        String _plus = _wert_4 + " is no node of ";
        String _wert_5 = kante.getIdentitaet().getWert();
        String _plus_1 = _plus + _wert_5;
        throw new IllegalArgumentException(_plus_1);
    }

    public static LineSegment getTangent(GEO_Kante geoKante, SegmentPosition position) {
        ENUMGEOForm form = geoKante.getGEOKanteAllg().getGEOForm().getWert();
        if (form != null) {
            switch (form) {
                case ENUMGEO_FORM_BLOSSKURVE: 
                case ENUMGEO_FORM_BLOSS_EINFACH_GESCHWUNGEN: 
                case ENUMGEO_FORM_GERADE: 
                case ENUMGEO_FORM_KLOTHOIDE: 
                case ENUMGEO_FORM_KM_SPRUNG: 
                case ENUMGEO_FORM_RICHTGERADE_KNICK_AM_ENDE_200_GON: 
                case ENUMGEO_FORM_SONSTIGE: {
                    return (LineSegment)position.getDirectedLineSegment().getElement();
                }
                case ENUMGEO_FORM_BOGEN: {
                    double radius = geoKante.getGEOKanteAllg().getGEORadiusA().getWert().doubleValue();
                    Coordinate _coordinate = GeoKnotenExtensions.getCoordinate(GeoKanteExtensions.getGeoKnotenA(geoKante));
                    Coordinate _coordinate_1 = GeoKnotenExtensions.getCoordinate(GeoKanteExtensions.getGeoKnotenB(geoKante));
                    double _abs = Math.abs(radius);
                    Chord.Orientation _xifexpression = null;
                    _xifexpression = radius < 0.0 ? Chord.Orientation.ARC_RIGHT : Chord.Orientation.ARC_LEFT;
                    Chord _chord = new Chord(_coordinate, _coordinate_1, _abs, _xifexpression);
                    LineSegment tangent = new Circle(_chord).getTangent(position.getCoordinate());
                    if (radius > 0.0 && position.getDirectedLineSegment().isForwards()) {
                        Geometries.turn((LineSegment)tangent, (double)180.0);
                    }
                    if (radius < 0.0 && !position.getDirectedLineSegment().isForwards()) {
                        Geometries.turn((LineSegment)tangent, (double)180.0);
                    }
                    return tangent;
                }
            }
            logger.warn("Form {} not supported.", (Object)form.getName());
            return (LineSegment)position.getDirectedLineSegment().getElement();
        }
        logger.warn("Form {} not supported.", (Object)form.getName());
        return (LineSegment)position.getDirectedLineSegment().getElement();
    }

    public static LineSegment getSegmentWith(GEO_Kante edge, Coordinate coordinate, double tolerance) {
        try {
            return GeoKanteExtensions.getSegmentWith(LineStringExtensions.getSegments(GEOKanteGeometryExtensions.getGeometry(edge)), coordinate, tolerance);
        }
        catch (Throwable _t) {
            if (_t instanceof GeometryException) {
                GeometryException e = (GeometryException)_t;
                throw new RuntimeException((Throwable)e);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public static LineSegment getSegmentWith(DirectedElement<GEO_Kante> directedEdge, Coordinate coordinate, double tolerance) {
        try {
            return GeoKanteExtensions.getSegmentWith(LineStringExtensions.getSegments(GEOKanteGeometryExtensions.getGeometry(directedEdge)), coordinate, tolerance);
        }
        catch (Throwable _t) {
            if (_t instanceof GeometryException) {
                GeometryException e = (GeometryException)_t;
                throw new RuntimeException((Throwable)e);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    private static LineSegment getSegmentWith(List<LineSegment> segments, Coordinate coordinate, double tolerance) {
        for (LineSegment segment : segments) {
            boolean _lessEqualsThan;
            PointPairDistance result = new PointPairDistance();
            DistanceToPoint.computeDistance((LineSegment)segment, (Coordinate)coordinate, (PointPairDistance)result);
            double _distance = result.getDistance();
            boolean bl = _lessEqualsThan = _distance <= tolerance;
            if (!_lessEqualsThan) continue;
            return segment;
        }
        return null;
    }

    public static Iterable<Pair<Coordinate, Double>> getCoordinatesWithDistances(GEO_Kante geoKante) {
        ArrayList<Pair<Coordinate, Double>> result = new ArrayList<Pair<Coordinate, Double>>();
        Coordinate[] coordinates = GEOKanteGeometryExtensions.getGeometry(geoKante).getCoordinates();
        BasisAttributExtensions.getContainer((EObject)geoKante);
        Coordinate lastCoordinate = (Coordinate)IterableExtensions.head((Iterable)((Iterable)Conversions.doWrapArray((Object)coordinates)));
        double distance = 0.0;
        Pair _mappedTo = Pair.of((Object)lastCoordinate, (Object)distance);
        result.add(_mappedTo);
        Iterable _tail = IterableExtensions.tail((Iterable)((Iterable)Conversions.doWrapArray((Object)coordinates)));
        for (Coordinate coordinate : _tail) {
            double _distance = distance;
            double _distance_1 = lastCoordinate.distance(coordinate);
            distance = _distance + _distance_1;
            lastCoordinate = coordinate;
            Pair _mappedTo_1 = Pair.of((Object)lastCoordinate, (Object)distance);
            result.add((Pair<Coordinate, Double>)_mappedTo_1);
        }
        return result;
    }

    public static Double getRadiusAtKnoten(GEO_Kante geoKante, GEO_Knoten geoKnoten) {
        boolean _tripleEquals_1;
        boolean _tripleEquals;
        GEO_Kante_Allg_AttributeGroup _gEOKanteAllg = null;
        if (geoKante != null) {
            _gEOKanteAllg = geoKante.getGEOKanteAllg();
        }
        GEO_Form_TypeClass _gEOForm = null;
        if (_gEOKanteAllg != null) {
            _gEOForm = _gEOKanteAllg.getGEOForm();
        }
        ENUMGEOForm _wert = null;
        if (_gEOForm != null) {
            _wert = _gEOForm.getWert();
        }
        if (_wert != null) {
            boolean _tripleEquals_12;
            boolean _tripleEquals2;
            switch (_wert) {
                case ENUMGEO_FORM_GERADE: {
                    return 0.0;
                }
                case ENUMGEO_FORM_BOGEN: 
                case ENUMGEO_FORM_RICHTGERADE_KNICK_AM_ENDE_200_GON: {
                    Number _elvis = null;
                    GEO_Kante_Allg_AttributeGroup _gEOKanteAllg_1 = null;
                    if (geoKante != null) {
                        _gEOKanteAllg_1 = geoKante.getGEOKanteAllg();
                    }
                    GEO_Radius_A_TypeClass _gEORadiusA = null;
                    if (_gEOKanteAllg_1 != null) {
                        _gEORadiusA = _gEOKanteAllg_1.getGEORadiusA();
                    }
                    BigDecimal _wert_1 = null;
                    if (_gEORadiusA != null) {
                        _wert_1 = _gEORadiusA.getWert();
                    }
                    _elvis = _wert_1 != null ? _wert_1 : Integer.valueOf(0);
                    return _elvis.doubleValue();
                }
            }
            GEO_Knoten _geoKnotenA = GeoKanteExtensions.getGeoKnotenA(geoKante);
            boolean bl = _tripleEquals2 = geoKnoten == _geoKnotenA;
            if (_tripleEquals2) {
                Number _elvis_1 = null;
                GEO_Kante_Allg_AttributeGroup _gEOKanteAllg_2 = null;
                if (geoKante != null) {
                    _gEOKanteAllg_2 = geoKante.getGEOKanteAllg();
                }
                GEO_Radius_A_TypeClass _gEORadiusA_1 = null;
                if (_gEOKanteAllg_2 != null) {
                    _gEORadiusA_1 = _gEOKanteAllg_2.getGEORadiusA();
                }
                BigDecimal _wert_2 = null;
                if (_gEORadiusA_1 != null) {
                    _wert_2 = _gEORadiusA_1.getWert();
                }
                _elvis_1 = _wert_2 != null ? _wert_2 : Integer.valueOf(0);
                return _elvis_1.doubleValue();
            }
            GEO_Knoten _geoKnotenB = GeoKanteExtensions.getGeoKnotenB(geoKante);
            boolean bl2 = _tripleEquals_12 = geoKnoten == _geoKnotenB;
            if (_tripleEquals_12) {
                Number _elvis_2 = null;
                GEO_Kante_Allg_AttributeGroup _gEOKanteAllg_3 = null;
                if (geoKante != null) {
                    _gEOKanteAllg_3 = geoKante.getGEOKanteAllg();
                }
                GEO_Radius_B_TypeClass _gEORadiusB = null;
                if (_gEOKanteAllg_3 != null) {
                    _gEORadiusB = _gEOKanteAllg_3.getGEORadiusB();
                }
                BigDecimal _wert_3 = null;
                if (_gEORadiusB != null) {
                    _wert_3 = _gEORadiusB.getWert();
                }
                _elvis_2 = _wert_3 != null ? _wert_3 : Integer.valueOf(0);
                return _elvis_2.doubleValue();
            }
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("GEOKnoten: ");
            String _wert_4 = geoKnoten.getIdentitaet().getWert();
            _builder.append(_wert_4);
            _builder.append(" doesn't belong to GEOKanten: ");
            String _wert_5 = geoKante.getIdentitaet().getWert();
            _builder.append(_wert_5);
            throw new IllegalArgumentException(_builder.toString());
        }
        GEO_Knoten _geoKnotenA = GeoKanteExtensions.getGeoKnotenA(geoKante);
        boolean bl = _tripleEquals = geoKnoten == _geoKnotenA;
        if (_tripleEquals) {
            Number _elvis_1 = null;
            GEO_Kante_Allg_AttributeGroup _gEOKanteAllg_2 = null;
            if (geoKante != null) {
                _gEOKanteAllg_2 = geoKante.getGEOKanteAllg();
            }
            GEO_Radius_A_TypeClass _gEORadiusA_1 = null;
            if (_gEOKanteAllg_2 != null) {
                _gEORadiusA_1 = _gEOKanteAllg_2.getGEORadiusA();
            }
            BigDecimal _wert_2 = null;
            if (_gEORadiusA_1 != null) {
                _wert_2 = _gEORadiusA_1.getWert();
            }
            _elvis_1 = _wert_2 != null ? _wert_2 : Integer.valueOf(0);
            return _elvis_1.doubleValue();
        }
        GEO_Knoten _geoKnotenB = GeoKanteExtensions.getGeoKnotenB(geoKante);
        boolean bl3 = _tripleEquals_1 = geoKnoten == _geoKnotenB;
        if (_tripleEquals_1) {
            Number _elvis_2 = null;
            GEO_Kante_Allg_AttributeGroup _gEOKanteAllg_3 = null;
            if (geoKante != null) {
                _gEOKanteAllg_3 = geoKante.getGEOKanteAllg();
            }
            GEO_Radius_B_TypeClass _gEORadiusB = null;
            if (_gEOKanteAllg_3 != null) {
                _gEORadiusB = _gEOKanteAllg_3.getGEORadiusB();
            }
            BigDecimal _wert_3 = null;
            if (_gEORadiusB != null) {
                _wert_3 = _gEORadiusB.getWert();
            }
            _elvis_2 = _wert_3 != null ? _wert_3 : Integer.valueOf(0);
            return _elvis_2.doubleValue();
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("GEOKnoten: ");
        String _wert_4 = geoKnoten.getIdentitaet().getWert();
        _builder.append(_wert_4);
        _builder.append(" doesn't belong to GEOKanten: ");
        String _wert_5 = geoKante.getIdentitaet().getWert();
        _builder.append(_wert_5);
        throw new IllegalArgumentException(_builder.toString());
    }
}

