/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.ppmodel.extensions;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.set.basis.Lists;
import org.eclipse.set.basis.geometry.GeoPosition;
import org.eclipse.set.basis.geometry.GeometryException;
import org.eclipse.set.model.planpro.BasisTypen.ENUMWirkrichtung;
import org.eclipse.set.model.planpro.Basisobjekte.Basis_Objekt;
import org.eclipse.set.model.planpro.Geodaten.ENUMGEOKoordinatensystem;
import org.eclipse.set.model.planpro.Geodaten.GEO_Kante;
import org.eclipse.set.model.planpro.Geodaten.GEO_Knoten;
import org.eclipse.set.model.planpro.Geodaten.GEO_Koordinatensystem_TypeClass;
import org.eclipse.set.model.planpro.Geodaten.GEO_Punkt;
import org.eclipse.set.model.planpro.Geodaten.GEO_Punkt_Allg_AttributeGroup;
import org.eclipse.set.model.planpro.Geodaten.TOP_Kante;
import org.eclipse.set.model.planpro.Verweise.ID_GEO_Knoten_TypeClass;
import org.eclipse.set.ppmodel.extensions.BasisAttributExtensions;
import org.eclipse.set.ppmodel.extensions.BasisObjektExtensions;
import org.eclipse.set.ppmodel.extensions.GeoKanteExtensions;
import org.eclipse.set.ppmodel.extensions.GeoPunktExtensions;
import org.eclipse.set.ppmodel.extensions.utils.CollectionExtensions;
import org.eclipse.set.ppmodel.extensions.utils.Debug;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.locationtech.jts.geom.Coordinate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoKnotenExtensions
extends BasisObjektExtensions {
    private static final Logger logger = LoggerFactory.getLogger(GeoKnotenExtensions.class);

    public static List<GEO_Punkt> getGeoPunkte(GEO_Knoten knoten) {
        Functions.Function1 _function = it -> {
            boolean _tripleNotEquals;
            boolean _and = false;
            ID_GEO_Knoten_TypeClass _iDGEOKnoten = it.getIDGEOKnoten();
            boolean bl = _tripleNotEquals = _iDGEOKnoten != null;
            if (!_tripleNotEquals) {
                _and = false;
            } else {
                boolean _equals;
                ID_GEO_Knoten_TypeClass _iDGEOKnoten_1 = it.getIDGEOKnoten();
                String _wert = null;
                if (_iDGEOKnoten_1 != null) {
                    _wert = _iDGEOKnoten_1.getWert();
                }
                String _wert_1 = knoten.getIdentitaet().getWert();
                _and = _equals = Objects.equals(_wert, _wert_1);
            }
            return _and;
        };
        return IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)BasisAttributExtensions.getContainer((EObject)knoten).getGEOPunkt(), (Functions.Function1)_function));
    }

    public static List<GEO_Kante> getGeoKantenOnTopKante(GEO_Knoten knoten, TOP_Kante topKante) {
        Functions.Function1 _function = geoKante -> GeoKnotenExtensions.isKnoten(knoten, geoKante) && Objects.equals(GeoKanteExtensions.topKante(geoKante), topKante);
        return IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)BasisAttributExtensions.getContainer((EObject)knoten).getGEOKante(), (Functions.Function1)_function));
    }

    public static boolean isKnoten(GEO_Knoten knoten, GEO_Kante geoKante) {
        return Objects.equals(GeoKanteExtensions.getGeoKnotenA(geoKante), knoten) || Objects.equals(GeoKanteExtensions.getGeoKnotenB(geoKante), knoten);
    }

    public static Coordinate getCoordinate(GEO_Knoten geoKnoten) {
        List<GEO_Punkt> geoPunkte = GeoKnotenExtensions.getGeoPunkte(geoKnoten);
        GeoKnotenExtensions.getGeoPunkt(geoPunkte, geoKnoten);
        GEO_Punkt geoPunkt = GeoKnotenExtensions.getGeoPunkt(geoPunkte, geoKnoten);
        return GeoPunktExtensions.getCoordinate(geoPunkt);
    }

    public static ENUMGEOKoordinatensystem getCRS(GEO_Knoten geoKnoten) {
        Functions.Function1 _function = it -> {
            GEO_Punkt_Allg_AttributeGroup _gEOPunktAllg = it.getGEOPunktAllg();
            GEO_Koordinatensystem_TypeClass _gEOKoordinatensystem = null;
            if (_gEOPunktAllg != null) {
                _gEOKoordinatensystem = _gEOPunktAllg.getGEOKoordinatensystem();
            }
            ENUMGEOKoordinatensystem _wert = null;
            if (_gEOKoordinatensystem != null) {
                _wert = _gEOKoordinatensystem.getWert();
            }
            return _wert;
        };
        ENUMGEOKoordinatensystem crs = (ENUMGEOKoordinatensystem)CollectionExtensions.getUniqueOrNull(IterableExtensions.toSet((Iterable)ListExtensions.map(GeoKnotenExtensions.getGeoPunkte(geoKnoten), (Functions.Function1)_function)));
        ENUMGEOKoordinatensystem _xifexpression = null;
        _xifexpression = crs != null ? crs : ENUMGEOKoordinatensystem.ENUMGEO_KOORDINATENSYSTEM_SONSTIGE;
        return _xifexpression;
    }

    public static GEO_Punkt getGeoPunkt(List<GEO_Punkt> geoPunkte, GEO_Knoten geoKnoten) {
        boolean _notEquals;
        int _size = geoPunkte.size();
        boolean bl = _notEquals = _size != 1;
        if (_notEquals) {
            String _format = String.format("Ambiguous Geo Punkte (%d) for Geo Knoten %s", geoPunkte.size(), geoKnoten.getIdentitaet().getWert());
            throw new GeometryException(_format);
        }
        return geoPunkte.get(0);
    }

    static GeoPosition getCoordinate(GEO_Knoten startGeoKnoten, GEO_Kante lastGeoKante, Basis_Objekt parentEdge, double abstand, double seitlicherAbstand, ENUMWirkrichtung wirkrichtung) {
        List geoKantenOnStart = null;
        geoKantenOnStart = parentEdge instanceof TOP_Kante ? IterableExtensions.toList(GeoKnotenExtensions.getGeoKantenOnTopKante(startGeoKnoten, (TOP_Kante)parentEdge)) : IterableExtensions.toList(GeoKnotenExtensions.getGeoKanten(startGeoKnoten));
        List geoKantenOnStartWithoutLoops = Lists.filter((List)geoKantenOnStart, (Predicate)new Predicate<GEO_Kante>(){

            public boolean apply(GEO_Kante input) {
                boolean isLoop = GeoKanteExtensions.isLoop(input);
                if (isLoop) {
                    logger.error("Ignore GEO Kante Loop {}", (Object)input.getIdentitaet().getWert());
                }
                return !isLoop;
            }
        });
        return GeoKnotenExtensions.getCoordinate(startGeoKnoten, lastGeoKante, geoKantenOnStartWithoutLoops, parentEdge, abstand, seitlicherAbstand, wirkrichtung);
    }

    private static GeoPosition getCoordinate(GEO_Knoten startGeoKnoten, GEO_Kante lastGeoKante, List<GEO_Kante> geoKantenOnStart, Basis_Objekt parentEdge, double abstand, double seitlicherAbstand, ENUMWirkrichtung wirkrichtung) {
        boolean _notEquals;
        geoKantenOnStart.remove(lastGeoKante);
        int _size = geoKantenOnStart.size();
        boolean bl = _notEquals = _size != 1;
        if (_notEquals) {
            logger.debug("Start GEO Knoten: {}", (Object)Debug.debugString(startGeoKnoten));
            logger.debug("TOP Kante/Strecke: {}", (Object)Debug.debugString(parentEdge));
            logger.debug("Last GEO Kante: {}", (Object)Debug.debugString(lastGeoKante));
            logger.debug("Next GEO Kanten: {}", (Object)Debug.debugString(geoKantenOnStart));
            logger.debug("Abstand: {}", (Object)abstand);
            String _format = String.format("No GEO Kanten continuation at %s", startGeoKnoten.getIdentitaet().getWert());
            throw new GeometryException(_format);
        }
        GEO_Kante geoKante = geoKantenOnStart.get(0);
        double geoKanteLength = geoKante.getGEOKanteAllg().getGEOLaenge().getWert().doubleValue();
        if (abstand <= geoKanteLength) {
            return GeoKanteExtensions.getCoordinate(geoKante, startGeoKnoten, abstand, seitlicherAbstand, wirkrichtung);
        }
        return GeoKnotenExtensions.getCoordinate(GeoKanteExtensions.getOpposite(geoKante, startGeoKnoten), geoKante, parentEdge, abstand - geoKanteLength, seitlicherAbstand, wirkrichtung);
    }

    public static Iterable<Pair<GEO_Kante, Double>> getGeoKantenWithDistance(GEO_Knoten startGeoKnoten, TOP_Kante topKante) {
        Functions.Function1 _function = k -> {
            TOP_Kante _pKante = GeoKanteExtensions.topKante(k);
            return Objects.equals(_pKante, topKante);
        };
        List geoKanten = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)BasisAttributExtensions.getContainer((EObject)topKante).getGEOKante(), (Functions.Function1)_function));
        return GeoKnotenExtensions.getGeoKantenWithDistance(startGeoKnoten, null, geoKanten, 0.0);
    }

    private static Iterable<Pair<GEO_Kante, Double>> getGeoKantenWithDistance(GEO_Knoten startGeoKnoten, GEO_Kante lastGeoKante, List<GEO_Kante> geoKanten, double distance) {
        boolean _notEquals;
        geoKanten.remove(lastGeoKante);
        boolean _isEmpty = geoKanten.isEmpty();
        if (_isEmpty) {
            return Collections.unmodifiableList(CollectionLiterals.newArrayList());
        }
        Functions.Function1 _function = geoKante -> GeoKnotenExtensions.isKnoten(startGeoKnoten, geoKante);
        Iterable edges = IterableExtensions.filter(geoKanten, (Functions.Function1)_function);
        int _size = IterableExtensions.size((Iterable)edges);
        boolean bl = _notEquals = _size != 1;
        if (_notEquals) {
            logger.debug("Start GEO Knoten: {}", (Object)Debug.debugString(startGeoKnoten));
            logger.debug("Last GEO Kante: {}", (Object)Debug.debugString(lastGeoKante));
            logger.debug("Next GEO Kanten: {}", (Object)Debug.debugString(edges));
            String _format = String.format("No GEO Kanten continuation at %s", startGeoKnoten.getIdentitaet().getWert());
            throw new GeometryException(_format);
        }
        GEO_Kante geoKante2 = ((GEO_Kante[])Conversions.unwrapArray((Object)edges, GEO_Kante.class))[0];
        double geoKanteLength = geoKante2.getGEOKanteAllg().getGEOLaenge().getWert().doubleValue();
        Pair _mappedTo = Pair.of((Object)geoKante2, (Object)distance);
        Iterable<Pair<GEO_Kante, Double>> _geoKantenWithDistance = GeoKnotenExtensions.getGeoKantenWithDistance(GeoKanteExtensions.getOpposite(geoKante2, startGeoKnoten), geoKante2, geoKanten, distance + geoKanteLength);
        return Iterables.concat(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Pair[]{_mappedTo})), _geoKantenWithDistance);
    }

    public static Iterable<GEO_Kante> getGeoKanten(GEO_Knoten geoKnoten) {
        Functions.Function1 _function = kante -> {
            String _wert_1;
            boolean _equals;
            boolean _or = false;
            ID_GEO_Knoten_TypeClass _iDGEOKnotenA = kante.getIDGEOKnotenA();
            String _wert = null;
            if (_iDGEOKnotenA != null) {
                _wert = _iDGEOKnotenA.getWert();
            }
            if (_equals = Objects.equals(_wert, _wert_1 = geoKnoten.getIdentitaet().getWert())) {
                _or = true;
            } else {
                boolean _equals_1;
                ID_GEO_Knoten_TypeClass _iDGEOKnotenB = kante.getIDGEOKnotenB();
                String _wert_2 = null;
                if (_iDGEOKnotenB != null) {
                    _wert_2 = _iDGEOKnotenB.getWert();
                }
                String _wert_3 = geoKnoten.getIdentitaet().getWert();
                _or = _equals_1 = Objects.equals(_wert_2, _wert_3);
            }
            return _or;
        };
        return IterableExtensions.filter((Iterable)BasisAttributExtensions.getContainer((EObject)geoKnoten).getGEOKante(), (Functions.Function1)_function);
    }

    public static Set<TOP_Kante> getTopKanten(GEO_Knoten geoKnoten) {
        Functions.Function1 _function = it -> GeoKanteExtensions.topKante(it);
        return IterableExtensions.toSet((Iterable)IterableExtensions.map(GeoKnotenExtensions.getGeoKanten(geoKnoten), (Functions.Function1)_function));
    }
}

