/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.ppmodel.extensions;

import java.util.List;
import java.util.Optional;
import java.util.stream.StreamSupport;
import org.eclipse.set.model.planpro.PlanPro.ENUMUntergewerkArt;
import org.eclipse.set.model.planpro.PlanPro.PlanPro_Schnittstelle;
import org.eclipse.set.model.planpro.PlanPro.Planung_G_Allg_AttributeGroup;
import org.eclipse.set.model.planpro.PlanPro.Planung_Gruppe;
import org.eclipse.set.model.planpro.PlanPro.Untergewerk_Art_TypeClass;
import org.eclipse.set.ppmodel.extensions.PlanProSchnittstelleExtensions;
import org.eclipse.set.ppmodel.extensions.utils.IterableExtensions;

public class PlanungGruppeExtensions {
    private PlanungGruppeExtensions() {
    }

    public static Optional<Planung_Gruppe> getPlanungGruppe(PlanPro_Schnittstelle schnittStelle) {
        return PlanungGruppeExtensions.getPlanungGruppe(schnittStelle, "");
    }

    public static Optional<Planung_Gruppe> getPlanungGruppe(PlanPro_Schnittstelle schnittStelle, ENUMUntergewerkArt subworkType) {
        return PlanungGruppeExtensions.getPlanungGruppe(schnittStelle, subworkType.getLiteral(), "");
    }

    public static Optional<Planung_Gruppe> getPlanungGruppe(PlanPro_Schnittstelle schnittStelle, String subworkType) {
        return PlanungGruppeExtensions.getPlanungGruppe(schnittStelle, subworkType, "");
    }

    public static Optional<Planung_Gruppe> getPlanungGruppe(PlanPro_Schnittstelle schnittStelle, ENUMUntergewerkArt subworkType, String guid) {
        return PlanungGruppeExtensions.getPlanungGruppe(schnittStelle, subworkType.getLiteral(), guid);
    }

    public static Optional<Planung_Gruppe> getPlanungGruppe(PlanPro_Schnittstelle schnittStelle, String subworkType, String guid) {
        Optional<Iterable<Planung_Gruppe>> lstPlanungGruppes = PlanProSchnittstelleExtensions.getLSTPlanungGruppe(schnittStelle);
        if (lstPlanungGruppes.isEmpty()) {
            return Optional.empty();
        }
        if (subworkType == null) {
            return guid.isBlank() || guid.isEmpty() ? Optional.ofNullable(lstPlanungGruppes.get().iterator().next()) : StreamSupport.stream(lstPlanungGruppes.get().spliterator(), false).filter(group -> group.getIdentitaet().getWert().equals(guid)).findFirst();
        }
        List<Planung_Gruppe> relevantGroups = StreamSupport.stream(lstPlanungGruppes.get().spliterator(), false).filter(group -> group.getPlanungGAllg().getUntergewerkArt().getWert().getLiteral().equals(subworkType)).toList();
        return guid.isBlank() || guid.isEmpty() ? Optional.ofNullable(IterableExtensions.getFirstOrNull(relevantGroups)) : relevantGroups.stream().filter(group -> group.getIdentitaet().getWert().equals(guid)).findFirst();
    }

    public static ENUMUntergewerkArt getUntergewerkArt(Planung_Gruppe group) {
        Planung_G_Allg_AttributeGroup planungGAllg = group.getPlanungGAllg();
        if (planungGAllg == null) {
            return null;
        }
        Untergewerk_Art_TypeClass untergewerkArt = planungGAllg.getUntergewerkArt();
        if (untergewerkArt == null) {
            return null;
        }
        return untergewerkArt.getWert();
    }
}

