/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.ppmodel.extensions;

import com.google.common.collect.Iterables;
import com.google.common.collect.Range;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.eclipse.set.basis.graph.DirectedEdge;
import org.eclipse.set.basis.graph.TopPoint;
import org.eclipse.set.core.services.Services;
import org.eclipse.set.model.planpro.BasisTypen.ENUMWirkrichtung;
import org.eclipse.set.model.planpro.Basisobjekte.Bereich_Objekt;
import org.eclipse.set.model.planpro.Basisobjekte.Bereich_Objekt_Teilbereich_AttributeGroup;
import org.eclipse.set.model.planpro.Basisobjekte.Punkt_Objekt;
import org.eclipse.set.model.planpro.Basisobjekte.Punkt_Objekt_TOP_Kante_AttributeGroup;
import org.eclipse.set.model.planpro.Basisobjekte.Wirkrichtung_TypeClass;
import org.eclipse.set.model.planpro.Geodaten.Strecke;
import org.eclipse.set.model.planpro.Geodaten.TOP_Kante;
import org.eclipse.set.model.planpro.Geodaten.TOP_Knoten;
import org.eclipse.set.model.planpro.Ortung.FMA_Komponente;
import org.eclipse.set.model.planpro.Ortung.FMA_Komponente_Achszaehlpunkt_AttributeGroup;
import org.eclipse.set.model.planpro.Signalbegriffe_Ril_301.Ra12;
import org.eclipse.set.model.planpro.Signale.Signal;
import org.eclipse.set.model.planpro.Verweise.ID_Strecke_TypeClass;
import org.eclipse.set.model.planpro.Verweise.ID_TOP_Kante_TypeClass;
import org.eclipse.set.ppmodel.extensions.BasisObjektExtensions;
import org.eclipse.set.ppmodel.extensions.BereichObjektExtensions;
import org.eclipse.set.ppmodel.extensions.ENUMWirkrichtungExtensions;
import org.eclipse.set.ppmodel.extensions.PunktObjektTopKanteExtensions;
import org.eclipse.set.ppmodel.extensions.SignalExtensions;
import org.eclipse.set.ppmodel.extensions.utils.CollectionExtensions;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.locationtech.jts.geom.Coordinate;

public class PunktObjektExtensions
extends BasisObjektExtensions {
    public static List<TOP_Kante> getTopKanten(Punkt_Objekt punktObjekt) {
        Functions.Function1 _function = it -> PunktObjektTopKanteExtensions.getTopKante(it);
        return ListExtensions.map(PunktObjektExtensions.getSinglePoints(punktObjekt), (Functions.Function1)_function);
    }

    public static boolean isAchszaehlpunkt(Punkt_Objekt punktObjekt) {
        if (punktObjekt instanceof FMA_Komponente) {
            FMA_Komponente_Achszaehlpunkt_AttributeGroup _fMAKomponenteAchszaehlpunkt = ((FMA_Komponente)punktObjekt).getFMAKomponenteAchszaehlpunkt();
            return _fMAKomponenteAchszaehlpunkt != null;
        }
        return false;
    }

    public static TOP_Knoten getTopKnoten(Punkt_Objekt punktObjekt) {
        Functions.Function1 _function = it -> PunktObjektTopKanteExtensions.getTopKnoten(it);
        return (TOP_Knoten)CollectionExtensions.getUniqueOrNull(IterableExtensions.toSet((Iterable)Iterables.concat((Iterable)ListExtensions.map(PunktObjektExtensions.getSinglePoints(punktObjekt), (Functions.Function1)_function))));
    }

    public static ENUMWirkrichtung getWirkrichtung(Punkt_Objekt punktObjekt, TOP_Kante topKante) {
        boolean _equals;
        Functions.Function1 _function = it -> {
            ID_TOP_Kante_TypeClass _iDTOPKante = it.getIDTOPKante();
            String _wert = null;
            if (_iDTOPKante != null) {
                _wert = _iDTOPKante.getWert();
            }
            String _wert_1 = topKante.getIdentitaet().getWert();
            return Objects.equals(_wert, _wert_1);
        };
        Functions.Function1 _function_1 = it -> {
            Wirkrichtung_TypeClass _wirkrichtung = it.getWirkrichtung();
            ENUMWirkrichtung _wert = null;
            if (_wirkrichtung != null) {
                _wert = _wirkrichtung.getWert();
            }
            return _wert;
        };
        Set wirkrichtungen = IterableExtensions.toSet((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter(PunktObjektExtensions.getSinglePoints(punktObjekt), (Functions.Function1)_function), (Functions.Function1)_function_1));
        int _size = wirkrichtungen.size();
        boolean bl = _equals = _size == 0;
        if (_equals) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Punkt Objekt ");
            String _wert = punktObjekt.getIdentitaet().getWert();
            _builder.append(_wert);
            _builder.append(" not located on TOP-Kante ");
            String _wert_1 = topKante.getIdentitaet().getWert();
            _builder.append(_wert_1);
            throw new IllegalArgumentException(_builder.toString());
        }
        return ((ENUMWirkrichtung[])Conversions.unwrapArray((Object)wirkrichtungen, ENUMWirkrichtung.class))[0];
    }

    public static boolean isInWirkrichtung(Punkt_Objekt punktObjekt, DirectedEdge<TOP_Kante, ?, Punkt_Objekt> edge) {
        return ENUMWirkrichtungExtensions.isInWirkrichtung(PunktObjektExtensions.getWirkrichtung(punktObjekt, (TOP_Kante)edge.getElement()), edge.isForwards());
    }

    public static Punkt_Objekt_TOP_Kante_AttributeGroup getSinglePoint(Punkt_Objekt punktObjekt) {
        return CollectionExtensions.getUnique(PunktObjektExtensions.getSinglePoints(punktObjekt));
    }

    public static List<Punkt_Objekt_TOP_Kante_AttributeGroup> getSinglePoints(Punkt_Objekt punktObjekt) {
        return punktObjekt.getPunktObjektTOPKante();
    }

    public static boolean isGrenzzeichen(Punkt_Objekt punktObjekt) {
        if (punktObjekt instanceof Signal) {
            return SignalExtensions.hasSignalbegriffID((Signal)punktObjekt, Ra12.class);
        }
        return false;
    }

    public static Coordinate getCoordinate(Punkt_Objekt punktObjekt) {
        return PunktObjektTopKanteExtensions.getCoordinate(PunktObjektExtensions.getSinglePoints(punktObjekt).get(0)).getCoordinate();
    }

    public static double rotation(Punkt_Objekt object) {
        ENUMWirkrichtung direction;
        Punkt_Objekt_TOP_Kante_AttributeGroup point = PunktObjektExtensions.getSinglePoints(object).get(0);
        Wirkrichtung_TypeClass _wirkrichtung = point.getWirkrichtung();
        ENUMWirkrichtung _wert = null;
        if (_wirkrichtung != null) {
            _wert = _wirkrichtung.getWert();
        }
        if ((direction = _wert) == null) {
            direction = ENUMWirkrichtung.ENUM_WIRKRICHTUNG_IN;
        }
        return PunktObjektTopKanteExtensions.getCoordinate(point, direction).getEffectiveRotation();
    }

    public static List<Strecke> getStrecken(Punkt_Objekt po) {
        Functions.Function1 _function = it -> {
            ID_Strecke_TypeClass _iDStrecke = it.getIDStrecke();
            Strecke _value = null;
            if (_iDStrecke != null) {
                _value = _iDStrecke.getValue();
            }
            return _value;
        };
        return IterableExtensions.toList((Iterable)IterableExtensions.filterNull((Iterable)ListExtensions.map((List)po.getPunktObjektStrecke(), (Functions.Function1)_function)));
    }

    public static Optional<Range<Double>> distanceToBereichObjekt(Punkt_Objekt po, Bereich_Objekt bo) {
        return PunktObjektExtensions.distanceToBereichObjekt(po, bo, Optional.empty());
    }

    public static Optional<Range<Double>> distanceToBereichObjekt(Punkt_Objekt po, Bereich_Objekt bo, boolean inDirection) {
        return PunktObjektExtensions.distanceToBereichObjekt(po, bo, Optional.of(inDirection));
    }

    private static Optional<Range<Double>> distanceToBereichObjekt(Punkt_Objekt po, Bereich_Objekt bo, Optional<Boolean> inDirection) {
        boolean _contains = BereichObjektExtensions.contains(bo, po);
        if (_contains) {
            return Optional.of(Range.singleton((Comparable)Double.valueOf(0.0)));
        }
        TopPoint poTopPoint = new TopPoint(po);
        Iterable boTopPoints = Iterables.concat(BereichObjektExtensions.toTopPoints(bo));
        Functions.Function1 _function = point -> {
            Optional _xifexpression = null;
            boolean _isEmpty = inDirection.isEmpty();
            _xifexpression = _isEmpty ? Services.getTopGraphService().findShortestDistance(poTopPoint, point) : Services.getTopGraphService().findShortestDistanceInDirection(poTopPoint, point, ((Boolean)inDirection.get()).booleanValue());
            return _xifexpression;
        };
        Functions.Function1 _function_1 = it -> it.isPresent();
        Functions.Function1 _function_2 = it -> ((BigDecimal)it.get()).doubleValue();
        Iterable doubleValues = IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.map((Iterable)boTopPoints, (Functions.Function1)_function), (Functions.Function1)_function_1), (Functions.Function1)_function_2);
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)doubleValues);
        if (_isNullOrEmpty) {
            return Optional.empty();
        }
        return Optional.of(Range.closed((Comparable)((Double)IterableExtensions.min((Iterable)doubleValues)), (Comparable)((Double)IterableExtensions.max((Iterable)doubleValues))));
    }

    public static Range<Double> distanceToTeilBereichObjekt(Punkt_Objekt po, Bereich_Objekt_Teilbereich_AttributeGroup botb) {
        boolean _contains = BereichObjektExtensions.contains(botb, PunktObjektExtensions.getSinglePoint(po));
        if (_contains) {
            return Range.singleton((Comparable)Double.valueOf(0.0));
        }
        TopPoint poTopPoint = new TopPoint(po);
        Functions.Function1 _function = it -> Services.getTopGraphService().findShortestDistance(poTopPoint, it);
        Functions.Function1 _function_1 = it -> it.isPresent();
        Functions.Function1 _function_2 = it -> ((BigDecimal)it.get()).doubleValue();
        Iterable distances = IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)ListExtensions.map(BereichObjektExtensions.toTopPoints(botb), (Functions.Function1)_function), (Functions.Function1)_function_1), (Functions.Function1)_function_2);
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)distances);
        if (_isNullOrEmpty) {
            return null;
        }
        return Range.closed((Comparable)((Double)IterableExtensions.min((Iterable)distances)), (Comparable)((Double)IterableExtensions.max((Iterable)distances)));
    }
}

