/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.ppmodel.extensions;

import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.set.model.planpro.Ansteuerung_Element.Aussenelementansteuerung;
import org.eclipse.set.model.planpro.Ansteuerung_Element.Stell_Bereich;
import org.eclipse.set.model.planpro.Ansteuerung_Element.Stellelement;
import org.eclipse.set.model.planpro.Basisobjekte.Basis_Objekt;
import org.eclipse.set.model.planpro.Basisobjekte.Bereich_Objekt;
import org.eclipse.set.model.planpro.Basisobjekte.Punkt_Objekt;
import org.eclipse.set.model.planpro.Fahrstrasse.Fstr_Fahrweg;
import org.eclipse.set.model.planpro.Fahrstrasse.Fstr_Zug_AttributeGroup;
import org.eclipse.set.model.planpro.Fahrstrasse.Fstr_Zug_Rangier;
import org.eclipse.set.model.planpro.Geodaten.ENUMTOPAnschluss;
import org.eclipse.set.model.planpro.Geodaten.TOP_Kante;
import org.eclipse.set.model.planpro.Geodaten.TOP_Knoten;
import org.eclipse.set.model.planpro.Gleis.Gleis_Abschnitt;
import org.eclipse.set.model.planpro.Regelzeichnung.Regelzeichnung;
import org.eclipse.set.model.planpro.Verweise.ID_Aussenelementansteuerung_TypeClass;
import org.eclipse.set.model.planpro.Verweise.ID_Element_TypeClass;
import org.eclipse.set.model.planpro.Verweise.ID_Fstr_Fahrweg_TypeClass;
import org.eclipse.set.model.planpro.Verweise.ID_Regelzeichnung_TypeClass;
import org.eclipse.set.model.planpro.Verweise.ID_Stellelement_TypeClass;
import org.eclipse.set.model.planpro.Verweise.ID_W_Kr_Anlage_TypeClass;
import org.eclipse.set.model.planpro.Verweise.ID_W_Kr_Gsp_Element_TypeClass;
import org.eclipse.set.model.planpro.Weichen_und_Gleissperren.ENUMWKrArt;
import org.eclipse.set.model.planpro.Weichen_und_Gleissperren.GZ_Freimeldung_L_AttributeGroup;
import org.eclipse.set.model.planpro.Weichen_und_Gleissperren.GZ_Freimeldung_R_AttributeGroup;
import org.eclipse.set.model.planpro.Weichen_und_Gleissperren.W_Kr_Anlage;
import org.eclipse.set.model.planpro.Weichen_und_Gleissperren.W_Kr_Gsp_Element;
import org.eclipse.set.model.planpro.Weichen_und_Gleissperren.W_Kr_Gsp_Komponente;
import org.eclipse.set.model.planpro.Weichen_und_Gleissperren.Weiche_Element_AttributeGroup;
import org.eclipse.set.model.planpro.Weichen_und_Gleissperren.Zungenpaar_AttributeGroup;
import org.eclipse.set.ppmodel.extensions.BasisAttributExtensions;
import org.eclipse.set.ppmodel.extensions.BasisObjektExtensions;
import org.eclipse.set.ppmodel.extensions.BereichObjektExtensions;
import org.eclipse.set.ppmodel.extensions.PunktObjektExtensions;
import org.eclipse.set.ppmodel.extensions.StellBereichExtensions;
import org.eclipse.set.ppmodel.extensions.TopKanteExtensions;
import org.eclipse.set.ppmodel.extensions.TopKnotenExtensions;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class WKrGspElementExtensions
extends BasisObjektExtensions {
    public static W_Kr_Anlage getWKrAnlage(W_Kr_Gsp_Element wKrGspElement) {
        ID_W_Kr_Anlage_TypeClass _iDWKrAnlage = wKrGspElement.getIDWKrAnlage();
        W_Kr_Anlage _value = null;
        if (_iDWKrAnlage != null) {
            _value = _iDWKrAnlage.getValue();
        }
        return _value;
    }

    public static List<W_Kr_Gsp_Komponente> getWKrGspKomponenten(W_Kr_Gsp_Element wKrGspElement) {
        if (wKrGspElement == null) {
            return Collections.emptyList();
        }
        Functions.Function1 _function = it -> {
            ID_W_Kr_Gsp_Element_TypeClass _iDWKrGspElement = it.getIDWKrGspElement();
            String _wert = null;
            if (_iDWKrGspElement != null) {
                _wert = _iDWKrGspElement.getWert();
            }
            String _wert_1 = wKrGspElement.getIdentitaet().getWert();
            return Objects.equals(_wert, _wert_1);
        };
        return IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)BasisAttributExtensions.getContainer((EObject)wKrGspElement).getWKrGspKomponente(), (Functions.Function1)_function));
    }

    public static Regelzeichnung getRegelzeichnung(W_Kr_Gsp_Element wKrGspElement) {
        ID_Regelzeichnung_TypeClass _iDRegelzeichnung = wKrGspElement.getIDRegelzeichnung();
        Regelzeichnung _value = null;
        if (_iDRegelzeichnung != null) {
            _value = _iDRegelzeichnung.getValue();
        }
        return _value;
    }

    public static Basis_Objekt getElement(GZ_Freimeldung_R_AttributeGroup group) {
        ID_Element_TypeClass _iDElement = null;
        if (group != null) {
            _iDElement = group.getIDElement();
        }
        Basis_Objekt _value = null;
        if (_iDElement != null) {
            _value = _iDElement.getValue();
        }
        return _value;
    }

    public static Basis_Objekt getElement(GZ_Freimeldung_L_AttributeGroup group) {
        ID_Element_TypeClass _iDElement = null;
        if (group != null) {
            _iDElement = group.getIDElement();
        }
        Basis_Objekt _value = null;
        if (_iDElement != null) {
            _value = _iDElement.getValue();
        }
        return _value;
    }

    public static TOP_Kante getTopKanteL(W_Kr_Gsp_Element wKrGspElement) {
        return WKrGspElementExtensions.getTopKanteWithAnschluss(wKrGspElement, ENUMTOPAnschluss.ENUMTOP_ANSCHLUSS_LINKS);
    }

    public static TOP_Kante getTopKanteR(W_Kr_Gsp_Element wKrGspElement) {
        return WKrGspElementExtensions.getTopKanteWithAnschluss(wKrGspElement, ENUMTOPAnschluss.ENUMTOP_ANSCHLUSS_RECHTS);
    }

    public static TOP_Knoten getTopKnoten(W_Kr_Gsp_Element wKrGspElement) {
        ENUMWKrArt _wert = WKrGspElementExtensions.getWKrAnlage(wKrGspElement).getWKrAnlageAllg().getWKrArt().getWert();
        if (_wert != null) {
            switch (_wert) {
                case ENUMW_KR_ART_ABW: 
                case ENUMW_KR_ART_DKW: 
                case ENUMW_KR_ART_DW: 
                case ENUMW_KR_ART_EKW: 
                case ENUMW_KR_ART_EW: 
                case ENUMW_KR_ART_IBW: 
                case ENUMW_KR_ART_KLOTHOIDENWEICHE: 
                case ENUMW_KR_ART_KORBBOGENWEICHE: {
                    boolean _tripleEquals;
                    Weiche_Element_AttributeGroup _weicheElement = null;
                    if (wKrGspElement != null) {
                        _weicheElement = wKrGspElement.getWeicheElement();
                    }
                    boolean bl = _tripleEquals = _weicheElement == null;
                    if (_tripleEquals) {
                        return null;
                    }
                    Functions.Function1 _function = it -> {
                        Zungenpaar_AttributeGroup _zungenpaar = it.getZungenpaar();
                        return _zungenpaar != null;
                    };
                    Iterable zungenpaare = IterableExtensions.filter(WKrGspElementExtensions.getWKrGspKomponenten(wKrGspElement), (Functions.Function1)_function);
                    boolean _isEmpty = IterableExtensions.isEmpty((Iterable)zungenpaare);
                    boolean _not = !_isEmpty;
                    Assert.isTrue((boolean)_not);
                    W_Kr_Gsp_Komponente zungenpaar = ((W_Kr_Gsp_Komponente[])Conversions.unwrapArray((Object)zungenpaare, W_Kr_Gsp_Komponente.class))[0];
                    return PunktObjektExtensions.getTopKnoten((Punkt_Objekt)zungenpaar);
                }
                case ENUMW_KR_ART_FLACHKREUZUNG: 
                case ENUMW_KR_ART_KR: 
                case ENUMW_KR_ART_SONSTIGE: {
                    return PunktObjektExtensions.getTopKnoten((Punkt_Objekt)WKrGspElementExtensions.getWKrGspKomponenten(wKrGspElement).get(0));
                }
            }
        }
        return null;
    }

    public static Stellelement getStellelement(W_Kr_Gsp_Element wKrGspElement) {
        ID_Stellelement_TypeClass _iDStellelement = wKrGspElement.getIDStellelement();
        Stellelement _value = null;
        if (_iDStellelement != null) {
            _value = _iDStellelement.getValue();
        }
        return _value;
    }

    private static TOP_Kante getTopKanteWithAnschluss(W_Kr_Gsp_Element wKrGspElement, ENUMTOPAnschluss anschluss) {
        boolean _tripleNotEquals;
        TOP_Knoten weichenKnoten = WKrGspElementExtensions.getTopKnoten(wKrGspElement);
        if (weichenKnoten == null) {
            return null;
        }
        Functions.Function1 _function = it -> {
            ENUMTOPAnschluss _tOPAnschluss = TopKanteExtensions.getTOPAnschluss(it, weichenKnoten);
            return Objects.equals(_tOPAnschluss, anschluss);
        };
        Iterable results = IterableExtensions.filter(TopKnotenExtensions.getTopKanten(weichenKnoten), (Functions.Function1)_function);
        int _size = IterableExtensions.size((Iterable)results);
        boolean bl = _tripleNotEquals = _size != 1;
        if (_tripleNotEquals) {
            return null;
        }
        return ((TOP_Kante[])Conversions.unwrapArray((Object)results, TOP_Kante.class))[0];
    }

    public static Set<Fstr_Zug_Rangier> getFstrZugCrossingLeg(W_Kr_Gsp_Element element, TOP_Kante legTopKante) {
        Functions.Function1 _function = it -> {
            boolean _tripleNotEquals;
            boolean _xblockexpression = false;
            ID_Fstr_Fahrweg_TypeClass _iDFstrFahrweg = it.getIDFstrFahrweg();
            Fstr_Fahrweg _value = null;
            if (_iDFstrFahrweg != null) {
                _value = _iDFstrFahrweg.getValue();
            }
            Fstr_Fahrweg fstrFW = _value;
            boolean _and = false;
            boolean _and_1 = false;
            Fstr_Zug_AttributeGroup _fstrZug = it.getFstrZug();
            boolean bl = _tripleNotEquals = _fstrZug != null;
            if (!_tripleNotEquals) {
                _and_1 = false;
            } else {
                boolean _contains;
                ID_Fstr_Fahrweg_TypeClass _iDFstrFahrweg_1 = it.getIDFstrFahrweg();
                Fstr_Fahrweg _value_1 = null;
                if (_iDFstrFahrweg_1 != null) {
                    _value_1 = _iDFstrFahrweg_1.getValue();
                }
                Functions.Function1 _function_1 = it_1 -> BereichObjektExtensions.getTopKante(it_1);
                _and_1 = _contains = ListExtensions.map((List)_value_1.getBereichObjektTeilbereich(), (Functions.Function1)_function_1).contains(legTopKante);
            }
            if (!_and_1) {
                _and = false;
            } else {
                boolean _exists;
                Functions.Function1 _function_2 = it_1 -> BereichObjektExtensions.intersects((Bereich_Objekt)fstrFW, (Punkt_Objekt)it_1);
                _and = _exists = IterableExtensions.exists(WKrGspElementExtensions.getWKrGspKomponenten(element), (Functions.Function1)_function_2);
            }
            _xblockexpression = _and;
            return _xblockexpression;
        };
        return IterableExtensions.toSet((Iterable)IterableExtensions.filterNull((Iterable)IterableExtensions.filter((Iterable)BasisAttributExtensions.getContainer((EObject)element).getFstrZugRangier(), (Functions.Function1)_function)));
    }

    public static List<Gleis_Abschnitt> getGleisAbschnitt(W_Kr_Gsp_Element element) {
        Weiche_Element_AttributeGroup _weicheElement = null;
        if (element != null) {
            _weicheElement = element.getWeicheElement();
        }
        GZ_Freimeldung_L_AttributeGroup _gZFreimeldungL = null;
        if (_weicheElement != null) {
            _gZFreimeldungL = _weicheElement.getGZFreimeldungL();
        }
        Basis_Objekt _element = null;
        if (_gZFreimeldungL != null) {
            _element = WKrGspElementExtensions.getElement(_gZFreimeldungL);
        }
        Weiche_Element_AttributeGroup _weicheElement_1 = null;
        if (element != null) {
            _weicheElement_1 = element.getWeicheElement();
        }
        GZ_Freimeldung_R_AttributeGroup _gZFreimeldungR = null;
        if (_weicheElement_1 != null) {
            _gZFreimeldungR = _weicheElement_1.getGZFreimeldungR();
        }
        Basis_Objekt _element_1 = null;
        if (_gZFreimeldungR != null) {
            _element_1 = WKrGspElementExtensions.getElement(_gZFreimeldungR);
        }
        return IterableExtensions.toList((Iterable)Iterables.filter(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Basis_Objekt[]{_element, _element_1})), Gleis_Abschnitt.class));
    }

    public static boolean isBelongToControlArea(W_Kr_Gsp_Element gspElement, Stell_Bereich controlArea) {
        Aussenelementansteuerung _aussenElementAnsteuerung;
        ID_Stellelement_TypeClass _iDStellelement = gspElement.getIDStellelement();
        Stellelement _value = null;
        if (_iDStellelement != null) {
            _value = _iDStellelement.getValue();
        }
        ID_Aussenelementansteuerung_TypeClass _iDInformation = null;
        if (_value != null) {
            _iDInformation = _value.getIDInformation();
        }
        Aussenelementansteuerung _value_1 = null;
        if (_iDInformation != null) {
            _value_1 = _iDInformation.getValue();
        }
        return _value_1 == (_aussenElementAnsteuerung = StellBereichExtensions.getAussenElementAnsteuerung(controlArea));
    }
}

