/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.ppmodel.extensions.geometry;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.set.basis.geometry.Chord;
import org.eclipse.set.basis.geometry.Geometries;
import org.eclipse.set.basis.graph.DirectedElement;
import org.eclipse.set.core.services.Services;
import org.eclipse.set.model.planpro.Geodaten.ENUMGEOForm;
import org.eclipse.set.model.planpro.Geodaten.GEO_Kante;
import org.eclipse.set.model.planpro.Geodaten.GEO_Knoten;
import org.eclipse.set.ppmodel.extensions.GeoKanteExtensions;
import org.eclipse.set.ppmodel.extensions.GeoKnotenExtensions;
import org.eclipse.set.ppmodel.extensions.geometry.CoordinateExtensions;
import org.eclipse.set.utils.math.Bloss;
import org.eclipse.set.utils.math.Clothoid;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GEOKanteGeometryExtensions {
    static final Logger logger = LoggerFactory.getLogger(GEOKanteGeometryExtensions.class);
    private static final int BLOSS_SEGMENTS_MIN = 10;
    private static final double BLOSS_SEGMENTS_PER_LENGTH = 0.5;
    private static final int BLOSS_PRECISION = 20;
    private static final int CLOTHOID_SEGMENTS_MIN = 10;
    private static final double CLOTHOID_SEGMENTS_PER_LENGTH = 0.5;
    private static final int CLOTHOID_PRECISION = 5;
    private static GeometryFactory geomeryFactory;

    private static GeometryFactory getGeometryFactory() {
        if (geomeryFactory == null) {
            geomeryFactory = new GeometryFactory();
        }
        return geomeryFactory;
    }

    public static LineString defineEdgeGeometry(GEO_Kante edge) {
        ENUMGEOForm geoForm = edge.getGEOKanteAllg().getGEOForm().getWert();
        switch (geoForm) {
            case ENUMGEO_FORM_GERADE: 
            case ENUMGEO_FORM_KM_SPRUNG: 
            case ENUMGEO_FORM_RICHTGERADE_KNICK_AM_ENDE_200_GON: 
            case ENUMGEO_FORM_SONSTIGE: {
                return GEOKanteGeometryExtensions.getGeometryFactory().createLineString(GEOKanteGeometryExtensions.getCoordinates(edge));
            }
            case ENUMGEO_FORM_BOGEN: {
                return GEOKanteGeometryExtensions.arc(edge);
            }
            case ENUMGEO_FORM_KLOTHOIDE: {
                return GEOKanteGeometryExtensions.clothoid(edge);
            }
            case ENUMGEO_FORM_BLOSSKURVE: 
            case ENUMGEO_FORM_BLOSS_EINFACH_GESCHWUNGEN: {
                return GEOKanteGeometryExtensions.blosscurve(edge);
            }
        }
        logger.warn("Form {} not supported.", (Object)geoForm.getName());
        return GEOKanteGeometryExtensions.getGeometryFactory().createLineString(GEOKanteGeometryExtensions.getCoordinates(edge));
    }

    private static LineString arc(GEO_Kante edge) {
        Coordinate[] coordinates = GEOKanteGeometryExtensions.getCoordinates(edge);
        double radius = edge.getGEOKanteAllg().getGEORadiusA().getWert().doubleValue();
        return Geometries.createArc((GeometryFactory)GEOKanteGeometryExtensions.getGeometryFactory(), (Chord)new Chord(coordinates[0], coordinates[1], Math.abs(radius), radius < 0.0 ? Chord.Orientation.ARC_RIGHT : Chord.Orientation.ARC_LEFT));
    }

    private static LineString clothoid(GEO_Kante edge) {
        double radiusA = Optional.ofNullable(edge.getGEOKanteAllg().getGEORadiusA().getWert()).orElse(BigDecimal.ZERO).doubleValue();
        double radiusB = Optional.ofNullable(edge.getGEOKanteAllg().getGEORadiusB().getWert()).orElse(BigDecimal.ZERO).doubleValue();
        Coordinate coordinateA = GeoKnotenExtensions.getCoordinate(edge.getIDGEOKnotenA().getValue());
        Coordinate coordinateB = GEOKanteGeometryExtensions.getCoordinateNodeB(edge);
        double angle = edge.getGEOKanteAllg().getGEORichtungswinkel().getWert().doubleValue();
        double length = edge.getGEOKanteAllg().getGEOLaenge().getWert().doubleValue();
        if (radiusA != 0.0 && radiusB != 0.0) {
            Clothoid clothoid = new Clothoid(Math.abs(radiusB), length, 5);
            double angleRad = 0.015707963267948967 * (100.0 - angle);
            double[] point = clothoid.getPoint(length / 2.0);
            Coordinate centerCoordinate = new Coordinate(point[0], point[1]);
            if (radiusB > 0.0) {
                centerCoordinate = CoordinateExtensions.mirrorY(centerCoordinate);
            }
            Coordinate center = CoordinateExtensions.offsetBy(CoordinateExtensions.rotateAroundOrigin(centerCoordinate, angleRad), coordinateA.x, coordinateA.y);
            Coordinate[] segmentA = GEOKanteGeometryExtensions.clothoid(coordinateA, center, radiusB, length / 2.0).getCoordinates();
            Coordinate[] segmentB = GEOKanteGeometryExtensions.clothoid(center, coordinateB, radiusA, length / 2.0).getCoordinates();
            ArrayList<Coordinate> segment = new ArrayList<Coordinate>();
            segment.addAll(Arrays.asList(segmentA));
            segment.addAll(Arrays.asList(segmentB));
            return GEOKanteGeometryExtensions.getGeometryFactory().createLineString(segment.toArray(new Coordinate[0]));
        }
        if (radiusA == 0.0) {
            return GEOKanteGeometryExtensions.clothoid(coordinateA, coordinateB, radiusB, length);
        }
        return GEOKanteGeometryExtensions.clothoid(coordinateB, coordinateA, -radiusA, length);
    }

    private static LineString clothoid(Coordinate fromCoordinate, Coordinate toCoordinate, double radius, double length) {
        int segmentCount = (int)Math.max(length * 0.5, 10.0);
        Clothoid clothoid = new Clothoid(Math.abs(radius), length, 5);
        List clothoidCoordinates = clothoid.getPoints(segmentCount);
        List<Coordinate> coords = clothoidCoordinates.stream().map(coor -> {
            Coordinate coordinate = new Coordinate(coor[0], coor[1]);
            return radius > 0.0 ? CoordinateExtensions.mirrorY(coordinate) : coordinate;
        }).toList();
        List<Coordinate> coordinates = coords.stream().map(coor -> CoordinateExtensions.offsetBy(coor, coordinate.x, coordinate.y)).toList();
        double angleA = CoordinateExtensions.getAngleBetweenPoints(fromCoordinate, toCoordinate);
        double angleB = CoordinateExtensions.getAngleBetweenPoints(fromCoordinate, (Coordinate)IterableExtensions.lastOrNull(coordinates));
        double angleOffset = angleA - angleB;
        return GEOKanteGeometryExtensions.getGeometryFactory().createLineString(coordinates.stream().map(coor -> CoordinateExtensions.rotateAroundPoint(coor, angleOffset, fromCoordinate)).toList().toArray(new Coordinate[0]));
    }

    private static LineString blosscurve(GEO_Kante edge) {
        double radiusA = Optional.ofNullable(edge.getGEOKanteAllg().getGEORadiusA().getWert()).orElse(BigDecimal.ZERO).doubleValue();
        double radiusB = Optional.ofNullable(edge.getGEOKanteAllg().getGEORadiusB().getWert()).orElse(BigDecimal.ZERO).doubleValue();
        Coordinate coordinateA = GeoKnotenExtensions.getCoordinate(edge.getIDGEOKnotenA().getValue());
        Coordinate coordinateB = GEOKanteGeometryExtensions.getCoordinateNodeB(edge);
        double length = edge.getGEOKanteAllg().getGEOLaenge().getWert().doubleValue();
        if (radiusA != 0.0 && radiusB != 0.0) {
            logger.warn("Form Bloss between straight tracks not supported.");
            return GEOKanteGeometryExtensions.getGeometryFactory().createLineString(GEOKanteGeometryExtensions.getCoordinates(edge));
        }
        if (radiusA == 0.0) {
            return GEOKanteGeometryExtensions.blosscurve(coordinateB, coordinateA, radiusB, length);
        }
        return GEOKanteGeometryExtensions.blosscurve(coordinateA, coordinateB, -radiusA, length);
    }

    private static LineString blosscurve(Coordinate fromCoordinate, Coordinate toCoordinate, double radius, double length) {
        Bloss bloss = new Bloss(Math.abs(radius), length, 20);
        int segmentCount = (int)Math.max(length * 0.5, 10.0);
        List<Coordinate> coords = bloss.calculate(segmentCount).stream().map(coor -> {
            Coordinate coordinate = new Coordinate(coor[0], coor[1], 0.0);
            return radius < 0.0 ? CoordinateExtensions.mirrorY(coordinate) : coordinate;
        }).toList();
        List<Coordinate> coordinates = coords.stream().map(coor -> CoordinateExtensions.offsetBy(coor, coordinate.x, coordinate.y)).toList();
        double angleA = CoordinateExtensions.getAngleBetweenPoints(fromCoordinate, toCoordinate);
        double angleB = CoordinateExtensions.getAngleBetweenPoints(fromCoordinate, (Coordinate)IterableExtensions.lastOrNull(coordinates));
        double angleOffset = angleA - angleB;
        return GEOKanteGeometryExtensions.getGeometryFactory().createLineString(coordinates.stream().map(coor -> CoordinateExtensions.rotateAroundPoint(coor, angleOffset, fromCoordinate)).toList().toArray(new Coordinate[0]));
    }

    private static Coordinate getCoordinateNodeB(GEO_Kante edge) {
        GEO_Knoten nodeA = edge.getIDGEOKnotenA().getValue();
        GEO_Knoten nodeB = edge.getIDGEOKnotenB().getValue();
        Coordinate coordinateB = GeoKnotenExtensions.getCoordinate(nodeB);
        if (!GeoKanteExtensions.isCRSConsistent(edge)) {
            coordinateB = CoordinateExtensions.transformCRS(coordinateB, GeoKnotenExtensions.getCRS(nodeB), GeoKnotenExtensions.getCRS(nodeA));
        }
        return coordinateB;
    }

    private static Coordinate[] getCoordinates(GEO_Kante edge) {
        return Stream.of(GeoKnotenExtensions.getCoordinate(edge.getIDGEOKnotenA().getValue()), GEOKanteGeometryExtensions.getCoordinateNodeB(edge)).toList().toArray(new Coordinate[0]);
    }

    public static LineString getGeometry(GEO_Kante edge) {
        return Services.getGeometryService().getGeometry(edge);
    }

    public static LineString getGeometry(DirectedElement<GEO_Kante> directedEdge) {
        return Services.getGeometryService().getGeometry(directedEdge);
    }

    public static boolean isFindGeometryComplete() {
        return Services.getGeometryService().isFindGeometryComplete();
    }
}

