/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.ppmodel.extensions.utils;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.set.basis.graph.AbstractRouting;
import org.eclipse.set.basis.graph.Digraph;
import org.eclipse.set.basis.graph.DirectedEdge;
import org.eclipse.set.basis.graph.DirectedEdgePath;
import org.eclipse.set.model.planpro.Basisobjekte.Punkt_Objekt_TOP_Kante_AttributeGroup;
import org.eclipse.set.model.planpro.Geodaten.TOP_Kante;
import org.eclipse.set.model.planpro.Geodaten.TOP_Knoten;
import org.eclipse.set.ppmodel.extensions.TopKanteExtensions;
import org.eclipse.set.ppmodel.extensions.TopKnotenExtensions;
import org.eclipse.set.ppmodel.extensions.utils.DirectedTopKante;
import org.eclipse.set.ppmodel.extensions.utils.Distance;
import org.eclipse.set.ppmodel.extensions.utils.TopKantePath;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class TopGraph
extends AbstractRouting<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup>
implements Digraph<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> {
    private final Set<DirectedEdge<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup>> edges;
    private final HashMap<ArrayList<?>, DirectedEdge<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup>> _createCache_transform = CollectionLiterals.newHashMap();

    public TopGraph(Iterable<TOP_Kante> topKanten) {
        Functions.Function1 _function = it -> {
            DirectedEdge<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> _transform = this.transform((TOP_Kante)it, true);
            DirectedEdge<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> _transform_1 = this.transform((TOP_Kante)it, false);
            return Collections.unmodifiableSet(CollectionLiterals.newHashSet((Object[])new DirectedEdge[]{_transform, _transform_1}));
        };
        this.edges = IterableExtensions.toSet((Iterable)Iterables.concat((Iterable)IterableExtensions.map(topKanten, (Functions.Function1)_function)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DirectedEdge<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> transform(TOP_Kante topKante, boolean isForwards) {
        DirectedTopKante _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new Object[]{topKante, isForwards});
        HashMap<ArrayList<?>, DirectedEdge<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup>> hashMap = this._createCache_transform;
        synchronized (hashMap) {
            DirectedTopKante _directedTopKante;
            if (this._createCache_transform.containsKey(_cacheKey)) {
                return this._createCache_transform.get(_cacheKey);
            }
            _result = _directedTopKante = new DirectedTopKante();
            this._createCache_transform.put(_cacheKey, _result);
        }
        this._init_transform(_result, topKante, isForwards);
        return _result;
    }

    private void _init_transform(DirectedTopKante it, TOP_Kante topKante, boolean isForwards) {
        it.setElement(topKante);
        it.setForwards(isForwards);
    }

    public Set<DirectedEdge<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup>> getEdges() {
        return this.edges;
    }

    public Set<TOP_Knoten> getNodes() {
        Functions.Function1 _function = it -> {
            TOP_Knoten _tail = (TOP_Knoten)it.getTail();
            TOP_Knoten _head = (TOP_Knoten)it.getHead();
            return Collections.unmodifiableSet(CollectionLiterals.newHashSet((Object[])new TOP_Knoten[]{_tail, _head}));
        };
        return IterableExtensions.toSet((Iterable)Iterables.concat((Iterable)IterableExtensions.map(this.edges, (Functions.Function1)_function)));
    }

    public Set<TOP_Knoten> getDirectPredecessors(TOP_Knoten node) {
        Functions.Function1 _function = n -> {
            Functions.Function1 _function_1 = it -> Objects.equals(it.getTail(), n) && Objects.equals(it.getHead(), node);
            return IterableExtensions.exists(this.edges, (Functions.Function1)_function_1);
        };
        return IterableExtensions.toSet((Iterable)IterableExtensions.filter(this.getNodes(), (Functions.Function1)_function));
    }

    public Set<TOP_Knoten> getDirectSuccessors(TOP_Knoten node) {
        Functions.Function1 _function = n -> {
            Functions.Function1 _function_1 = it -> Objects.equals(it.getTail(), node) && Objects.equals(it.getHead(), n);
            return IterableExtensions.exists(this.edges, (Functions.Function1)_function_1);
        };
        return IterableExtensions.toSet((Iterable)IterableExtensions.filter(this.getNodes(), (Functions.Function1)_function));
    }

    public Set<TOP_Kante> getEdges(TOP_Knoten node) {
        return IterableExtensions.toSet(TopKnotenExtensions.getTopKanten(node));
    }

    public DirectedEdge<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> getHeadEdge(TOP_Knoten head, TOP_Kante edge) {
        Assert.isTrue((boolean)TopKanteExtensions.getTOPKnoten(edge).contains(head));
        TOP_Knoten _tOPKnotenB = TopKanteExtensions.getTOPKnotenB(edge);
        boolean _equals = Objects.equals(_tOPKnotenB, head);
        return new DirectedTopKante(edge, _equals);
    }

    public DirectedEdge<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> getTailEdge(TOP_Knoten tail, TOP_Kante edge) {
        Assert.isTrue((boolean)TopKanteExtensions.getTOPKnoten(edge).contains(tail));
        TOP_Knoten _tOPKnotenA = TopKanteExtensions.getTOPKnotenA(edge);
        boolean _equals = Objects.equals(_tOPKnotenA, tail);
        return new DirectedTopKante(edge, _equals);
    }

    public boolean isRoute(TOP_Kante origin, TOP_Kante destination, TOP_Knoten transition) {
        return TopKanteExtensions.isRoute(origin, destination, transition);
    }

    public Comparator<Double> getDistanceComparator() {
        return new Comparator<Double>(){

            @Override
            public int compare(Double d1, Double d2) {
                return Distance.compare(d1, d2);
            }
        };
    }

    public DirectedEdgePath<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> getEmptyPath() {
        return new TopKantePath();
    }

    public String getCacheKey() {
        Functions.Function1 _function = it -> it.getCacheKey();
        return IterableExtensions.join((Iterable)ListExtensions.map((List)IterableExtensions.toList(this.edges), (Functions.Function1)_function), (CharSequence)"/");
    }
}

