/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.model.validationreport;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ValidationSeverity implements Enumerator
{
    ERROR(0, "ERROR", "ERROR"),
    WARNING(1, "WARNING", "WARNING"),
    SUCCESS(2, "SUCCESS", "SUCCESS");

    public static final int ERROR_VALUE = 0;
    public static final int WARNING_VALUE = 1;
    public static final int SUCCESS_VALUE = 2;
    private static final ValidationSeverity[] VALUES_ARRAY;
    public static final List<ValidationSeverity> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ValidationSeverity[]{ERROR, WARNING, SUCCESS};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ValidationSeverity get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ValidationSeverity result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ValidationSeverity getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ValidationSeverity result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ValidationSeverity get(int value) {
        switch (value) {
            case 0: {
                return ERROR;
            }
            case 1: {
                return WARNING;
            }
            case 2: {
                return SUCCESS;
            }
        }
        return null;
    }

    private ValidationSeverity(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

