/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.validation.niltest;

import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.set.basis.constants.ValidationResult;
import org.eclipse.set.basis.exceptions.CustomValidationProblem;
import org.eclipse.set.basis.extensions.NodeListExtensions;
import org.eclipse.set.basis.files.ToolboxFile;
import org.eclipse.set.core.services.validation.CustomValidator;
import org.eclipse.set.feature.validation.AbstractCustomValidator;
import org.eclipse.set.feature.validation.CustomValidationProblemImpl;
import org.eclipse.set.model.planpro.Layoutinformationen.PlanPro_Layoutinfo;
import org.eclipse.set.model.planpro.PlanPro.PlanPro_Schnittstelle;
import org.eclipse.set.model.validationreport.ObjectScope;
import org.eclipse.set.model.validationreport.ValidationSeverity;
import org.eclipse.set.utils.xml.LineNumberXMLReader;
import org.eclipse.set.utils.xml.ObjectMetadataXMLReader;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.osgi.service.component.annotations.Component;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@Component(immediate=true, service={CustomValidator.class})
public class NilTest
extends AbstractCustomValidator {
    private static final String NIL = "xsi:nil";
    private Class<?> sourceClass;

    public void validate(ToolboxFile toolboxFile, ValidationResult result, CustomValidator.FileType type) {
        try {
            boolean _tripleEquals;
            this.sourceClass = result.getValidatedSourceClass();
            LinkedList nilProblems = CollectionLiterals.newLinkedList();
            boolean _isAssignableFrom = this.sourceClass.isAssignableFrom(PlanPro_Schnittstelle.class);
            if (_isAssignableFrom) {
                nilProblems.addAll(this.validate(ObjectMetadataXMLReader.read((ToolboxFile)toolboxFile, (Path)toolboxFile.getModelPath())));
            } else {
                boolean _isAssignableFrom_1;
                boolean _exists;
                boolean _and = false;
                Path _layoutPath = toolboxFile.getLayoutPath();
                File _file = null;
                if (_layoutPath != null) {
                    _file = _layoutPath.toFile();
                }
                if (_and = !(_exists = _file.exists()) ? false : (_isAssignableFrom_1 = this.sourceClass.isAssignableFrom(PlanPro_Layoutinfo.class))) {
                    nilProblems.addAll(this.validate(ObjectMetadataXMLReader.read((ToolboxFile)toolboxFile, (Path)toolboxFile.getLayoutPath())));
                }
            }
            int _size = nilProblems.size();
            boolean bl = _tripleEquals = _size == 0;
            if (_tripleEquals) {
                result.addCustomProblem(this.getSuccessValidationReport(this.getMessages().NilTestProblem_Description));
            } else {
                Consumer<CustomValidationProblem> _function = it -> result.addCustomProblem(it);
                nilProblems.forEach(_function);
            }
        }
        catch (Throwable _t) {
            if (_t instanceof ParserConfigurationException) {
                ParserConfigurationException e = (ParserConfigurationException)_t;
                result.addCustomProblem(this.transform(e));
            }
            if (_t instanceof SAXException) {
                SAXException e_1 = (SAXException)_t;
                result.addCustomProblem(this.transform(e_1));
            }
            if (_t instanceof IOException) {
                IOException e_2 = (IOException)_t;
                result.addIoError((Exception)e_2);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    private List<CustomValidationProblem> validate(Node node) {
        Node nilAttribute;
        LinkedList it = CollectionLiterals.newLinkedList();
        NamedNodeMap _attributes = null;
        if (node != null) {
            _attributes = node.getAttributes();
        }
        Node _namedItem = null;
        if (_attributes != null) {
            _namedItem = _attributes.getNamedItem(NIL);
        }
        if ((nilAttribute = _namedItem) != null) {
            it.add(this.transform(node));
        }
        Functions.Function1 _function = it_1 -> this.validate((Node)it_1);
        Iterables.addAll((Collection)it, (Iterable)IterableExtensions.flatMap((Iterable)NodeListExtensions.iterable((NodeList)node.getChildNodes()), (Functions.Function1)_function));
        return it;
    }

    private CustomValidationProblem _transform(Exception e) {
        CustomValidationProblemImpl it = new CustomValidationProblemImpl();
        it.setLineNumber(0);
        it.setMessage(e.getMessage());
        it.setSeverity(ValidationSeverity.ERROR);
        it.setType(this.getMessages().NilTestProblem_Type);
        boolean _isAssignableFrom = this.sourceClass.isAssignableFrom(PlanPro_Layoutinfo.class);
        if (_isAssignableFrom) {
            it.setObjectScope(ObjectScope.LAYOUT);
        }
        return it;
    }

    private CustomValidationProblem _transform(Node node) {
        CustomValidationProblemImpl it = new CustomValidationProblemImpl();
        it.setLineNumber(LineNumberXMLReader.getLineNumber((Node)node));
        it.setMessage(this.getMessages().NilTestProblem_Message);
        it.setSeverity(ValidationSeverity.WARNING);
        it.setType(this.validationType());
        it.setObjectArt(ObjectMetadataXMLReader.getObjectType((Node)node));
        it.setObjectScope(ObjectMetadataXMLReader.getObjectScope((Node)node));
        it.setObjectState(ObjectMetadataXMLReader.getObjectState((Node)node));
        it.setAttributeName(ObjectMetadataXMLReader.getAttributeName((Node)node));
        return it;
    }

    public String validationType() {
        return this.getMessages().NilTestProblem_Type;
    }

    private CustomValidationProblem transform(Object e) {
        if (e instanceof Exception) {
            return this._transform((Exception)e);
        }
        if (e instanceof Node) {
            return this._transform((Node)e);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(e).toString());
    }
}

