/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils.xml;

import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NodeAttributeNameProvider {
    private static final String TEXT_NODE = "#text";
    private static final String CONTAINER_NODE = "Container";
    private static final String IDENTITY_ATTRIBUTE_NAME = "Identitaet";
    private static final String VALUE_ATTRIBUTE_NAME = "Wert";

    public String getAttributeName(Node node) {
        if (node == null || node.getParentNode().getNodeName().equals(CONTAINER_NODE)) {
            return null;
        }
        Node parentNode = node.getParentNode();
        if (node.getNodeName().equals(TEXT_NODE)) {
            return this.getAttributeName(parentNode);
        }
        if (NodeAttributeNameProvider.isValueType(node) || NodeAttributeNameProvider.isObjectType(parentNode)) {
            return node.getNodeName();
        }
        return parentNode.getNodeName();
    }

    private static boolean isObjectType(Node node) {
        return NodeAttributeNameProvider.hasChildOfType(node, IDENTITY_ATTRIBUTE_NAME);
    }

    private static boolean isValueType(Node node) {
        return NodeAttributeNameProvider.hasChildOfType(node, VALUE_ATTRIBUTE_NAME);
    }

    private static boolean hasChildOfType(Node node, String name) {
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeName().equals(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

