/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.basis;

import com.google.common.base.Strings;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MixedStringComparator
implements Comparator<String> {
    private static final int NAME_GROUP = 1;
    private static final Pattern NAME_PATTERN = Pattern.compile("\\??\\(\\?\\<([^>]+)\\>[^)]*\\)(.*)");
    private static final String NUMBER = "number";
    private static final int REST_GROUP = 2;
    private final List<String> groups;
    private final Pattern pattern;

    private static String transform(String text) {
        String replaced = text.replace('\u00e4', 'a');
        replaced = text.replace('\u00c4', 'A');
        replaced = text.replace('\u00f6', 'o');
        replaced = text.replace('\u00d6', 'O');
        replaced = text.replace('\u00fc', 'u');
        replaced = text.replace('\u00dc', 'U');
        replaced = text.replace("\u00df", "ss");
        return replaced;
    }

    public MixedStringComparator(String signature) {
        this.pattern = Pattern.compile(signature);
        this.groups = this.findGroupNames(signature);
    }

    @Override
    public int compare(String obj1, String obj2) {
        String o1 = MixedStringComparator.transform(obj1);
        String o2 = MixedStringComparator.transform(obj2);
        Matcher matcher1 = this.pattern.matcher(o1);
        Matcher matcher2 = this.pattern.matcher(o2);
        if (!matcher1.matches()) {
            throw new IllegalArgumentException("pattern=" + this.pattern.toString() + " input=" + o1);
        }
        if (!matcher2.matches()) {
            throw new IllegalArgumentException("pattern=" + this.pattern.toString() + " input=" + o2);
        }
        for (String groupName : this.groups) {
            String groupO1 = matcher1.group(groupName);
            String groupO2 = matcher2.group(groupName);
            if (groupName.startsWith(NUMBER)) {
                int value2;
                int value1 = Strings.isNullOrEmpty((String)groupO1) ? 0 : Integer.parseInt(groupO1);
                if (value1 < (value2 = Strings.isNullOrEmpty((String)groupO2) ? 0 : Integer.parseInt(groupO2))) {
                    return -1;
                }
                if (value1 <= value2) continue;
                return 1;
            }
            String groupO1NullSafe = groupO1 == null ? "" : groupO1;
            int result = groupO1NullSafe.compareTo(groupO2);
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    private List<String> findGroupNames(String signature) {
        LinkedList<String> result = new LinkedList<String>();
        Matcher matcher = NAME_PATTERN.matcher(signature);
        if (matcher.matches()) {
            String name = matcher.group(1);
            String rest = matcher.group(2);
            result.add(name);
            result.addAll(this.findGroupNames(rest));
        }
        return result;
    }
}

