/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.basis.geometry;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.eclipse.set.basis.geometry.GEOKanteSegment;
import org.eclipse.set.model.planpro.Basisobjekte.Bereich_Objekt;
import org.eclipse.set.model.planpro.Geodaten.GEO_Kante;
import org.eclipse.set.model.planpro.Geodaten.GEO_Knoten;
import org.eclipse.set.model.planpro.Geodaten.TOP_Kante;
import org.locationtech.jts.geom.LineString;

public class GEOKanteMetadata {
    static final double SEGMENT_THRESHOLD = 0.001;
    final GEO_Kante geoKante;
    final GEO_Knoten geoKnoten;
    final LineString geometry;
    final List<GEOKanteSegment> segments = new ArrayList<GEOKanteSegment>();
    final double start;
    final double length;

    public GEO_Kante getGeoKante() {
        return this.geoKante;
    }

    public GEO_Knoten getGeoKnoten() {
        return this.geoKnoten;
    }

    public LineString getGeometry() {
        return this.geometry;
    }

    public List<GEOKanteSegment> getSegments() {
        return this.segments;
    }

    public double getStart() {
        return this.start;
    }

    public double getEnd() {
        return this.start + this.length;
    }

    public double getLength() {
        return this.length;
    }

    public GEOKanteMetadata(GEO_Kante geoKante, double start, double length, List<Bereich_Objekt> bereichObjekt, TOP_Kante topKante, GEO_Knoten geoKnoten, LineString geometry) {
        this.geoKante = geoKante;
        this.start = start;
        this.length = length;
        this.geometry = geometry;
        this.geoKnoten = geoKnoten;
        this.determineSegments(topKante, bereichObjekt);
    }

    public GEOKanteMetadata(GEO_Kante geoKante, double start, GEO_Knoten geoKnoten, LineString geometry) {
        this.geoKante = geoKante;
        this.start = start;
        this.length = GEOKanteMetadata.dermineLength().apply(geoKante);
        this.geometry = geometry;
        this.geoKnoten = geoKnoten;
        this.segments.add(new GEOKanteSegment(start, this.length));
    }

    private static Function<GEO_Kante, Double> dermineLength() {
        return kante -> {
            try {
                return kante.getGEOKanteAllg().getGEOLaenge().getWert().doubleValue();
            }
            catch (NullPointerException e) {
                return 0.0;
            }
        };
    }

    private void determineSegments(TOP_Kante topKante, List<Bereich_Objekt> bereichObjekt) {
        this.segments.add(new GEOKanteSegment(this.start, this.length));
        double end = this.getEnd();
        List<Bereich_Objekt> relevantBOs = bereichObjekt.stream().filter(bo -> bo.getBereichObjektTeilbereich().stream().anyMatch(tb -> {
            boolean existBothOfBound;
            boolean isSameTOPKante = tb.getIDTOPKante() != null && tb.getIDTOPKante().getValue() == topKante;
            boolean bl = existBothOfBound = tb.getBegrenzungA() != null && tb.getBegrenzungA().getWert() != null && tb.getBegrenzungB() != null && tb.getBegrenzungB().getWert() != null;
            return isSameTOPKante && existBothOfBound;
        })).toList();
        relevantBOs.forEach(bo -> bo.getBereichObjektTeilbereich().forEach(tb -> {
            double tbStart = tb.getBegrenzungA().getWert().doubleValue();
            double tbEnd = tb.getBegrenzungB().getWert().doubleValue();
            if (tbStart > end || tbEnd < this.start) {
                return;
            }
            if (!(tbStart <= this.start) || !(tbEnd >= end)) {
                if (tbStart >= this.start && tbEnd <= end) {
                    this.splitSegmentsAt(tbStart);
                    this.splitSegmentsAt(tbEnd);
                } else if (tbStart <= this.start && tbEnd <= end) {
                    this.splitSegmentsAt(tbEnd);
                } else if (tbStart > this.start && tbEnd >= end) {
                    this.splitSegmentsAt(tbStart);
                }
            }
        }));
        this.segments.forEach(segment -> {
            double segStart = segment.getStart();
            double segEnd = segment.getEnd();
            relevantBOs.forEach(bo -> bo.getBereichObjektTeilbereich().forEach(tb -> {
                double tbStart = tb.getBegrenzungA().getWert().doubleValue();
                double tbEnd = tb.getBegrenzungB().getWert().doubleValue();
                if (tbStart > end || tbEnd < this.start) {
                    return;
                }
                if (tbStart > segEnd) {
                    return;
                }
                if (tbEnd < segStart) {
                    return;
                }
                gEOKanteSegment.bereichObjekte.add((Bereich_Objekt)bo);
            }));
        });
    }

    private void splitSegmentsAt(double distance) {
        GEOKanteSegment originalSegment = this.getContainingSegment(distance);
        if (originalSegment == null) {
            throw new RuntimeException("Missing GEO_Kante segment");
        }
        GEOKanteSegment nextSegment = new GEOKanteSegment(originalSegment);
        double firstSegmentLength = distance - originalSegment.getStart();
        double secondSegmentLength = originalSegment.getEnd() - distance;
        if (firstSegmentLength < 0.001 || secondSegmentLength < 0.001) {
            return;
        }
        originalSegment.setLength(firstSegmentLength);
        nextSegment.setStart(distance);
        nextSegment.setLength(secondSegmentLength);
        this.segments.add(nextSegment);
    }

    public GEOKanteSegment getContainingSegment(double distance) {
        return this.segments.stream().filter(segment -> segment.getStart() <= distance && segment.getStart() + segment.getLength() >= distance).findFirst().orElse(null);
    }
}

