/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfcloud.jackson.databind.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emfcloud.jackson.databind.EMFContext;
import org.eclipse.emfcloud.jackson.databind.property.EObjectProperty;
import org.eclipse.emfcloud.jackson.databind.property.EObjectPropertyMap;
import org.eclipse.emfcloud.jackson.utils.EObjects;

public class EObjectSerializer
extends JsonSerializer<EObject> {
    private final JsonSerializer<EObject> refSerializer;
    private final EObjectPropertyMap.Builder builder;

    public EObjectSerializer(EObjectPropertyMap.Builder builder, JsonSerializer<EObject> serializer) {
        this.builder = builder;
        this.refSerializer = serializer;
    }

    public Class<EObject> handledType() {
        return EObject.class;
    }

    public void serialize(EObject object, JsonGenerator jg, SerializerProvider provider) throws IOException {
        EObjectPropertyMap properties = this.builder.construct((DatabindContext)provider, object.eClass());
        EObject parent = EMFContext.getParent((DatabindContext)provider);
        if (parent != null && (object.eIsProxy() || EObjects.isContainmentProxy((DatabindContext)provider, parent, object))) {
            this.refSerializer.serialize((Object)object, jg, provider);
            return;
        }
        jg.writeStartObject();
        for (EObjectProperty property : properties.getProperties()) {
            property.serialize(object, jg, provider);
        }
        jg.writeEndObject();
    }
}

