/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.ui.basic.internal.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.eclipse.emf.common.util.EList;
import org.eclipse.smarthome.io.rest.sitemap.SitemapSubscriptionService;
import org.eclipse.smarthome.model.sitemap.LinkableWidget;
import org.eclipse.smarthome.model.sitemap.Sitemap;
import org.eclipse.smarthome.model.sitemap.SitemapProvider;
import org.eclipse.smarthome.model.sitemap.Widget;
import org.eclipse.smarthome.ui.basic.internal.WebAppConfig;
import org.eclipse.smarthome.ui.basic.internal.render.PageRenderer;
import org.eclipse.smarthome.ui.basic.internal.servlet.BaseServlet;
import org.eclipse.smarthome.ui.basic.render.RenderException;
import org.osgi.framework.BundleContext;
import org.osgi.service.http.NamespaceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebAppServlet
extends BaseServlet {
    private final Logger logger = LoggerFactory.getLogger(WebAppServlet.class);
    public static final String SERVLET_NAME = "app";
    private static final String CONTENT_TYPE_ASYNC = "application/xml;charset=UTF-8";
    private static final String CONTENT_TYPE = "text/html;charset=UTF-8";
    private PageRenderer renderer;
    private SitemapSubscriptionService subscriptions;
    private final WebAppConfig config = new WebAppConfig();
    protected Set<SitemapProvider> sitemapProviders = new CopyOnWriteArraySet<SitemapProvider>();

    public void setSitemapSubscriptionService(SitemapSubscriptionService subscriptions) {
        this.subscriptions = subscriptions;
    }

    public void unsetSitemapSubscriptionService(SitemapSubscriptionService subscriptions) {
        this.subscriptions = null;
    }

    public void addSitemapProvider(SitemapProvider sitemapProvider) {
        this.sitemapProviders.add(sitemapProvider);
    }

    public void removeSitemapProvider(SitemapProvider sitemapProvider) {
        this.sitemapProviders.remove(sitemapProvider);
    }

    public void setPageRenderer(PageRenderer renderer) {
        renderer.setConfig(this.config);
        this.renderer = renderer;
    }

    protected void activate(Map<String, Object> configProps, BundleContext bundleContext) {
        this.config.applyConfig(configProps);
        try {
            Hashtable props = new Hashtable();
            this.httpService.registerServlet("/basicui/app", (Servlet)this, props, this.createHttpContext(bundleContext.getBundle()));
            this.httpService.registerResources("/basicui", "web", this.createHttpContext(bundleContext.getBundle()));
            this.logger.info("Started Basic UI at /basicui/app");
        }
        catch (NamespaceException e) {
            this.logger.error("Error during servlet startup", (Throwable)e);
        }
        catch (ServletException e) {
            this.logger.error("Error during servlet startup", (Throwable)e);
        }
    }

    protected void modified(Map<String, Object> configProps) {
        this.config.applyConfig(configProps);
    }

    protected void deactivate() {
        this.httpService.unregister("/basicui/app");
        this.httpService.unregister("/basicui");
        this.logger.info("Stopped Basic UI");
    }

    private void showSitemapList(ServletResponse res) throws IOException, RenderException {
        PrintWriter resWriter = res.getWriter();
        resWriter.append(this.renderer.renderSitemapList(this.sitemapProviders));
        res.setContentType(CONTENT_TYPE);
    }

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        this.logger.debug("Servlet request received!");
        String sitemapName = req.getParameter("sitemap");
        String widgetId = req.getParameter("w");
        String subscriptionId = req.getParameter("subscriptionId");
        boolean async = "true".equalsIgnoreCase(req.getParameter("__async"));
        if (sitemapName == null) {
            sitemapName = this.config.getDefaultSitemap();
        }
        StringBuilder result = new StringBuilder();
        Sitemap sitemap = null;
        for (SitemapProvider sitemapProvider : this.sitemapProviders) {
            sitemap = sitemapProvider.getSitemap(sitemapName);
            if (sitemap != null) break;
        }
        try {
            if (sitemap == null) {
                this.showSitemapList(res);
                return;
            }
            this.logger.debug("reading sitemap {}", (Object)sitemap.getName());
            if (widgetId == null || widgetId.isEmpty() || widgetId.equals(sitemapName)) {
                if (subscriptionId != null) {
                    if (this.subscriptions.exists(subscriptionId)) {
                        this.subscriptions.setPageId(subscriptionId, sitemap.getName(), sitemapName);
                    } else {
                        this.logger.debug("Basic UI requested a non-existing event subscription id ({})", (Object)subscriptionId);
                    }
                }
                String label = sitemap.getLabel() != null ? sitemap.getLabel() : sitemapName;
                EList children = this.renderer.getItemUIRegistry().getChildren(sitemap);
                result.append((CharSequence)this.renderer.processPage(sitemapName, sitemapName, label, (EList<Widget>)children, async));
            } else if (!widgetId.equals("Colorpicker")) {
                Widget w;
                if (subscriptionId != null) {
                    if (this.subscriptions.exists(subscriptionId)) {
                        this.subscriptions.setPageId(subscriptionId, sitemap.getName(), widgetId);
                    } else {
                        this.logger.debug("Basic UI requested a non-existing event subscription id ({})", (Object)subscriptionId);
                    }
                }
                if ((w = this.renderer.getItemUIRegistry().getWidget(sitemap, widgetId)) != null) {
                    String label = this.renderer.getItemUIRegistry().getLabel(w);
                    if (label == null) {
                        label = "undefined";
                    }
                    if (!(w instanceof LinkableWidget)) {
                        throw new RenderException("Widget '" + w + "' can not have any content");
                    }
                    EList children = this.renderer.getItemUIRegistry().getChildren((LinkableWidget)w);
                    result.append((CharSequence)this.renderer.processPage(this.renderer.getItemUIRegistry().getWidgetId(w), sitemapName, label, (EList<Widget>)children, async));
                }
            }
        }
        catch (RenderException e) {
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
        if (async) {
            res.setContentType(CONTENT_TYPE_ASYNC);
        } else {
            res.setContentType(CONTENT_TYPE);
        }
        res.getWriter().append(result);
        res.getWriter().close();
    }
}

