/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.bosesoundtouch.internal;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.core.thing.Channel;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.type.DynamicStateDescriptionProvider;
import org.eclipse.smarthome.core.types.StateDescription;
import org.eclipse.smarthome.core.types.StateOption;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(service={DynamicStateDescriptionProvider.class, BoseStateDescriptionOptionProvider.class})
@NonNullByDefault
public class BoseStateDescriptionOptionProvider
implements DynamicStateDescriptionProvider {
    private final Map<ChannelUID, @Nullable List<StateOption>> channelOptionsMap = new ConcurrentHashMap<ChannelUID, List<StateOption>>();

    public void setStateOptions(ChannelUID channelUID, List<StateOption> options) {
        this.channelOptionsMap.put(channelUID, options);
    }

    public @Nullable StateDescription getStateDescription(Channel channel, @Nullable StateDescription original, @Nullable Locale locale) {
        List<StateOption> options = this.channelOptionsMap.get(channel.getUID());
        if (options == null) {
            return null;
        }
        if (original != null) {
            return new StateDescription(original.getMinimum(), original.getMaximum(), original.getStep(), original.getPattern(), original.isReadOnly(), options);
        }
        return new StateDescription(null, null, null, null, false, options);
    }

    @Deactivate
    public void deactivate() {
        this.channelOptionsMap.clear();
    }
}

