/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.bosesoundtouch.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.smarthome.binding.bosesoundtouch.internal.ContentItem;
import org.eclipse.smarthome.binding.bosesoundtouch.internal.ContentItemNotPresetableException;
import org.eclipse.smarthome.binding.bosesoundtouch.internal.NoPresetFoundException;
import org.eclipse.smarthome.core.storage.DeletableStorage;
import org.eclipse.smarthome.core.storage.Storage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PresetContainer {
    private final Logger logger = LoggerFactory.getLogger(PresetContainer.class);
    private HashMap<Integer, ContentItem> mapOfPresets;
    private Storage<ContentItem> storage;

    public PresetContainer(Storage<ContentItem> storage) {
        this.storage = storage;
        this.init();
    }

    private void init() {
        this.mapOfPresets = new HashMap();
        this.readFromStorage();
    }

    public Collection<ContentItem> getAllPresets() {
        return this.mapOfPresets.values();
    }

    public void put(int presetID, ContentItem preset) throws ContentItemNotPresetableException {
        preset.setPresetID(presetID);
        if (!preset.isPresetable()) {
            throw new ContentItemNotPresetableException();
        }
        this.mapOfPresets.put(presetID, preset);
        this.writeToStorage();
    }

    public void remove(int presetID) {
        this.mapOfPresets.remove(presetID);
        this.writeToStorage();
    }

    public ContentItem get(int presetID) throws NoPresetFoundException {
        ContentItem psFound = this.mapOfPresets.get(presetID);
        if (psFound != null) {
            return psFound;
        }
        throw new NoPresetFoundException();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void clear() {
        if (this.storage instanceof DeletableStorage) {
            ((DeletableStorage)this.storage).delete();
        } else {
            @NonNull Collection keys = this.storage.getKeys();
            keys.forEach(key -> {
                Object object = this.storage.remove(key);
            });
        }
    }

    private void writeToStorage() {
        Collection<ContentItem> colletionOfPresets = this.getAllPresets();
        ArrayList<ContentItem> listOfPresets = new ArrayList<ContentItem>();
        listOfPresets.addAll(colletionOfPresets);
        Iterator cii = listOfPresets.iterator();
        while (cii.hasNext()) {
            if (((ContentItem)cii.next()).getPresetID() > 6) continue;
            cii.remove();
        }
        if (listOfPresets.size() > 0) {
            listOfPresets.forEach(item -> {
                Object object = this.storage.put(String.valueOf(item.getPresetID()), item);
            });
        }
    }

    private void readFromStorage() {
        Collection items = this.storage.getValues();
        for (ContentItem item : items) {
            try {
                this.put(item.getPresetID(), item);
            }
            catch (ContentItemNotPresetableException contentItemNotPresetableException) {
                this.logger.debug("Item '{}' is not presetable - ignoring it.", (Object)item.getItemName());
            }
        }
    }
}

