/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.wemo.internal.http;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Properties;
import org.eclipse.smarthome.io.net.http.HttpUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WemoHttpCall {
    private final Logger logger = LoggerFactory.getLogger(WemoHttpCall.class);

    public String executeCall(String wemoURL, String soapHeader, String content) {
        try {
            Properties wemoHeaders = new Properties();
            wemoHeaders.setProperty("CONTENT-TYPE", "text/xml; charset=utf-8");
            wemoHeaders.put("SOAPACTION", soapHeader);
            ByteArrayInputStream wemoContent = new ByteArrayInputStream(content.getBytes(Charset.forName("UTF-8")));
            String wemoCallResponse = HttpUtil.executeUrl((String)"POST", (String)wemoURL, (Properties)wemoHeaders, (InputStream)wemoContent, null, (int)2000);
            return wemoCallResponse;
        }
        catch (IOException iOException) {
            this.logger.debug("Could not make HTTP call to WeMo");
            return null;
        }
    }
}

