/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.rest.optimize.internal;

import com.eclipsesource.jaxrs.publisher.ResourceFilter;
import com.eclipsesource.jaxrs.publisher.ServiceProperties;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceFilterImpl
implements ResourceFilter {
    private final Logger logger = LoggerFactory.getLogger(ResourceFilterImpl.class);
    private static final String[] WHITELIST = new String[]{"javax.ws.rs.ext.MessageBodyReader", "javax.ws.rs.ext.MessageBodyWriter", "org.eclipse.smarthome.io.rest.internal.filter.ProxyFilter", "org.eclipse.smarthome.io.rest.internal.resources.RootResource", "org.eclipse.smarthome.io.rest.JSONResponse$ExceptionMapper", "org.eclipse.smarthome.io.rest.RESTResource", "org.eclipse.smarthome.io.rest.sse.internal.async.BlockingAsyncFeature", "org.eclipse.smarthome.io.rest.sse.SseResource", "org.glassfish.jersey.media.sse.SseFeature", "org.glassfish.jersey.server.monitoring.ApplicationEventListener"};

    public Filter getFilter() {
        String filterString = this.createFilter(WHITELIST);
        try {
            return FrameworkUtil.createFilter((String)filterString);
        }
        catch (InvalidSyntaxException e) {
            this.logger.error("Error creating RESTResource filter", (Throwable)e);
            return null;
        }
    }

    private String createFilter(String[] interfaces) {
        StringBuilder builder = new StringBuilder();
        builder.append("(&");
        builder.append("(|");
        List<String> whitelist = this.loadWhitelistExtension();
        if (whitelist == null) {
            this.logger.debug("No /res/whitelist.txt file found - scanning all unknown services");
            builder.append("(!(objectClass=org.eclipse.smarthome.*))");
        } else {
            this.logger.debug("Whitelist /res/whitelist.txt file found - restricting scanning of services");
            whitelist.forEach(entry -> builder.append("(objectClass=" + entry + ")"));
        }
        String[] stringArray = interfaces;
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            String clazz = stringArray[n2];
            builder.append("(objectClass=" + clazz + ")");
            ++n2;
        }
        builder.append(")");
        builder.append("(!(" + ServiceProperties.PUBLISH + "=false)))");
        return builder.toString();
    }

    private List<String> loadWhitelistExtension() {
        Enumeration entries = FrameworkUtil.getBundle(this.getClass()).findEntries("res", "whitelist.txt", false);
        if (entries != null && entries.hasMoreElements()) {
            URL url = (URL)entries.nextElement();
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (InputStream is = url.openStream();){
                    return this.readWhitelistEntries(is);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                this.logger.warn("Error reading REST extension whitelist from {}", (Object)url, (Object)e);
                return null;
            }
        }
        return null;
    }

    private List<String> readWhitelistEntries(InputStream stream) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
        LinkedList<String> ret = new LinkedList<String>();
        String line = reader.readLine();
        while (line != null) {
            String trimmed = line.trim();
            if (!trimmed.isEmpty() && !trimmed.startsWith("#")) {
                ret.add(trimmed);
            }
            line = reader.readLine();
        }
        return ret;
    }
}

