package org.eclipse.smarthome.model.serializer;

import com.google.inject.Inject;
import com.google.inject.Provider;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.smarthome.model.items.ItemModel;
import org.eclipse.smarthome.model.items.ItemsPackage;
import org.eclipse.smarthome.model.items.ModelBinding;
import org.eclipse.smarthome.model.items.ModelGroupItem;
import org.eclipse.smarthome.model.items.ModelNormalItem;
import org.eclipse.smarthome.model.services.ItemsGrammarAccess;
import org.eclipse.xtext.serializer.acceptor.ISemanticSequenceAcceptor;
import org.eclipse.xtext.serializer.acceptor.SequenceFeeder;
import org.eclipse.xtext.serializer.diagnostic.ISemanticSequencerDiagnosticProvider;
import org.eclipse.xtext.serializer.diagnostic.ISerializationDiagnostic.Acceptor;
import org.eclipse.xtext.serializer.sequencer.AbstractDelegatingSemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.GenericSequencer;
import org.eclipse.xtext.serializer.sequencer.ISemanticNodeProvider.INodesForEObjectProvider;
import org.eclipse.xtext.serializer.sequencer.ISemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService.ValueTransient;

@SuppressWarnings("all")
public class ItemsSemanticSequencer extends AbstractDelegatingSemanticSequencer {

	@Inject
	private ItemsGrammarAccess grammarAccess;
	
	public void createSequence(EObject context, EObject semanticObject) {
		if(semanticObject.eClass().getEPackage() == ItemsPackage.eINSTANCE) switch(semanticObject.eClass().getClassifierID()) {
			case ItemsPackage.ITEM_MODEL:
				if(context == grammarAccess.getItemModelRule()) {
					sequence_ItemModel(context, (ItemModel) semanticObject); 
					return; 
				}
				else break;
			case ItemsPackage.MODEL_BINDING:
				if(context == grammarAccess.getModelBindingRule()) {
					sequence_ModelBinding(context, (ModelBinding) semanticObject); 
					return; 
				}
				else break;
			case ItemsPackage.MODEL_GROUP_ITEM:
				if(context == grammarAccess.getModelGroupItemRule()) {
					sequence_ModelGroupItem(context, (ModelGroupItem) semanticObject); 
					return; 
				}
				else if(context == grammarAccess.getModelItemRule()) {
					sequence_ModelGroupItem_ModelItem(context, (ModelGroupItem) semanticObject); 
					return; 
				}
				else break;
			case ItemsPackage.MODEL_NORMAL_ITEM:
				if(context == grammarAccess.getModelItemRule()) {
					sequence_ModelItem_ModelNormalItem(context, (ModelNormalItem) semanticObject); 
					return; 
				}
				else if(context == grammarAccess.getModelNormalItemRule()) {
					sequence_ModelNormalItem(context, (ModelNormalItem) semanticObject); 
					return; 
				}
				else break;
			}
		if (errorAcceptor != null) errorAcceptor.accept(diagnosticProvider.createInvalidContextOrTypeDiagnostic(semanticObject, context));
	}
	
	/**
	 * Constraint:
	 *     (items+=ModelItem*)
	 */
	protected void sequence_ItemModel(EObject context, ItemModel semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (type=ID configuration=STRING)
	 */
	protected void sequence_ModelBinding(EObject context, ModelBinding semanticObject) {
		if(errorAcceptor != null) {
			if(transientValues.isValueTransient(semanticObject, ItemsPackage.Literals.MODEL_BINDING__TYPE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, ItemsPackage.Literals.MODEL_BINDING__TYPE));
			if(transientValues.isValueTransient(semanticObject, ItemsPackage.Literals.MODEL_BINDING__CONFIGURATION) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, ItemsPackage.Literals.MODEL_BINDING__CONFIGURATION));
		}
		INodesForEObjectProvider nodes = createNodeProvider(semanticObject);
		SequenceFeeder feeder = createSequencerFeeder(semanticObject, nodes);
		feeder.accept(grammarAccess.getModelBindingAccess().getTypeIDTerminalRuleCall_0_0(), semanticObject.getType());
		feeder.accept(grammarAccess.getModelBindingAccess().getConfigurationSTRINGTerminalRuleCall_2_0(), semanticObject.getConfiguration());
		feeder.finish();
	}
	
	
	/**
	 * Constraint:
	 *     ((type=ModelItemType (function=ModelGroupFunction ((args+=ID | args+=STRING) (args+=ID | args+=STRING)*)?)?)?)
	 */
	protected void sequence_ModelGroupItem(EObject context, ModelGroupItem semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (
	 *         (type=ModelItemType (function=ModelGroupFunction ((args+=ID | args+=STRING) (args+=ID | args+=STRING)*)?)?)? 
	 *         name=ID 
	 *         label=STRING? 
	 *         (icon=ID | icon=STRING)? 
	 *         (groups+=ID groups+=ID*)? 
	 *         (bindings+=ModelBinding bindings+=ModelBinding*)?
	 *     )
	 */
	protected void sequence_ModelGroupItem_ModelItem(EObject context, ModelGroupItem semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (
	 *         type=ModelItemType 
	 *         name=ID 
	 *         label=STRING? 
	 *         (icon=ID | icon=STRING)? 
	 *         (groups+=ID groups+=ID*)? 
	 *         (bindings+=ModelBinding bindings+=ModelBinding*)?
	 *     )
	 */
	protected void sequence_ModelItem_ModelNormalItem(EObject context, ModelNormalItem semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     type=ModelItemType
	 */
	protected void sequence_ModelNormalItem(EObject context, ModelNormalItem semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
}
