/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.module.script.internal;

import com.google.common.base.Joiner;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.eclipse.smarthome.automation.handler.ModuleHandlerFactory;
import org.eclipse.smarthome.automation.module.script.ScriptScopeProvider;
import org.eclipse.smarthome.automation.module.script.internal.factory.ScriptModuleHandlerFactory;
import org.eclipse.smarthome.automation.module.script.internal.handler.AbstractScriptModuleHandler;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptModuleActivator
implements BundleActivator {
    private static final Logger logger = LoggerFactory.getLogger(ScriptModuleActivator.class);
    private BundleContext context;
    private ScriptModuleHandlerFactory moduleHandlerFactory;
    private ServiceRegistration factoryRegistration;
    private ServiceTracker scriptScopeProviderServiceTracker;
    private static Set<ScriptScopeProvider> scriptScopeProviders;
    private static final ScriptEngineManager engineManager;
    protected static final Map<String, ScriptEngine> engines;

    static {
        engineManager = new ScriptEngineManager();
        engines = new HashMap<String, ScriptEngine>();
    }

    public BundleContext getContext() {
        return this.context;
    }

    public void start(final BundleContext bundleContext) throws Exception {
        this.context = bundleContext;
        this.moduleHandlerFactory = new ScriptModuleHandlerFactory();
        this.moduleHandlerFactory.activate(this.context);
        this.factoryRegistration = bundleContext.registerService(ModuleHandlerFactory.class.getName(), (Object)this.moduleHandlerFactory, null);
        scriptScopeProviders = new CopyOnWriteArraySet<ScriptScopeProvider>();
        this.scriptScopeProviderServiceTracker = new ServiceTracker(bundleContext, ScriptScopeProvider.class.getName(), new ServiceTrackerCustomizer(){

            public Object addingService(ServiceReference reference) {
                Object service = bundleContext.getService(reference);
                if (service instanceof ScriptScopeProvider) {
                    ScriptScopeProvider provider = (ScriptScopeProvider)service;
                    scriptScopeProviders.add(provider);
                    for (ScriptEngine engine : engines.values()) {
                        ScriptModuleActivator.initializeGeneralScope(engine, provider);
                    }
                    return service;
                }
                return null;
            }

            public void modifiedService(ServiceReference reference, Object service) {
            }

            public void removedService(ServiceReference reference, Object service) {
                if (service instanceof ScriptScopeProvider) {
                    ScriptScopeProvider provider = (ScriptScopeProvider)service;
                    scriptScopeProviders.remove(provider);
                    for (ScriptEngine engine : engines.values()) {
                        for (String key : provider.getScopeElements().keySet()) {
                            engine.getBindings(100).remove(key);
                        }
                    }
                }
            }
        });
        this.scriptScopeProviderServiceTracker.open();
        logger.debug("Started script automation support");
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.context = null;
        this.moduleHandlerFactory.dispose();
        if (this.factoryRegistration != null) {
            this.factoryRegistration.unregister();
        }
        this.moduleHandlerFactory = null;
        this.scriptScopeProviderServiceTracker.close();
        scriptScopeProviders.clear();
        scriptScopeProviders = null;
    }

    public static synchronized ScriptEngine getScriptEngine(String type) {
        ScriptEngine engine = engines.get(type);
        if (engine == null) {
            engine = engineManager.getEngineByMimeType(type);
            for (ScriptScopeProvider provider : scriptScopeProviders) {
                ScriptModuleActivator.initializeScope(engine, provider);
            }
            engines.put(type, engine);
        }
        return engine;
    }

    private static void initializeScope(ScriptEngine engine, ScriptScopeProvider provider) {
        if (engine.getFactory().getEngineName().toLowerCase().endsWith("nashorn")) {
            ScriptModuleActivator.initializeNashornScope(engine, provider);
        } else {
            ScriptModuleActivator.initializeGeneralScope(engine, provider);
        }
    }

    private static void initializeNashornScope(ScriptEngine engine, ScriptScopeProvider provider) {
        if (!AbstractScriptModuleHandler.class.getClassLoader().getParent().toString().contains("ExtClassLoader")) {
            logger.warn("Found wrong classloader: To prevent class loading problems use this directive: -Dorg.osgi.framework.bundle.parent=ext");
        }
        logger.debug("initializing script scope from '{}' for engine '{}'.", new Object[]{provider.getClass().getSimpleName(), engine.getFactory().getEngineName()});
        HashSet<String> expressions = new HashSet<String>();
        for (Map.Entry<String, Object> entry : provider.getScopeElements().entrySet()) {
            if (entry.getValue() instanceof Class) {
                Class c = (Class)entry.getValue();
                expressions.add(String.valueOf(entry.getKey()) + " = Java.type('" + c.getCanonicalName() + "')");
                continue;
            }
            engine.put(entry.getKey(), entry.getValue());
        }
        String scriptToEval = Joiner.on((String)",\n").join(expressions);
        try {
            engine.eval(scriptToEval);
        }
        catch (Exception e) {
            logger.error("Exception while importing scope: {}", (Object)e.getMessage());
        }
    }

    private static void initializeGeneralScope(ScriptEngine engine, ScriptScopeProvider provider) {
        logger.debug("initializing script scope from '{}' for engine '{}'.", new Object[]{provider.getClass().getSimpleName(), engine.getFactory().getEngineName()});
        for (Map.Entry<String, Object> entry : provider.getScopeElements().entrySet()) {
            engine.put(entry.getKey(), entry.getValue());
        }
    }
}

