/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.config.dispatch.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchService;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.smarthome.config.core.ConfigConstants;
import org.eclipse.smarthome.core.service.AbstractWatchQueueReader;
import org.eclipse.smarthome.core.service.AbstractWatchService;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigDispatcher
extends AbstractWatchService {
    public static final String SERVICEDIR_PROG_ARGUMENT = "smarthome.servicedir";
    public static final String SERVICEPID_PROG_ARGUMENT = "smarthome.servicepid";
    public static final String SERVICECFG_PROG_ARGUMENT = "smarthome.servicecfg";
    public static final String SERVICES_FOLDER = "services";
    public static final String SERVICE_PID_NAMESPACE = "org.eclipse.smarthome";
    public static final String SERVICE_CFG_FILE = "smarthome.cfg";
    private static final String PID_MARKER = "pid:";
    private final Logger logger = LoggerFactory.getLogger(ConfigDispatcher.class);
    private ConfigurationAdmin configAdmin;

    public void activate() {
        super.activate();
        this.readDefaultConfig();
        this.readConfigs();
    }

    public void deactivate() {
        super.deactivate();
    }

    protected void setConfigurationAdmin(ConfigurationAdmin configAdmin) {
        this.configAdmin = configAdmin;
    }

    protected void unsetConfigurationAdmin(ConfigurationAdmin configAdmin) {
        this.configAdmin = null;
    }

    protected String getSourcePath() {
        String progArg = System.getProperty(SERVICEDIR_PROG_ARGUMENT);
        if (progArg != null) {
            return String.valueOf(ConfigConstants.getConfigFolder()) + File.separator + progArg;
        }
        return String.valueOf(ConfigConstants.getConfigFolder()) + File.separator + SERVICES_FOLDER;
    }

    protected boolean watchSubDirectories() {
        return false;
    }

    protected void registerDirectory(Path subDir) throws IOException {
        subDir.register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
    }

    protected AbstractWatchQueueReader buildWatchQueueReader(WatchService watchService, Path toWatch) {
        return new WatchQueueReader(watchService, toWatch);
    }

    private String getDefaultServiceConfigFile() {
        String progArg = System.getProperty(SERVICECFG_PROG_ARGUMENT);
        if (progArg != null) {
            return progArg;
        }
        return String.valueOf(ConfigConstants.getConfigFolder()) + File.separator + SERVICE_CFG_FILE;
    }

    private void readDefaultConfig() {
        File defaultCfg = new File(this.getDefaultServiceConfigFile());
        try {
            this.processConfigFile(defaultCfg);
        }
        catch (IOException e) {
            this.logger.warn("Could not process default config file '{}': {}", (Object)this.getDefaultServiceConfigFile(), (Object)e);
        }
    }

    private void readConfigs() {
        File dir = new File(this.getSourcePath());
        if (dir.exists()) {
            File[] files;
            File[] fileArray = files = dir.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                try {
                    this.processConfigFile(file);
                }
                catch (IOException e) {
                    this.logger.warn("Could not process config file '{}': {}", (Object)file.getName(), (Object)e);
                }
                ++n2;
            }
        } else {
            this.logger.debug("Configuration folder '{}' does not exist.", (Object)dir.toString());
        }
    }

    private static String getServicePidNamespace() {
        String progArg = System.getProperty(SERVICEPID_PROG_ARGUMENT);
        if (progArg != null) {
            return progArg;
        }
        return SERVICE_PID_NAMESPACE;
    }

    private void processConfigFile(File configFile) throws IOException, FileNotFoundException {
        if (configFile.isDirectory() || !configFile.getName().endsWith(".cfg")) {
            this.logger.debug("Ignoring file '{}'", (Object)configFile.getName());
            return;
        }
        this.logger.debug("Processing config file '{}'", (Object)configFile.getName());
        HashMap<Configuration, Dictionary> configsToUpdate = new HashMap<Configuration, Dictionary>();
        HashMap<Configuration, Dictionary> configMap = new HashMap<Configuration, Dictionary>();
        String filenameWithoutExt = StringUtils.substringBeforeLast((String)configFile.getName(), (String)".");
        String pid = filenameWithoutExt.contains(".") ? filenameWithoutExt : String.valueOf(ConfigDispatcher.getServicePidNamespace()) + "." + filenameWithoutExt;
        List lines = IOUtils.readLines((InputStream)new FileInputStream(configFile));
        if (lines.size() > 0 && ((String)lines.get(0)).startsWith(PID_MARKER)) {
            pid = ((String)lines.get(0)).substring(PID_MARKER.length()).trim();
        }
        for (String string : lines) {
            String[] contents = this.parseLine(configFile.getPath(), string);
            if (contents == null) continue;
            if (contents[0] != null && !(pid = contents[0]).contains(".")) {
                pid = String.valueOf(ConfigDispatcher.getServicePidNamespace()) + "." + pid;
            }
            String property = contents[1];
            String value = contents[2];
            Configuration configuration = this.configAdmin.getConfiguration(pid, null);
            if (configuration == null) continue;
            Dictionary configProperties = (Dictionary)configMap.get(configuration);
            if (configProperties == null) {
                configProperties = configuration.getProperties() != null ? configuration.getProperties() : new Properties();
                configMap.put(configuration, configProperties);
            }
            if (value.equals(configProperties.get(property))) continue;
            configProperties.put(property, value);
            configsToUpdate.put(configuration, configProperties);
        }
        for (Map.Entry entry : configsToUpdate.entrySet()) {
            ((Configuration)entry.getKey()).update((Dictionary)entry.getValue());
        }
    }

    private String[] parseLine(String filePath, String line) {
        String trimmedLine = line.trim();
        if (trimmedLine.startsWith("#") || trimmedLine.isEmpty()) {
            return null;
        }
        String pid = null;
        String key = StringUtils.substringBefore((String)trimmedLine, (String)"=");
        if (key.contains(":")) {
            pid = StringUtils.substringBefore((String)key, (String)":");
            trimmedLine = trimmedLine.substring(pid.length() + 1);
            pid = pid.trim();
        }
        if (!trimmedLine.isEmpty() && trimmedLine.substring(1).contains("=")) {
            String property = StringUtils.substringBefore((String)trimmedLine, (String)"=");
            String value = trimmedLine.substring(property.length() + 1);
            return new String[]{pid, property.trim(), value.trim()};
        }
        this.logger.warn("Could not parse line '{}'", (Object)line);
        return null;
    }

    private class WatchQueueReader
    extends AbstractWatchQueueReader {
        public WatchQueueReader(WatchService watchService, Path dir) {
            super(watchService, dir);
        }

        protected void processWatchEvent(WatchEvent<?> event, WatchEvent.Kind<?> kind, Path path) {
            if (kind == StandardWatchEventKinds.ENTRY_CREATE || kind == StandardWatchEventKinds.ENTRY_MODIFY) {
                try {
                    ConfigDispatcher.this.processConfigFile(new File(this.dir.toAbsolutePath() + File.separator + path.toString()));
                }
                catch (IOException e) {
                    this.logger.warn("Could not process config file '{}': {}", (Object)path, (Object)e);
                }
            }
        }
    }
}

