/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.console.internal.extension;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemRegistry;
import org.eclipse.smarthome.io.console.Console;
import org.eclipse.smarthome.io.console.extensions.AbstractConsoleCommandExtension;

public class ItemConsoleCommandExtension
extends AbstractConsoleCommandExtension {
    private static final String SUBCMD_LIST = "list";
    private static final String SUBCMD_CLEAR = "clear";
    private static final String SUBCMD_REMOVE = "remove";
    private ItemRegistry itemRegistry;

    public ItemConsoleCommandExtension() {
        super("items", "Access the item registry.");
    }

    @Override
    public List<String> getUsages() {
        return Arrays.asList(this.buildCommandUsage("list [<pattern>]", "lists names and types of all items (matching the pattern, if given)"), this.buildCommandUsage(SUBCMD_CLEAR, "removes all items"), this.buildCommandUsage("remove <itemName>", "removes the given item"));
    }

    @Override
    public void execute(String[] args, Console console) {
        block16: {
            block14: {
                String subCommand;
                if (args.length <= 0) break block14;
                switch (subCommand = args[0]) {
                    case "list": {
                        this.listItems(console, args.length < 2 ? "*" : args[1]);
                        break;
                    }
                    case "clear": {
                        this.removeItems(console, this.itemRegistry.getAll());
                        break;
                    }
                    case "remove": {
                        if (args.length > 1) {
                            String name = args[1];
                            Item item = (Item)this.itemRegistry.get((Object)name);
                            this.removeItems(console, Collections.singleton(item));
                            break;
                        }
                        console.println("Specify the name of the item to remove: " + this.getCommand() + " " + SUBCMD_REMOVE + " <itemName>");
                        break;
                    }
                    default: {
                        console.println("Unknown command '" + subCommand + "'");
                        this.printUsage(console);
                        break;
                    }
                }
                break block16;
            }
            this.listItems(console, "*");
        }
    }

    private void removeItems(Console console, Collection<Item> items) {
        int count = items.size();
        for (Item item : items) {
            this.itemRegistry.remove((Object)item.getName());
        }
        console.println(String.valueOf(count) + " item(s) removed successfully.");
    }

    private void listItems(Console console, String pattern) {
        Collection items = this.itemRegistry.getItems(pattern);
        if (items.size() > 0) {
            for (Item item : items) {
                console.println(item.toString());
            }
        } else {
            console.println("No item found for this pattern.");
        }
    }

    protected void setItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry = itemRegistry;
    }

    protected void unsetItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry = null;
    }
}

