/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.net.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtil {
    private static final Pattern URL_CREDENTIALS_PATTERN = Pattern.compile("http://(.*?):(.*?)@.*");

    public static String executeUrl(String httpMethod, String url, int timeout) {
        return HttpUtil.executeUrl(httpMethod, url, null, null, timeout);
    }

    public static String executeUrl(String httpMethod, String url, InputStream content, String contentType, int timeout) {
        return HttpUtil.executeUrl(httpMethod, url, null, content, contentType, timeout);
    }

    public static String executeUrl(String httpMethod, String url, Properties httpHeaders, InputStream content, String contentType, int timeout) {
        String proxySet = System.getProperty("http.proxySet");
        String proxyHost = null;
        int proxyPort = 80;
        String proxyUser = null;
        String proxyPassword = null;
        String nonProxyHosts = null;
        if ("true".equalsIgnoreCase(proxySet)) {
            proxyHost = System.getProperty("http.proxyHost");
            String proxyPortString = System.getProperty("http.proxyPort");
            if (StringUtils.isNotBlank((String)proxyPortString)) {
                try {
                    proxyPort = Integer.valueOf(proxyPortString);
                }
                catch (NumberFormatException numberFormatException) {
                    LoggerFactory.getLogger(HttpUtil.class).warn("'{}' is not a valid proxy port - using port 80 instead");
                }
            }
            proxyUser = System.getProperty("http.proxyUser");
            proxyPassword = System.getProperty("http.proxyPassword");
            nonProxyHosts = System.getProperty("http.nonProxyHosts");
        }
        return HttpUtil.executeUrl(httpMethod, url, httpHeaders, content, contentType, timeout, proxyHost, proxyPort, proxyUser, proxyPassword, nonProxyHosts);
    }

    public static String executeUrl(String httpMethod, String url, Properties httpHeaders, InputStream content, String contentType, int timeout, String proxyHost, Integer proxyPort, String proxyUser, String proxyPassword, String nonProxyHosts) {
        Logger logger;
        Credentials credentials;
        HttpClient client = new HttpClient();
        if (StringUtils.isNotBlank((String)proxyHost) && proxyPort != null && HttpUtil.shouldUseProxy(url, nonProxyHosts)) {
            client.getHostConfiguration().setProxy(proxyHost, proxyPort.intValue());
            if (StringUtils.isNotBlank((String)proxyUser)) {
                client.getState().setProxyCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(proxyUser, proxyPassword));
            }
        }
        HttpMethod method = HttpUtil.createHttpMethod(httpMethod, url);
        method.getParams().setSoTimeout(timeout);
        method.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(3, false));
        if (httpHeaders != null) {
            for (String httpHeaderKey : httpHeaders.stringPropertyNames()) {
                method.addRequestHeader(new Header(httpHeaderKey, httpHeaders.getProperty(httpHeaderKey)));
            }
        }
        if (method instanceof EntityEnclosingMethod && content != null) {
            EntityEnclosingMethod eeMethod = (EntityEnclosingMethod)method;
            eeMethod.setRequestEntity((RequestEntity)new InputStreamRequestEntity(content, contentType));
        }
        if ((credentials = HttpUtil.extractCredentials(url)) != null) {
            client.getParams().setAuthenticationPreemptive(true);
            client.getState().setCredentials(AuthScope.ANY, credentials);
        }
        if ((logger = LoggerFactory.getLogger(HttpUtil.class)).isDebugEnabled()) {
            try {
                logger.debug("About to execute '" + method.getURI().toString() + "'");
            }
            catch (URIException e) {
                logger.debug(e.getMessage());
            }
        }
        try {
            String responseBody;
            int statusCode = client.executeMethod(method);
            if (statusCode >= 400) {
                logger.debug("Method failed: " + method.getStatusLine());
            }
            if (!(responseBody = IOUtils.toString((InputStream)method.getResponseBodyAsStream())).isEmpty()) {
                logger.trace(responseBody);
            }
            String string = responseBody;
            return string;
        }
        catch (HttpException he) {
            logger.error("Fatal protocol violation: {}", (Object)he.toString());
        }
        catch (IOException ioe) {
            logger.error("Fatal transport error: {}", (Object)ioe.toString());
        }
        finally {
            method.releaseConnection();
        }
        return null;
    }

    private static boolean shouldUseProxy(String urlString, String nonProxyHosts) {
        if (StringUtils.isNotBlank((String)nonProxyHosts)) {
            String[] hosts;
            String givenHost = urlString;
            try {
                URL url = new URL(urlString);
                givenHost = url.getHost();
            }
            catch (MalformedURLException malformedURLException) {
                LoggerFactory.getLogger(HttpUtil.class).error("the given url {} is malformed", (Object)urlString);
            }
            String[] stringArray = hosts = nonProxyHosts.split("\\|");
            int n = hosts.length;
            int n2 = 0;
            while (n2 < n) {
                String host = stringArray[n2];
                if (host.contains("*")) {
                    String hostRegexp = host.replaceAll("\\.", "\\\\.");
                    if (givenHost.matches(hostRegexp = hostRegexp.replaceAll("\\*", ".*"))) {
                        return false;
                    }
                } else if (givenHost.equals(host)) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    protected static Credentials extractCredentials(String url) {
        Matcher matcher = URL_CREDENTIALS_PATTERN.matcher(url);
        if (matcher.matches()) {
            matcher.reset();
            String username = "";
            String password = "";
            while (matcher.find()) {
                username = matcher.group(1);
                password = matcher.group(2);
            }
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(username, password);
            return credentials;
        }
        return null;
    }

    public static HttpMethod createHttpMethod(String httpMethodString, String url) {
        if ("GET".equals(httpMethodString)) {
            return new GetMethod(url);
        }
        if ("PUT".equals(httpMethodString)) {
            return new PutMethod(url);
        }
        if ("POST".equals(httpMethodString)) {
            return new PostMethod(url);
        }
        if ("DELETE".equals(httpMethodString)) {
            return new DeleteMethod(url);
        }
        throw new IllegalArgumentException("given httpMethod '" + httpMethodString + "' is unknown");
    }
}

