/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.model.thing.internal;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.smarthome.core.common.registry.AbstractProvider;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.link.ItemChannelLink;
import org.eclipse.smarthome.core.thing.link.ItemChannelLinkProvider;
import org.eclipse.smarthome.model.core.EventType;
import org.eclipse.smarthome.model.core.ModelRepository;
import org.eclipse.smarthome.model.core.ModelRepositoryChangeListener;
import org.eclipse.smarthome.model.item.BindingConfigParseException;
import org.eclipse.smarthome.model.item.BindingConfigReader;

public class GenericItemChannelLinkProvider
extends AbstractProvider<ItemChannelLink>
implements BindingConfigReader,
ItemChannelLinkProvider,
ModelRepositoryChangeListener {
    protected Map<String, Set<ItemChannelLink>> itemChannelLinkMap = new ConcurrentHashMap<String, Set<ItemChannelLink>>();
    protected Map<String, Set<String>> contextMap = new ConcurrentHashMap<String, Set<String>>();
    private ModelRepository modelRepository = null;
    private Set<String> previousItemNames;

    public String getBindingType() {
        return "channel";
    }

    public void validateItemType(String itemType, String bindingConfig) throws BindingConfigParseException {
    }

    public void processBindingConfiguration(String context, String itemType, String itemName, String bindingConfig) throws BindingConfigParseException {
        String[] uids = bindingConfig.split(",");
        if (uids.length == 0) {
            throw new BindingConfigParseException("At least one Channel UID should be provided: <bindingID>.<thingTypeId>.<thingId>.<channelId>");
        }
        String[] stringArray = uids;
        int n = uids.length;
        int n2 = 0;
        while (n2 < n) {
            String uid = stringArray[n2];
            this.createItemChannelLink(context, itemName, uid.trim());
            ++n2;
        }
    }

    private void createItemChannelLink(String context, String itemName, String channelUID) throws BindingConfigParseException {
        Set<ItemChannelLink> links;
        ChannelUID channelUIDObject = null;
        try {
            channelUIDObject = new ChannelUID(channelUID);
        }
        catch (IllegalArgumentException e) {
            throw new BindingConfigParseException(e.getMessage());
        }
        ItemChannelLink itemChannelLink = new ItemChannelLink(itemName, channelUIDObject);
        Set<String> itemNames = this.contextMap.get(context);
        if (itemNames == null) {
            itemNames = new HashSet<String>();
            this.contextMap.put(context, itemNames);
        }
        itemNames.add(itemName);
        if (this.previousItemNames != null) {
            this.previousItemNames.remove(itemName);
        }
        if ((links = this.itemChannelLinkMap.get(itemName)) == null) {
            links = new HashSet<ItemChannelLink>();
            this.itemChannelLinkMap.put(itemName, links);
        }
        if (!links.contains(itemChannelLink)) {
            links.add(itemChannelLink);
            this.notifyListenersAboutAddedElement(itemChannelLink);
        } else {
            this.notifyListenersAboutUpdatedElement(itemChannelLink, itemChannelLink);
        }
    }

    public void startConfigurationUpdate(String context) {
        this.previousItemNames = this.contextMap.get(context);
    }

    public void stopConfigurationUpdate(String context) {
        if (this.previousItemNames != null) {
            for (String itemName : this.previousItemNames) {
                Set<ItemChannelLink> links = this.itemChannelLinkMap.remove(itemName);
                if (links == null) continue;
                for (ItemChannelLink removedItemChannelLink : links) {
                    this.notifyListenersAboutRemovedElement(removedItemChannelLink);
                }
            }
            this.contextMap.remove(context);
        }
    }

    public Collection<ItemChannelLink> getAll() {
        return Lists.newLinkedList((Iterable)Iterables.concat(this.itemChannelLinkMap.values()));
    }

    public void setModelRepository(ModelRepository modelRepository) {
        this.modelRepository = modelRepository;
        modelRepository.addModelRepositoryChangeListener((ModelRepositoryChangeListener)this);
    }

    public void unsetModelRepository(ModelRepository modelRepository) {
        modelRepository.removeModelRepositoryChangeListener((ModelRepositoryChangeListener)this);
        this.modelRepository = null;
    }

    public void modelChanged(String modelName, EventType type) {
        if (modelName.endsWith("items")) {
            switch (type) {
                case ADDED: {
                    this.startConfigurationUpdate(modelName);
                    break;
                }
                case MODIFIED: {
                    this.startConfigurationUpdate(modelName);
                    break;
                }
                case REMOVED: {
                    this.startConfigurationUpdate(modelName);
                    this.stopConfigurationUpdate(modelName);
                }
            }
        }
    }
}

