/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.dto;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.smarthome.automation.Trigger;
import org.eclipse.smarthome.automation.dto.ModuleDTOMapper;
import org.eclipse.smarthome.automation.dto.TriggerDTO;
import org.eclipse.smarthome.config.core.Configuration;

public class TriggerDTOMapper
extends ModuleDTOMapper {
    public static TriggerDTO map(Trigger trigger) {
        TriggerDTO triggerDto = new TriggerDTO();
        TriggerDTOMapper.fillProperties(trigger, triggerDto);
        return triggerDto;
    }

    public static Trigger mapDto(TriggerDTO triggerDto) {
        Trigger trigger = new Trigger(triggerDto.id, triggerDto.type, new Configuration(triggerDto.configuration));
        trigger.setLabel(triggerDto.label);
        trigger.setDescription(triggerDto.description);
        return trigger;
    }

    public static List<TriggerDTO> map(Collection<Trigger> triggers) {
        if (triggers == null) {
            return null;
        }
        ArrayList<TriggerDTO> dtos = new ArrayList<TriggerDTO>(triggers.size());
        for (Trigger trigger : triggers) {
            dtos.add(TriggerDTOMapper.map(trigger));
        }
        return dtos;
    }

    public static List<Trigger> mapDto(Collection<TriggerDTO> dtos) {
        if (dtos == null) {
            return null;
        }
        ArrayList<Trigger> triggers = new ArrayList<Trigger>(dtos.size());
        for (TriggerDTO dto : dtos) {
            triggers.add(TriggerDTOMapper.mapDto(dto));
        }
        return triggers;
    }
}

