/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.astro.internal.model;

import java.util.Calendar;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.eclipse.smarthome.binding.astro.internal.util.DateTimeUtils;

public class Range {
    private Calendar start;
    private Calendar end;

    public Range() {
    }

    public Range(Calendar start, Calendar end) {
        this.start = start;
        this.end = end;
    }

    public Calendar getStart() {
        return this.start;
    }

    public Calendar getEnd() {
        return this.end;
    }

    public long getDuration() {
        if (this.start == null || this.end == null) {
            return -1L;
        }
        if (this.start.after(this.end)) {
            return 0L;
        }
        long diff = this.end.getTimeInMillis() - this.start.getTimeInMillis();
        return diff / 60000L;
    }

    public boolean matches(Calendar cal) {
        long matchEnd;
        if (this.start == null && this.end == null) {
            return false;
        }
        long matchStart = this.start != null ? this.start.getTimeInMillis() : DateTimeUtils.truncateToMidnight(cal).getTimeInMillis();
        long l = matchEnd = this.end != null ? this.end.getTimeInMillis() : DateTimeUtils.endOfDayDate(cal).getTimeInMillis();
        return cal.getTimeInMillis() >= matchStart && cal.getTimeInMillis() < matchEnd;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("start", (Object)DateTimeUtils.getDate(this.start)).append("end", (Object)DateTimeUtils.getDate(this.end)).toString();
    }
}

