/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.ntp.internal.discovery;

import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.eclipse.smarthome.binding.ntp.NtpBindingConstants;
import org.eclipse.smarthome.config.discovery.AbstractDiscoveryService;
import org.eclipse.smarthome.config.discovery.DiscoveryResult;
import org.eclipse.smarthome.config.discovery.DiscoveryResultBuilder;
import org.eclipse.smarthome.config.discovery.DiscoveryService;
import org.eclipse.smarthome.core.i18n.LocaleProvider;
import org.eclipse.smarthome.core.i18n.TranslationProvider;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={DiscoveryService.class}, immediate=true, configurationPid="discovery.ntp")
public class NtpDiscovery
extends AbstractDiscoveryService {
    public NtpDiscovery() throws IllegalArgumentException {
        super(NtpBindingConstants.SUPPORTED_THING_TYPES_UIDS, 10);
    }

    protected void activate(Map<String, Object> configProperties) {
        super.activate(configProperties);
    }

    protected void modified(Map<String, Object> configProperties) {
        super.modified(configProperties);
    }

    protected void startBackgroundDiscovery() {
        scheduler.schedule(() -> this.discoverNtp(), 1L, TimeUnit.SECONDS);
    }

    protected void startScan() {
        this.discoverNtp();
    }

    private void discoverNtp() {
        HashMap<String, String> properties = new HashMap<String, String>(4);
        properties.put("timeZone", TimeZone.getDefault().getID());
        ThingUID uid = new ThingUID(NtpBindingConstants.THING_TYPE_NTP, "local");
        DiscoveryResult result = DiscoveryResultBuilder.create((ThingUID)uid).withProperties(properties).withLabel("Local Time").build();
        this.thingDiscovered(result);
    }

    @Reference
    protected void setLocaleProvider(LocaleProvider localeProvider) {
        this.localeProvider = localeProvider;
    }

    protected void unsetLocaleProvider(LocaleProvider localeProvider) {
        this.localeProvider = null;
    }

    @Reference
    protected void setTranslationProvider(TranslationProvider i18nProvider) {
        this.i18nProvider = i18nProvider;
    }

    protected void unsetTranslationProvider(TranslationProvider i18nProvider) {
        this.i18nProvider = null;
    }
}

