/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.model.rule.jvmmodel;

import com.google.inject.Inject;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemRegistry;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingRegistry;
import org.eclipse.smarthome.core.thing.events.ChannelTriggeredEvent;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.core.types.Type;
import org.eclipse.smarthome.model.rule.rules.ChangedEventTrigger;
import org.eclipse.smarthome.model.rule.rules.CommandEventTrigger;
import org.eclipse.smarthome.model.rule.rules.EventEmittedTrigger;
import org.eclipse.smarthome.model.rule.rules.EventTrigger;
import org.eclipse.smarthome.model.rule.rules.Rule;
import org.eclipse.smarthome.model.rule.rules.RuleModel;
import org.eclipse.smarthome.model.rule.rules.ThingStateChangedEventTrigger;
import org.eclipse.smarthome.model.rule.rules.UpdateEventTrigger;
import org.eclipse.smarthome.model.script.jvmmodel.ScriptJvmModelInferrer;
import org.eclipse.smarthome.model.script.scoping.StateAndCommandProvider;
import org.eclipse.smarthome.model.script.script.Script;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.jvmmodel.IJvmDeclaredTypeAcceptor;
import org.eclipse.xtext.xbase.jvmmodel.JvmTypesBuilder;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RulesJvmModelInferrer
extends ScriptJvmModelInferrer {
    private final Logger logger = LoggerFactory.getLogger(RulesJvmModelInferrer.class);
    public static final String VAR_TRIGGERING_ITEM = "triggeringItem";
    public static final String VAR_PREVIOUS_STATE = "previousState";
    public static final String VAR_RECEIVED_COMMAND = "receivedCommand";
    public static final String VAR_RECEIVED_EVENT = "receivedEvent";
    @Inject
    @Extension
    private JvmTypesBuilder _jvmTypesBuilder;
    @Inject
    @Extension
    private IQualifiedNameProvider _iQualifiedNameProvider;
    @Inject
    private ItemRegistry itemRegistry;
    @Inject
    private ThingRegistry thingRegistry;
    @Inject
    private StateAndCommandProvider stateAndCommandProvider;

    protected void _infer(RuleModel ruleModel, IJvmDeclaredTypeAcceptor acceptor, boolean isPreIndexingPhase) {
        String _firstUpper = StringExtensions.toFirstUpper((String)((String)IterableExtensions.head((Iterable)((Iterable)Conversions.doWrapArray((Object)ruleModel.eResource().getURI().lastSegment().split("\\."))))));
        String className = String.valueOf(_firstUpper) + "Rules";
        Procedures.Procedure1 _function = it -> {
            Collection things;
            EList _members = it.getMembers();
            Functions.Function1 _function_1 = it_1 -> {
                String _name = it_1.getName();
                JvmTypeReference _type = it_1.getType();
                JvmTypeReference _cloneWithProxies = null;
                if (_type != null) {
                    _cloneWithProxies = this._jvmTypesBuilder.cloneWithProxies(_type);
                }
                JvmField _field = this._jvmTypesBuilder.toField((EObject)it_1, _name, _cloneWithProxies);
                Procedures.Procedure1 _function_2 = field -> {
                    field.setStatic(true);
                    boolean _isWriteable = it_1.isWriteable();
                    boolean _not = !_isWriteable;
                    field.setFinal(_not);
                    this._jvmTypesBuilder.setInitializer(field, it_1.getRight());
                };
                return (JvmField)ObjectExtensions.operator_doubleArrow((Object)_field, (Procedures.Procedure1)_function_2);
            };
            List _map = ListExtensions.map(ruleModel.getVariables(), (Functions.Function1)_function_1);
            this._jvmTypesBuilder.operator_add(_members, (Iterable)_map);
            HashSet fieldNames = CollectionLiterals.newHashSet((Object[])new String[0]);
            Iterable types = this.stateAndCommandProvider.getAllTypes();
            Consumer<Type> _function_2 = type -> {
                String name = type.toString();
                boolean _add = fieldNames.add(name);
                if (_add) {
                    EList _members_1 = it.getMembers();
                    Procedures.Procedure1 _function_3 = it_1 -> it_1.setStatic(true);
                    JvmField _field = this._jvmTypesBuilder.toField((EObject)ruleModel, name, this._jvmTypesBuilder.newTypeRef((EObject)ruleModel, type.getClass(), new JvmTypeReference[0]), _function_3);
                    this._jvmTypesBuilder.operator_add(_members_1, (Object)_field);
                } else {
                    this.logger.warn("Duplicate field: '{}'. Ignoring '{}'.", (Object)name, (Object)type.getClass().getName());
                }
            };
            types.forEach(_function_2);
            Collection _items = null;
            if (this.itemRegistry != null) {
                _items = this.itemRegistry.getItems();
            }
            if (_items != null) {
                Consumer<Item> _function_3 = item -> {
                    String name = item.getName();
                    boolean _add = fieldNames.add(name);
                    if (_add) {
                        EList _members_1 = it.getMembers();
                        Procedures.Procedure1 _function_4 = it_1 -> it_1.setStatic(true);
                        JvmField _field = this._jvmTypesBuilder.toField((EObject)ruleModel, item.getName(), this._jvmTypesBuilder.newTypeRef((EObject)ruleModel, item.getClass(), new JvmTypeReference[0]), _function_4);
                        this._jvmTypesBuilder.operator_add(_members_1, (Object)_field);
                    } else {
                        this.logger.warn("Duplicate field: '{}'. Ignoring '{}'.", (Object)item.getName(), (Object)item.getClass().getName());
                    }
                };
                _items.forEach(_function_3);
            }
            Collection _all = null;
            if (this.thingRegistry != null) {
                _all = this.thingRegistry.getAll();
            }
            if ((things = _all) != null) {
                Consumer<Thing> _function_4 = thing -> {
                    String name = thing.getUID().toString();
                    boolean _add = fieldNames.add(name);
                    if (_add) {
                        EList _members_1 = it.getMembers();
                        Procedures.Procedure1 _function_5 = it_1 -> it_1.setStatic(true);
                        JvmField _field = this._jvmTypesBuilder.toField((EObject)ruleModel, name, this._jvmTypesBuilder.newTypeRef((EObject)ruleModel, thing.getClass(), new JvmTypeReference[0]), _function_5);
                        this._jvmTypesBuilder.operator_add(_members_1, (Object)_field);
                    } else {
                        this.logger.warn("Duplicate field: '{}'. Ignoring '{}'.", (Object)name, (Object)thing.getClass().getName());
                    }
                };
                things.forEach(_function_4);
            }
            EList _members_1 = it.getMembers();
            Functions.Function1 _function_5 = rule -> {
                String _name = rule.getName();
                String _plus = "_" + _name;
                Procedures.Procedure1 _function_6 = it_1 -> {
                    boolean _containsThingStateChangedEventTrigger;
                    boolean _containsEventTrigger;
                    boolean _containsStateChangeTrigger;
                    boolean _containsCommandTrigger;
                    it_1.setStatic(true);
                    if (this.containsCommandTrigger((Rule)rule) || this.containsStateChangeTrigger((Rule)rule) || this.containsStateUpdateTrigger((Rule)rule)) {
                        JvmTypeReference itemTypeRef = this._jvmTypesBuilder.newTypeRef((EObject)ruleModel, Item.class, new JvmTypeReference[0]);
                        EList _parameters = it_1.getParameters();
                        JvmFormalParameter _parameter = this._jvmTypesBuilder.toParameter((EObject)rule, VAR_TRIGGERING_ITEM, itemTypeRef);
                        this._jvmTypesBuilder.operator_add(_parameters, (Object)_parameter);
                    }
                    if (_containsCommandTrigger = this.containsCommandTrigger((Rule)rule)) {
                        JvmTypeReference commandTypeRef = this._jvmTypesBuilder.newTypeRef((EObject)ruleModel, Command.class, new JvmTypeReference[0]);
                        EList _parameters_1 = it_1.getParameters();
                        JvmFormalParameter _parameter_1 = this._jvmTypesBuilder.toParameter((EObject)rule, VAR_RECEIVED_COMMAND, commandTypeRef);
                        this._jvmTypesBuilder.operator_add(_parameters_1, (Object)_parameter_1);
                    }
                    if (_containsStateChangeTrigger = this.containsStateChangeTrigger((Rule)rule)) {
                        JvmTypeReference stateTypeRef = this._jvmTypesBuilder.newTypeRef((EObject)ruleModel, State.class, new JvmTypeReference[0]);
                        EList _parameters_2 = it_1.getParameters();
                        JvmFormalParameter _parameter_2 = this._jvmTypesBuilder.toParameter((EObject)rule, VAR_PREVIOUS_STATE, stateTypeRef);
                        this._jvmTypesBuilder.operator_add(_parameters_2, (Object)_parameter_2);
                    }
                    if (_containsEventTrigger = this.containsEventTrigger((Rule)rule)) {
                        JvmTypeReference eventTypeRef = this._jvmTypesBuilder.newTypeRef((EObject)ruleModel, ChannelTriggeredEvent.class, new JvmTypeReference[0]);
                        EList _parameters_3 = it_1.getParameters();
                        JvmFormalParameter _parameter_3 = this._jvmTypesBuilder.toParameter((EObject)rule, VAR_RECEIVED_EVENT, eventTypeRef);
                        this._jvmTypesBuilder.operator_add(_parameters_3, (Object)_parameter_3);
                    }
                    if (_containsThingStateChangedEventTrigger = this.containsThingStateChangedEventTrigger((Rule)rule)) {
                        JvmTypeReference stateTypeRef_1 = this._jvmTypesBuilder.newTypeRef((EObject)ruleModel, State.class, new JvmTypeReference[0]);
                        EList _parameters_4 = it_1.getParameters();
                        JvmFormalParameter _parameter_4 = this._jvmTypesBuilder.toParameter((EObject)rule, VAR_PREVIOUS_STATE, stateTypeRef_1);
                        this._jvmTypesBuilder.operator_add(_parameters_4, (Object)_parameter_4);
                    }
                    this._jvmTypesBuilder.setBody((JvmExecutable)it_1, (XExpression)rule.getScript());
                };
                return this._jvmTypesBuilder.toMethod((EObject)rule, _plus, this._jvmTypesBuilder.newTypeRef((EObject)ruleModel, Void.TYPE, new JvmTypeReference[0]), _function_6);
            };
            List _map_1 = ListExtensions.map(ruleModel.getRules(), (Functions.Function1)_function_5);
            this._jvmTypesBuilder.operator_add(_members_1, (Iterable)_map_1);
        };
        acceptor.accept((JvmDeclaredType)this._jvmTypesBuilder.toClass((EObject)ruleModel, className)).initializeLater(_function);
    }

    private boolean containsCommandTrigger(Rule rule) {
        EList<EventTrigger> _eventtrigger = rule.getEventtrigger();
        for (EventTrigger trigger : _eventtrigger) {
            if (!(trigger instanceof CommandEventTrigger)) continue;
            return true;
        }
        return false;
    }

    private boolean containsStateChangeTrigger(Rule rule) {
        EList<EventTrigger> _eventtrigger = rule.getEventtrigger();
        for (EventTrigger trigger : _eventtrigger) {
            if (!(trigger instanceof ChangedEventTrigger)) continue;
            return true;
        }
        return false;
    }

    private boolean containsStateUpdateTrigger(Rule rule) {
        EList<EventTrigger> _eventtrigger = rule.getEventtrigger();
        for (EventTrigger trigger : _eventtrigger) {
            if (!(trigger instanceof UpdateEventTrigger)) continue;
            return true;
        }
        return false;
    }

    private boolean containsEventTrigger(Rule rule) {
        EList<EventTrigger> _eventtrigger = rule.getEventtrigger();
        for (EventTrigger trigger : _eventtrigger) {
            if (!(trigger instanceof EventEmittedTrigger)) continue;
            return true;
        }
        return false;
    }

    private boolean containsThingStateChangedEventTrigger(Rule rule) {
        EList<EventTrigger> _eventtrigger = rule.getEventtrigger();
        for (EventTrigger trigger : _eventtrigger) {
            if (!(trigger instanceof ThingStateChangedEventTrigger)) continue;
            return true;
        }
        return false;
    }

    public void infer(EObject ruleModel, IJvmDeclaredTypeAcceptor acceptor, boolean isPreIndexingPhase) {
        if (ruleModel instanceof Script) {
            this._infer((Script)ruleModel, acceptor, isPreIndexingPhase);
            return;
        }
        if (ruleModel instanceof RuleModel) {
            this._infer((RuleModel)ruleModel, acceptor, isPreIndexingPhase);
            return;
        }
        if (ruleModel != null) {
            this._infer(ruleModel, acceptor, isPreIndexingPhase);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(ruleModel, acceptor, isPreIndexingPhase).toString());
    }
}

