/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.ui.internal.proxy;

import java.io.IOException;
import java.net.URI;
import java.util.Hashtable;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.util.B64Code;
import org.eclipse.smarthome.core.library.types.StringType;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.model.core.ModelRepository;
import org.eclipse.smarthome.model.sitemap.Image;
import org.eclipse.smarthome.model.sitemap.Sitemap;
import org.eclipse.smarthome.model.sitemap.Video;
import org.eclipse.smarthome.model.sitemap.Widget;
import org.eclipse.smarthome.ui.internal.proxy.AsyncProxyServlet;
import org.eclipse.smarthome.ui.internal.proxy.BlockingProxyServlet;
import org.eclipse.smarthome.ui.items.ItemUIRegistry;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyServletService
extends HttpServlet {
    public static final String PROXY_ALIAS = "proxy";
    private static final String CONFIG_MAX_THREADS = "maxThreads";
    private static final int DEFAULT_MAX_THREADS = 8;
    public static final String ATTR_URI = String.valueOf(ProxyServletService.class.getName()) + ".URI";
    public static final String ATTR_SERVLET_EXCEPTION = String.valueOf(ProxyServletService.class.getName()) + ".ProxyServletException";
    private final Logger logger = LoggerFactory.getLogger(ProxyServletService.class);
    private static final long serialVersionUID = -4716754591953017793L;
    private Servlet impl;
    protected HttpService httpService;
    protected ItemUIRegistry itemUIRegistry;
    protected ModelRepository modelRepository;

    protected void setItemUIRegistry(ItemUIRegistry itemUIRegistry) {
        this.itemUIRegistry = itemUIRegistry;
    }

    protected void unsetItemUIRegistry(ItemUIRegistry itemUIRegistry) {
        this.itemUIRegistry = null;
    }

    protected void setModelRepository(ModelRepository modelRepository) {
        this.modelRepository = modelRepository;
    }

    protected void unsetModelRepository(ModelRepository modelRepository) {
        this.modelRepository = null;
    }

    protected void setHttpService(HttpService httpService) {
        this.httpService = httpService;
    }

    protected void unsetHttpService(HttpService httpService) {
        this.httpService = null;
    }

    private Servlet getImpl() {
        if (this.impl == null) {
            try {
                ServletRequest.class.getMethod("startAsync", new Class[0]);
                this.impl = new AsyncProxyServlet(this);
            }
            catch (Throwable t) {
                this.impl = new BlockingProxyServlet(this);
            }
        }
        return this.impl;
    }

    private Hashtable<String, String> propsFromConfig(Map<String, Object> config) {
        Hashtable<String, String> props = new Hashtable<String, String>();
        if (config != null) {
            for (String key : config.keySet()) {
                props.put(key, config.get(key).toString());
            }
        }
        if (props.get(CONFIG_MAX_THREADS) == null) {
            props.put(CONFIG_MAX_THREADS, String.valueOf(Math.max(8, Runtime.getRuntime().availableProcessors())));
        }
        return props;
    }

    protected void activate(Map<String, Object> config) {
        try {
            Servlet servlet = this.getImpl();
            this.logger.debug("Starting up '{}' servlet  at /{}", (Object)servlet.getServletInfo(), (Object)PROXY_ALIAS);
            Hashtable<String, String> props = this.propsFromConfig(config);
            this.httpService.registerServlet("/proxy", servlet, props, this.createHttpContext());
        }
        catch (ServletException | NamespaceException e) {
            this.logger.error("Error during servlet startup: {}", (Object)e.getMessage());
        }
    }

    protected void deactivate() {
        try {
            this.httpService.unregister("/proxy");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    protected HttpContext createHttpContext() {
        return this.httpService.createDefaultHttpContext();
    }

    URI uriFromRequest(HttpServletRequest request) {
        State state;
        URI uri;
        block17: {
            try {
                uri = (URI)request.getAttribute(ATTR_URI);
                if (uri != null) {
                    return uri;
                }
                ProxyServletException pse = (ProxyServletException)request.getAttribute(ATTR_SERVLET_EXCEPTION);
                if (pse == null) break block17;
                return null;
            }
            catch (ProxyServletException pse) {
                request.setAttribute(ATTR_SERVLET_EXCEPTION, (Object)pse);
                return null;
            }
        }
        String sitemapName = request.getParameter("sitemap");
        if (sitemapName == null) {
            throw new ProxyServletException(400, "Parameter 'sitemap' must be provided!");
        }
        String widgetId = request.getParameter("widgetId");
        if (widgetId == null) {
            throw new ProxyServletException(400, "Parameter 'widgetId' must be provided!");
        }
        Sitemap sitemap = (Sitemap)this.modelRepository.getModel(sitemapName);
        if (sitemap == null) {
            throw new ProxyServletException(404, String.format("Sitemap '%s' could not be found!", sitemapName));
        }
        Widget widget = this.itemUIRegistry.getWidget(sitemap, widgetId);
        if (widget == null) {
            throw new ProxyServletException(404, String.format("Widget '%s' could not be found!", widgetId));
        }
        String uriString = null;
        if (widget instanceof Image) {
            uriString = ((Image)widget).getUrl();
        } else if (widget instanceof Video) {
            uriString = ((Video)widget).getUrl();
        } else {
            throw new ProxyServletException(403, String.format("Widget type '%s' is not supported!", widget.getClass().getName()));
        }
        String itemName = widget.getItem();
        if (itemName != null && (state = this.itemUIRegistry.getItemState(itemName)) != null && state instanceof StringType) {
            try {
                uri = URI.create(state.toString());
                request.setAttribute(ATTR_URI, (Object)uri);
                return uri;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        try {
            uri = URI.create(uriString);
            request.setAttribute(ATTR_URI, (Object)uri);
            return uri;
        }
        catch (IllegalArgumentException iae) {
            throw new ProxyServletException(500, String.format("URI '%s' is not a valid URI.", uriString));
        }
    }

    void maybeAppendAuthHeader(URI uri, Request request) {
        String[] userInfo;
        if (uri != null && uri.getUserInfo() != null && (userInfo = uri.getUserInfo().split(":")).length >= 1) {
            String user = userInfo[0];
            String password = userInfo.length >= 2 ? userInfo[1] : null;
            String authString = password != null ? String.valueOf(user) + ":" + password : String.valueOf(user) + ":";
            String basicAuthentication = "Basic " + B64Code.encode((String)authString, (String)"iso-8859-1");
            request.header(HttpHeader.AUTHORIZATION, basicAuthentication);
        }
    }

    void sendError(HttpServletRequest request, HttpServletResponse response) {
        ProxyServletException pse = (ProxyServletException)request.getAttribute(ATTR_SERVLET_EXCEPTION);
        if (pse != null) {
            try {
                response.sendError(pse.getCode(), pse.getMessage());
            }
            catch (IOException ioe) {
                response.setStatus(pse.getCode());
            }
        } else {
            response.setStatus(403);
        }
    }

    static class ProxyServletException
    extends Exception {
        static final long serialVersionUID = -1L;
        private final int code;

        public ProxyServletException(int code, String message) {
            super(message);
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }
    }
}

