/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.type;

import java.util.Collections;
import java.util.Set;

public class Output {
    private String name;
    private String type;
    private Set<String> tags;
    private String label;
    private String description;
    private String reference;
    private String defaultValue;

    protected Output() {
    }

    public Output(String name, String type) {
        this(name, type, null, null, null, null, null);
    }

    public Output(String name, String type, String label, String description, Set<String> tags, String reference, String defaultValue) {
        if (name == null) {
            throw new IllegalArgumentException("The name of the output must not be NULL!");
        }
        if (type == null) {
            throw new IllegalArgumentException("The type of the output must not be NULL!");
        }
        this.name = name;
        this.type = type;
        this.label = label;
        this.description = description;
        this.tags = tags;
        this.reference = reference;
        this.defaultValue = defaultValue;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public String getReference() {
        return this.reference;
    }

    public Set<String> getTags() {
        return this.tags != null ? this.tags : Collections.emptySet();
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String toString() {
        return "Output " + this.name;
    }
}

