/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.parser.gson.internal;

import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.smarthome.automation.core.dto.RuleTemplateDTOMapper;
import org.eclipse.smarthome.automation.dto.RuleTemplateDTO;
import org.eclipse.smarthome.automation.parser.Parser;
import org.eclipse.smarthome.automation.parser.ParsingException;
import org.eclipse.smarthome.automation.parser.ParsingNestedException;
import org.eclipse.smarthome.automation.parser.gson.internal.AbstractGSONParser;
import org.eclipse.smarthome.automation.template.Template;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={Parser.class}, property={"parser.type=parser.template", "format=json"})
public class TemplateGSONParser
extends AbstractGSONParser<Template> {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Set<Template> parse(InputStreamReader reader) throws ParsingException {
        JsonReader jr;
        block13: {
            HashSet<Template> hashSet;
            jr = new JsonReader((Reader)reader);
            try {
                if (!jr.hasNext()) break block13;
                JsonToken token = jr.peek();
                HashSet<Template> templates = new HashSet<Template>();
                if (JsonToken.BEGIN_ARRAY.equals((Object)token)) {
                    List templateDtos = (List)gson.fromJson(jr, new TypeToken<List<RuleTemplateDTO>>(){}.getType());
                    for (RuleTemplateDTO templateDto : templateDtos) {
                        templates.add((Template)RuleTemplateDTOMapper.map((RuleTemplateDTO)templateDto));
                    }
                } else {
                    RuleTemplateDTO template = (RuleTemplateDTO)gson.fromJson(jr, RuleTemplateDTO.class);
                    templates.add((Template)RuleTemplateDTOMapper.map((RuleTemplateDTO)template));
                }
                hashSet = templates;
            }
            catch (Exception e) {
                try {
                    throw new ParsingException(new ParsingNestedException(2, null, (Throwable)e));
                }
                catch (Throwable throwable) {
                    try {
                        jr.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
            }
            try {
                jr.close();
                return hashSet;
            }
            catch (IOException iOException) {}
            return hashSet;
        }
        try {
            jr.close();
            return Collections.emptySet();
        }
        catch (IOException iOException) {}
        return Collections.emptySet();
    }
}

