/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.astro.internal.job;

import org.eclipse.smarthome.binding.astro.handler.AstroThingHandler;
import org.eclipse.smarthome.binding.astro.internal.job.AbstractJob;
import org.eclipse.smarthome.binding.astro.internal.job.Job;
import org.eclipse.smarthome.binding.astro.internal.model.Eclipse;
import org.eclipse.smarthome.binding.astro.internal.model.Moon;
import org.eclipse.smarthome.binding.astro.internal.model.MoonPhase;
import org.eclipse.smarthome.binding.astro.internal.model.Planet;

public final class DailyJobMoon
extends AbstractJob {
    private final AstroThingHandler handler;

    public DailyJobMoon(String thingUID, AstroThingHandler handler) {
        super(thingUID);
        DailyJobMoon.checkArgument(handler != null, "The handler must not be null");
        this.handler = handler;
    }

    @Override
    public void run() {
        this.handler.publishDailyInfo();
        String thingUID = this.getThingUID();
        LOGGER.info("Scheduled Astro event-jobs for thing {}", (Object)thingUID);
        Planet planet = this.handler.getPlanet();
        if (planet == null) {
            LOGGER.error("Planet not instantiated");
            return;
        }
        Moon moon = (Moon)planet;
        Job.scheduleEvent(thingUID, this.handler, moon.getRise().getStart(), "START", "rise#event", false);
        Job.scheduleEvent(thingUID, this.handler, moon.getSet().getEnd(), "END", "set#event", false);
        MoonPhase moonPhase = moon.getPhase();
        Job.scheduleEvent(thingUID, this.handler, moonPhase.getFirstQuarter(), "FIRST_QUARTER", "phase#event", false);
        Job.scheduleEvent(thingUID, this.handler, moonPhase.getThirdQuarter(), "THIRD_QUARTER", "phase#event", false);
        Job.scheduleEvent(thingUID, this.handler, moonPhase.getFull(), "FULL", "phase#event", false);
        Job.scheduleEvent(thingUID, this.handler, moonPhase.getNew(), "NEW", "phase#event", false);
        Eclipse eclipse = moon.getEclipse();
        Job.scheduleEvent(thingUID, this.handler, eclipse.getPartial(), "PARTIAL", "eclipse#event", false);
        Job.scheduleEvent(thingUID, this.handler, eclipse.getTotal(), "TOTAL", "eclipse#event", false);
        Job.scheduleEvent(thingUID, this.handler, moon.getPerigee().getDate(), "PERIGEE", "perigee#event", false);
        Job.scheduleEvent(thingUID, this.handler, moon.getApogee().getDate(), "APOGEE", "apogee#event", false);
    }

    public String toString() {
        return "Daily job moon " + this.getThingUID();
    }
}

