/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.astro.internal.util;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;
import org.eclipse.smarthome.binding.astro.internal.config.AstroChannelConfig;
import org.eclipse.smarthome.binding.astro.internal.util.DateTimeUtils;
import org.eclipse.smarthome.core.i18n.TimeZoneProvider;
import org.eclipse.smarthome.core.library.types.DateTimeType;
import org.eclipse.smarthome.core.library.types.DecimalType;
import org.eclipse.smarthome.core.library.types.StringType;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.core.types.UnDefType;

public class PropertyUtils {
    private static TimeZoneProvider timeZoneProvider;

    private PropertyUtils() {
        throw new IllegalAccessError("Non-instantiable");
    }

    public static State getState(ChannelUID channelUID, AstroChannelConfig config, Object instance) throws Exception {
        Object value = PropertyUtils.getPropertyValue(channelUID, instance);
        if (value == null) {
            return UnDefType.UNDEF;
        }
        if (value instanceof State) {
            return (State)value;
        }
        if (value instanceof Calendar) {
            Calendar cal = (Calendar)value;
            GregorianCalendar gregorianCal = (GregorianCalendar)DateTimeUtils.applyConfig(cal, config);
            cal.setTimeZone(TimeZone.getTimeZone(timeZoneProvider.getTimeZone()));
            ZonedDateTime zoned = gregorianCal.toZonedDateTime().withFixedOffsetZone();
            return new DateTimeType(zoned);
        }
        if (value instanceof Number) {
            BigDecimal decimalValue = new BigDecimal(value.toString()).setScale(2, RoundingMode.HALF_UP);
            return new DecimalType(decimalValue);
        }
        if (value instanceof String || value instanceof Enum) {
            return new StringType(value.toString());
        }
        throw new IllegalStateException("Unsupported value type " + value.getClass().getSimpleName());
    }

    public static void setTimeZone(TimeZoneProvider zone) {
        timeZoneProvider = zone;
    }

    public static void unsetTimeZone() {
        timeZoneProvider = null;
    }

    public static Object getPropertyValue(ChannelUID channelUID, Object instance) throws Exception {
        String[] properties = StringUtils.split((String)channelUID.getId(), (String)"#");
        return PropertyUtils.getPropertyValue(instance, properties, 0);
    }

    private static Object getPropertyValue(Object instance, String[] properties, int nestedIndex) throws Exception {
        String propertyName = properties[nestedIndex];
        Method m = instance.getClass().getMethod(PropertyUtils.toGetterString(propertyName), null);
        Object result = m.invoke(instance, null);
        if (nestedIndex + 1 < properties.length) {
            return PropertyUtils.getPropertyValue(result, properties, nestedIndex + 1);
        }
        return result;
    }

    private static String toGetterString(String str) {
        StringBuilder sb = new StringBuilder();
        sb.append("get");
        sb.append(Character.toTitleCase(str.charAt(0)));
        sb.append(str.substring(1));
        return sb.toString();
    }
}

