/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.bluetooth;

public class BluetoothAddress {
    public static final int BD_ADDRESS_LENGTH = 17;
    private final String address;

    public BluetoothAddress(String address) {
        if (address == null || address.length() != 17) {
            throw new IllegalArgumentException("BT Address cannot be null and must be in format XX:XX:XX:XX:XX:XX");
        }
        int i = 0;
        while (i < 17) {
            char c = address.charAt(i);
            switch (i % 3) {
                case 0: 
                case 1: {
                    if (c >= '0' && c <= '9' || c >= 'A' && c <= 'F') break;
                    throw new IllegalArgumentException("BT Address must contain upper case hex values only");
                }
                case 2: {
                    if (c == ':') break;
                    throw new IllegalArgumentException("BT Address bytes must be separated with colon");
                }
            }
            ++i;
        }
        this.address = address;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.address == null ? 0 : this.address.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BluetoothAddress other = (BluetoothAddress)obj;
        return !(this.address == null ? other.address != null : !this.address.equals(other.address));
    }

    public String toString() {
        return this.address;
    }
}

