/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.bosesoundtouch.internal;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.smarthome.binding.bosesoundtouch.handler.BoseSoundTouchHandler;
import org.eclipse.smarthome.binding.bosesoundtouch.internal.APIRequest;
import org.eclipse.smarthome.binding.bosesoundtouch.internal.AvailableSources;
import org.eclipse.smarthome.binding.bosesoundtouch.internal.BoseSoundTouchNotificationChannelConfiguration;
import org.eclipse.smarthome.binding.bosesoundtouch.internal.ContentItem;
import org.eclipse.smarthome.binding.bosesoundtouch.internal.ContentItemMaker;
import org.eclipse.smarthome.binding.bosesoundtouch.internal.ContentItemNotPresetableException;
import org.eclipse.smarthome.binding.bosesoundtouch.internal.NoInternetRadioPresetFoundException;
import org.eclipse.smarthome.binding.bosesoundtouch.internal.NoPresetFoundException;
import org.eclipse.smarthome.binding.bosesoundtouch.internal.NoStoredMusicPresetFoundException;
import org.eclipse.smarthome.binding.bosesoundtouch.internal.OperationModeNotAvailableException;
import org.eclipse.smarthome.binding.bosesoundtouch.internal.OperationModeType;
import org.eclipse.smarthome.binding.bosesoundtouch.internal.RemoteKeyType;
import org.eclipse.smarthome.core.library.types.DecimalType;
import org.eclipse.smarthome.core.library.types.NextPreviousType;
import org.eclipse.smarthome.core.library.types.OnOffType;
import org.eclipse.smarthome.core.library.types.PercentType;
import org.eclipse.smarthome.core.library.types.PlayPauseType;
import org.eclipse.smarthome.core.library.types.StringType;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.State;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandExecutor
implements AvailableSources {
    private final Logger logger = LoggerFactory.getLogger(CommandExecutor.class);
    private final BoseSoundTouchHandler handler;
    private boolean currentMuted;
    private ContentItem currentContentItem;
    private OperationModeType currentOperationMode;
    private Map<String, Boolean> mapOfAvailableFunctions;

    public CommandExecutor(BoseSoundTouchHandler handler) {
        this.handler = handler;
        this.init();
    }

    public void updatePresetContainerFromPlayer(Map<Integer, ContentItem> playerPresets) {
        playerPresets.forEach((k, v) -> {
            try {
                if (v != null) {
                    this.handler.getPresetContainer().put((int)k, (ContentItem)v);
                } else {
                    this.handler.getPresetContainer().remove((int)k);
                }
            }
            catch (ContentItemNotPresetableException contentItemNotPresetableException) {
                this.logger.debug("{}: ContentItem is not presetable", (Object)this.handler.getDeviceName());
            }
        });
        this.handler.refreshPresetChannel();
    }

    public void addContentItemToPresetContainer(int id, ContentItem contentItem) {
        contentItem.setPresetID(id);
        try {
            this.handler.getPresetContainer().put(id, contentItem);
        }
        catch (ContentItemNotPresetableException contentItemNotPresetableException) {
            this.logger.debug("{}: ContentItem is not presetable", (Object)this.handler.getDeviceName());
        }
        this.handler.refreshPresetChannel();
    }

    public void addCurrentContentItemToPresetContainer(DecimalType command) {
        if (command.intValue() > 6) {
            this.addContentItemToPresetContainer(command.intValue(), this.currentContentItem);
        } else {
            this.logger.warn("{}: Only PresetID >6 is allowed", (Object)this.handler.getDeviceName());
        }
    }

    public void getInformations(APIRequest apiRequest) {
        String msg = "<msg><header deviceID=\"" + this.handler.getMacAddress() + "\"" + " url=\"" + (Object)((Object)apiRequest) + "\" method=\"GET\"><request requestID=\"0\"><info type=\"new\"/></request></header></msg>";
        try {
            this.handler.getSession().getRemote().sendString(msg);
            this.logger.debug("{}: sending request: {}", (Object)this.handler.getDeviceName(), (Object)msg);
        }
        catch (IOException e) {
            this.handler.onWebSocketError(e);
        }
    }

    public void setCurrentContentItem(ContentItem contentItem) {
        if (contentItem != null && contentItem.isValid()) {
            ContentItem psFound = null;
            if (this.handler.getPresetContainer() != null) {
                Collection<ContentItem> listOfPresets = this.handler.getPresetContainer().getAllPresets();
                for (ContentItem ps : listOfPresets) {
                    if (!ps.isPresetable() || !ps.getLocation().equals(contentItem.getLocation())) continue;
                    psFound = ps;
                }
                int presetID = 0;
                if (psFound != null) {
                    presetID = psFound.getPresetID();
                }
                contentItem.setPresetID(presetID);
                this.currentContentItem = contentItem;
            }
        }
        this.updateOperatingValues();
    }

    public void setCurrentMuted(boolean muted) {
        this.currentMuted = muted;
    }

    public void postBass(DecimalType command) {
        if (this.isBassAvailable()) {
            this.sendPostRequestInWebSocket("bass", "<bass deviceID=\"" + this.handler.getMacAddress() + "\"" + ">" + command.intValue() + "</bass>");
        } else {
            this.logger.warn("{}: Bass modification not supported for this device", (Object)this.handler.getDeviceName());
        }
    }

    public void postOperationMode(OperationModeType command) {
        if (command == OperationModeType.STANDBY) {
            this.postPower(OnOffType.OFF);
        } else {
            try {
                ContentItemMaker contentItemMaker = new ContentItemMaker(this, this.handler.getPresetContainer());
                ContentItem contentItem = contentItemMaker.getContentItem(command);
                this.postContentItem(contentItem);
            }
            catch (OperationModeNotAvailableException operationModeNotAvailableException) {
                this.logger.warn("{}: OperationMode \"{}\" is not supported yet", (Object)this.handler.getDeviceName(), (Object)command.toString());
            }
            catch (NoInternetRadioPresetFoundException noInternetRadioPresetFoundException) {
                this.logger.warn("{}: Unable to switch to mode \"INTERNET_RADIO\". No PRESET defined", (Object)this.handler.getDeviceName());
            }
            catch (NoStoredMusicPresetFoundException noStoredMusicPresetFoundException) {
                this.logger.warn("{}: Unable to switch to mode: \"STORED_MUSIC\". No PRESET defined", (Object)this.handler.getDeviceName());
            }
            this.updateOperatingValues();
        }
    }

    public void postPlayerControl(Command command) {
        if (command.equals(PlayPauseType.PLAY)) {
            if (this.currentOperationMode == OperationModeType.STANDBY) {
                this.postRemoteKey(RemoteKeyType.POWER);
            } else {
                this.postRemoteKey(RemoteKeyType.PLAY);
            }
        } else if (command.equals(PlayPauseType.PAUSE)) {
            this.postRemoteKey(RemoteKeyType.PAUSE);
        } else if (command.equals(NextPreviousType.NEXT)) {
            this.postRemoteKey(RemoteKeyType.NEXT_TRACK);
        } else if (command.equals(NextPreviousType.PREVIOUS)) {
            this.postRemoteKey(RemoteKeyType.PREV_TRACK);
        }
    }

    public void postPower(OnOffType command) {
        if (command.equals((Object)OnOffType.ON)) {
            if (this.currentOperationMode == OperationModeType.STANDBY) {
                this.postRemoteKey(RemoteKeyType.POWER);
            }
        } else if (command.equals((Object)OnOffType.OFF) && this.currentOperationMode != OperationModeType.STANDBY) {
            this.postRemoteKey(RemoteKeyType.POWER);
        }
        this.updateOperatingValues();
    }

    public void postPreset(DecimalType command) {
        ContentItem item = null;
        try {
            item = this.handler.getPresetContainer().get(command.intValue());
            this.postContentItem(item);
        }
        catch (NoPresetFoundException noPresetFoundException) {
            this.logger.warn("{}: No preset found at id: {}", (Object)this.handler.getDeviceName(), (Object)command.intValue());
        }
    }

    public void postRemoteKey(RemoteKeyType key) {
        this.sendPostRequestInWebSocket("key", "mainNode=\"keyPress\"", "<key state=\"press\" sender=\"Gabbo\">" + key.name() + "</key>");
        this.sendPostRequestInWebSocket("key", "mainNode=\"keyRelease\"", "<key state=\"release\" sender=\"Gabbo\">" + key.name() + "</key>");
    }

    public void postVolume(PercentType command) {
        this.sendPostRequestInWebSocket("volume", "<volume deviceID=\"" + this.handler.getMacAddress() + "\"" + ">" + command.intValue() + "</volume>");
    }

    public void postVolumeMuted(OnOffType command) {
        if (command.equals((Object)OnOffType.ON)) {
            if (!this.currentMuted) {
                this.currentMuted = true;
                this.postRemoteKey(RemoteKeyType.MUTE);
            }
        } else if (command.equals((Object)OnOffType.OFF) && this.currentMuted) {
            this.currentMuted = false;
            this.postRemoteKey(RemoteKeyType.MUTE);
        }
    }

    public void updateBassLevelGUIState(DecimalType state) {
        this.handler.updateState("bass", (State)state);
    }

    public void updateVolumeGUIState(PercentType state) {
        this.handler.updateState("volume", (State)state);
    }

    public void updateOperationModeGUIState(StringType state) {
        this.handler.updateState("operationMode", (State)state);
    }

    public void updatePlayerControlGUIState(State state) {
        this.handler.updateState("playerControl", state);
    }

    public void updatePowerStateGUIState(OnOffType state) {
        this.handler.updateState("power", (State)state);
    }

    public void updatePresetGUIState(DecimalType state) {
        this.handler.updateState("preset", (State)state);
    }

    private void init() {
        this.getInformations(APIRequest.INFO);
        this.currentOperationMode = OperationModeType.OFFLINE;
        this.currentContentItem = null;
        this.mapOfAvailableFunctions = new HashMap<String, Boolean>();
    }

    private void postContentItem(ContentItem contentItem) {
        if (contentItem != null) {
            this.setCurrentContentItem(contentItem);
            this.sendPostRequestInWebSocket("select", "", contentItem.generateXML());
        }
    }

    private void sendPostRequestInWebSocket(String url, String postData) {
        this.sendPostRequestInWebSocket(url, "", postData);
    }

    private void sendPostRequestInWebSocket(String url, String infoAddon, String postData) {
        int id = 0;
        String msg = "<msg><header deviceID=\"" + this.handler.getMacAddress() + "\"" + " url=\"" + url + "\" method=\"POST\"><request requestID=\"" + id + "\"><info " + infoAddon + " type=\"new\"/></request></header><body>" + postData + "</body></msg>";
        try {
            this.handler.getSession().getRemote().sendString(msg);
            this.logger.debug("{}: sending request: {}", (Object)this.handler.getDeviceName(), (Object)msg);
        }
        catch (IOException | NullPointerException e) {
            this.handler.onWebSocketError(e);
        }
    }

    private void updateOperatingValues() {
        OperationModeType operationMode;
        if (this.currentContentItem != null) {
            this.updatePresetGUIState(new DecimalType((long)this.currentContentItem.getPresetID()));
            operationMode = this.currentContentItem.getOperationMode();
        } else {
            operationMode = OperationModeType.STANDBY;
        }
        this.updateOperationModeGUIState(new StringType(operationMode.toString()));
        this.currentOperationMode = operationMode;
        if (this.currentOperationMode == OperationModeType.STANDBY) {
            this.updatePowerStateGUIState(OnOffType.OFF);
            this.updatePlayerControlGUIState((State)PlayPauseType.PAUSE);
        } else {
            this.updatePowerStateGUIState(OnOffType.ON);
        }
    }

    @Override
    public boolean isBluetoothAvailable() {
        return this.isSourceAvailable("bluetooth");
    }

    @Override
    public boolean isAUXAvailable() {
        return this.isSourceAvailable("aux");
    }

    @Override
    public boolean isAUX1Available() {
        return this.isSourceAvailable("aux1");
    }

    @Override
    public boolean isAUX2Available() {
        return this.isSourceAvailable("aux2");
    }

    @Override
    public boolean isAUX3Available() {
        return this.isSourceAvailable("aux3");
    }

    @Override
    public boolean isTVAvailable() {
        return this.isSourceAvailable("tv");
    }

    @Override
    public boolean isHDMI1Available() {
        return this.isSourceAvailable("hdmi1");
    }

    @Override
    public boolean isInternetRadioAvailable() {
        return this.isSourceAvailable("internetRadio");
    }

    @Override
    public boolean isStoredMusicAvailable() {
        return this.isSourceAvailable("storedMusic");
    }

    @Override
    public boolean isBassAvailable() {
        return this.isSourceAvailable("bass");
    }

    @Override
    public void setBluetoothAvailable(boolean bluetooth) {
        this.mapOfAvailableFunctions.put("bluetooth", bluetooth);
    }

    @Override
    public void setAUXAvailable(boolean aux) {
        this.mapOfAvailableFunctions.put("aux", aux);
    }

    @Override
    public void setAUX1Available(boolean aux1) {
        this.mapOfAvailableFunctions.put("aux1", aux1);
    }

    @Override
    public void setAUX2Available(boolean aux2) {
        this.mapOfAvailableFunctions.put("aux2", aux2);
    }

    @Override
    public void setAUX3Available(boolean aux3) {
        this.mapOfAvailableFunctions.put("aux3", aux3);
    }

    @Override
    public void setStoredMusicAvailable(boolean storedMusic) {
        this.mapOfAvailableFunctions.put("storedMusic", storedMusic);
    }

    @Override
    public void setInternetRadioAvailable(boolean internetRadio) {
        this.mapOfAvailableFunctions.put("internetRadio", internetRadio);
    }

    @Override
    public void setTVAvailable(boolean tv) {
        this.mapOfAvailableFunctions.put("tv", tv);
    }

    @Override
    public void setHDMI1Available(boolean hdmi1) {
        this.mapOfAvailableFunctions.put("hdmi1", hdmi1);
    }

    @Override
    public void setBassAvailable(boolean bass) {
        this.mapOfAvailableFunctions.put("bass", bass);
    }

    private boolean isSourceAvailable(String source) {
        Boolean isAvailable = this.mapOfAvailableFunctions.get(source);
        if (isAvailable == null) {
            return false;
        }
        return isAvailable;
    }

    public void playNotificationSound(String appKey, BoseSoundTouchNotificationChannelConfiguration notificationConfig, String fileUrl) {
        String msg = "<play_info><app_key>" + appKey + "</app_key>" + "<url>" + fileUrl + "</url>" + "<service>" + notificationConfig.notificationService + "</service>" + (notificationConfig.notificationReason != null ? "<reason>" + notificationConfig.notificationReason + "</reason>" : "") + (notificationConfig.notificationMessage != null ? "<message>" + notificationConfig.notificationMessage + "</message>" : "") + (notificationConfig.notificationVolume != null ? "<volume>" + notificationConfig.notificationVolume + "</volume>" : "") + "</play_info>";
        this.sendPostRequestInWebSocket("speaker", msg);
    }
}

