/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.bosesoundtouch.internal;

import java.util.Collection;
import org.eclipse.smarthome.binding.bosesoundtouch.internal.CommandExecutor;
import org.eclipse.smarthome.binding.bosesoundtouch.internal.ContentItem;
import org.eclipse.smarthome.binding.bosesoundtouch.internal.NoInternetRadioPresetFoundException;
import org.eclipse.smarthome.binding.bosesoundtouch.internal.NoStoredMusicPresetFoundException;
import org.eclipse.smarthome.binding.bosesoundtouch.internal.OperationModeNotAvailableException;
import org.eclipse.smarthome.binding.bosesoundtouch.internal.OperationModeType;
import org.eclipse.smarthome.binding.bosesoundtouch.internal.PresetContainer;

public class ContentItemMaker {
    private final PresetContainer presetContainer;
    private final CommandExecutor commandExecutor;

    public ContentItemMaker(CommandExecutor commandExecutor, PresetContainer presetContainer) {
        this.commandExecutor = commandExecutor;
        this.presetContainer = presetContainer;
    }

    public ContentItem getContentItem(OperationModeType operationModeType) throws OperationModeNotAvailableException, NoInternetRadioPresetFoundException, NoStoredMusicPresetFoundException {
        switch (operationModeType) {
            case OFFLINE: 
            case STANDBY: 
            case OTHER: {
                throw new OperationModeNotAvailableException();
            }
            case AMAZON: {
                return this.getAmazon();
            }
            case AUX: {
                return this.getAUX();
            }
            case AUX1: {
                return this.getAUX1();
            }
            case AUX2: {
                return this.getAUX2();
            }
            case AUX3: {
                return this.getAUX3();
            }
            case BLUETOOTH: {
                return this.getBluetooth();
            }
            case DEEZER: {
                return this.getDeezer();
            }
            case HDMI1: {
                return this.getHDMI();
            }
            case INTERNET_RADIO: {
                return this.getInternetRadio();
            }
            case PANDORA: {
                return this.getPandora();
            }
            case SIRIUSXM: {
                return this.getSiriusxm();
            }
            case SPOTIFY: {
                return this.getSpotify();
            }
            case STORED_MUSIC: {
                return this.getStoredMusic();
            }
            case TV: {
                return this.getTV();
            }
        }
        throw new OperationModeNotAvailableException();
    }

    private ContentItem getAmazon() throws OperationModeNotAvailableException {
        throw new OperationModeNotAvailableException();
    }

    private ContentItem getAUX() throws OperationModeNotAvailableException {
        ContentItem contentItem = null;
        if (this.commandExecutor.isAUXAvailable()) {
            contentItem = new ContentItem();
            contentItem.setSource("AUX");
            contentItem.setSourceAccount("AUX");
        }
        if (contentItem != null) {
            return contentItem;
        }
        throw new OperationModeNotAvailableException();
    }

    private ContentItem getAUX1() throws OperationModeNotAvailableException {
        ContentItem contentItem = null;
        if (this.commandExecutor.isAUX1Available()) {
            contentItem = new ContentItem();
            contentItem.setSource("AUX");
            contentItem.setSourceAccount("AUX1");
        }
        if (contentItem != null) {
            return contentItem;
        }
        throw new OperationModeNotAvailableException();
    }

    private ContentItem getAUX2() throws OperationModeNotAvailableException {
        ContentItem contentItem = null;
        if (this.commandExecutor.isAUX2Available()) {
            contentItem = new ContentItem();
            contentItem.setSource("AUX");
            contentItem.setSourceAccount("AUX2");
        }
        if (contentItem != null) {
            return contentItem;
        }
        throw new OperationModeNotAvailableException();
    }

    private ContentItem getAUX3() throws OperationModeNotAvailableException {
        ContentItem contentItem = null;
        if (this.commandExecutor.isAUX3Available()) {
            contentItem = new ContentItem();
            contentItem.setSource("AUX");
            contentItem.setSourceAccount("AUX3");
        }
        if (contentItem != null) {
            return contentItem;
        }
        throw new OperationModeNotAvailableException();
    }

    private ContentItem getBluetooth() throws OperationModeNotAvailableException {
        ContentItem contentItem = null;
        if (this.commandExecutor.isBluetoothAvailable()) {
            contentItem = new ContentItem();
            contentItem.setSource("BLUETOOTH");
        }
        if (contentItem != null) {
            return contentItem;
        }
        throw new OperationModeNotAvailableException();
    }

    private ContentItem getDeezer() throws OperationModeNotAvailableException {
        throw new OperationModeNotAvailableException();
    }

    private ContentItem getHDMI() throws OperationModeNotAvailableException {
        ContentItem contentItem = null;
        if (this.commandExecutor.isHDMI1Available()) {
            contentItem = new ContentItem();
            contentItem.setSource("PRODUCT");
            contentItem.setSourceAccount("HDMI_1");
            contentItem.setPresetable(false);
        }
        if (contentItem != null) {
            return contentItem;
        }
        throw new OperationModeNotAvailableException();
    }

    private ContentItem getInternetRadio() throws NoInternetRadioPresetFoundException {
        ContentItem contentItem = null;
        if (this.commandExecutor.isInternetRadioAvailable()) {
            Collection<ContentItem> listOfPresets = this.presetContainer.getAllPresets();
            for (ContentItem iteratedItem : listOfPresets) {
                if (contentItem != null || iteratedItem.getOperationMode() != OperationModeType.INTERNET_RADIO) continue;
                contentItem = iteratedItem;
            }
        }
        if (contentItem != null) {
            return contentItem;
        }
        throw new NoInternetRadioPresetFoundException();
    }

    private ContentItem getPandora() throws OperationModeNotAvailableException {
        throw new OperationModeNotAvailableException();
    }

    private ContentItem getSiriusxm() throws OperationModeNotAvailableException {
        throw new OperationModeNotAvailableException();
    }

    private ContentItem getSpotify() throws OperationModeNotAvailableException {
        throw new OperationModeNotAvailableException();
    }

    private ContentItem getStoredMusic() throws NoStoredMusicPresetFoundException {
        ContentItem contentItem = null;
        if (this.commandExecutor.isStoredMusicAvailable()) {
            Collection<ContentItem> listOfPresets = this.presetContainer.getAllPresets();
            for (ContentItem iteratedItem : listOfPresets) {
                if (contentItem != null || iteratedItem.getOperationMode() != OperationModeType.STORED_MUSIC) continue;
                contentItem = iteratedItem;
            }
        }
        if (contentItem != null) {
            return contentItem;
        }
        throw new NoStoredMusicPresetFoundException();
    }

    private ContentItem getTV() throws OperationModeNotAvailableException {
        ContentItem contentItem = null;
        if (this.commandExecutor.isTVAvailable()) {
            contentItem = new ContentItem();
            contentItem.setSource("PRODUCT");
            contentItem.setSourceAccount("TV");
            contentItem.setPresetable(false);
        }
        if (contentItem != null) {
            return contentItem;
        }
        throw new OperationModeNotAvailableException();
    }
}

