/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.hue.internal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class HttpClient {
    private int timeout = 1000;
    private final Logger logger = LoggerFactory.getLogger(HttpClient.class);
    private final LinkedList<AsyncPutParameters> commandsQueue = new LinkedList();
    private @Nullable Future<?> job;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeCommands() {
        while (true) {
            try {
                while (true) {
                    long delayTime = 0L;
                    LinkedList<AsyncPutParameters> linkedList = this.commandsQueue;
                    synchronized (linkedList) {
                        AsyncPutParameters payloadCallbackPair = this.commandsQueue.poll();
                        if (payloadCallbackPair != null) {
                            this.logger.debug("Async sending put to address: {} delay: {} body: {}", new Object[]{payloadCallbackPair.address, payloadCallbackPair.delay, payloadCallbackPair.body});
                            try {
                                Result result = this.put(payloadCallbackPair.address, payloadCallbackPair.body);
                                payloadCallbackPair.future.complete(result);
                            }
                            catch (IOException e) {
                                payloadCallbackPair.future.completeExceptionally(e);
                            }
                        } else {
                            return;
                        }
                        delayTime = payloadCallbackPair.delay;
                    }
                    Thread.sleep(delayTime);
                }
            }
            catch (InterruptedException e) {
                this.logger.debug("commandExecutorThread was interrupted", (Throwable)e);
                continue;
            }
            break;
        }
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public Result get(String address) throws IOException {
        return this.doNetwork(address, "GET");
    }

    public Result post(String address, String body) throws IOException {
        return this.doNetwork(address, "POST", body);
    }

    public Result put(String address, String body) throws IOException {
        return this.doNetwork(address, "PUT", body);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Result> putAsync(String address, String body, long delay, ScheduledExecutorService scheduler) {
        AsyncPutParameters asyncPutParameters = new AsyncPutParameters(address, body, delay);
        LinkedList<AsyncPutParameters> linkedList = this.commandsQueue;
        synchronized (linkedList) {
            if (this.commandsQueue.isEmpty()) {
                this.commandsQueue.offer(asyncPutParameters);
                if (this.job == null || this.job.isDone()) {
                    this.job = scheduler.submit(this::executeCommands);
                }
            } else {
                this.commandsQueue.offer(asyncPutParameters);
            }
        }
        return asyncPutParameters.future;
    }

    public Result delete(String address) throws IOException {
        return this.doNetwork(address, "DELETE");
    }

    protected Result doNetwork(String address, String requestMethod) throws IOException {
        return this.doNetwork(address, requestMethod, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Result doNetwork(String address, String requestMethod, @Nullable String body) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)new URL(address).openConnection();
        try {
            Object var6_8;
            Throwable throwable;
            conn.setRequestMethod(requestMethod);
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setConnectTimeout(this.timeout);
            conn.setReadTimeout(this.timeout);
            if (body != null && !"".equals(body)) {
                conn.setDoOutput(true);
                throwable = null;
                var6_8 = null;
                try (OutputStreamWriter out = new OutputStreamWriter(conn.getOutputStream());){
                    out.write(body);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                        throw throwable;
                    }
                    if (throwable == throwable2) throw throwable;
                    throwable.addSuppressed(throwable2);
                    throw throwable;
                }
            }
            throwable = null;
            var6_8 = null;
            try {
                InputStream in = conn.getInputStream();
                try {
                    Result result;
                    block27: {
                        ByteArrayOutputStream result2 = new ByteArrayOutputStream();
                        try {
                            byte[] buffer = new byte[1024];
                            while (true) {
                                int length;
                                if ((length = in.read(buffer)) == -1) {
                                    result = new Result(result2.toString(StandardCharsets.UTF_8.name()), conn.getResponseCode());
                                    return result;
                                }
                                result2.write(buffer, 0, length);
                            }
                        }
                        finally {
                            if (result2 == null) break block27;
                            result2.close();
                        }
                    }
                    if (in != null) {
                        in.close();
                    }
                    conn.disconnect();
                    return result;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    if (in == null) throw throwable;
                    in.close();
                    throw throwable;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                    throw throwable;
                }
                if (throwable == throwable4) throw throwable;
                throwable.addSuppressed(throwable4);
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            conn.disconnect();
            throw throwable;
        }
    }

    public final class AsyncPutParameters {
        public final String address;
        public final String body;
        public final CompletableFuture<Result> future;
        public final long delay;

        public AsyncPutParameters(String address, String body, long delay) {
            this.address = address;
            this.body = body;
            this.future = new CompletableFuture();
            this.delay = delay;
        }
    }

    public static class Result {
        private final String body;
        private final int responseCode;

        public Result(String body, int responseCode) {
            this.body = body;
            this.responseCode = responseCode;
        }

        public String getBody() {
            return this.body;
        }

        public int getResponseCode() {
            return this.responseCode;
        }
    }
}

