/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.hue.internal;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.binding.hue.internal.ApiVersion;
import org.eclipse.smarthome.binding.hue.internal.ApiVersionUtils;
import org.eclipse.smarthome.binding.hue.internal.Config;
import org.eclipse.smarthome.binding.hue.internal.ConfigUpdate;
import org.eclipse.smarthome.binding.hue.internal.CreateScheduleRequest;
import org.eclipse.smarthome.binding.hue.internal.CreateUserRequest;
import org.eclipse.smarthome.binding.hue.internal.ErrorResponse;
import org.eclipse.smarthome.binding.hue.internal.FullConfig;
import org.eclipse.smarthome.binding.hue.internal.FullGroup;
import org.eclipse.smarthome.binding.hue.internal.FullHueObject;
import org.eclipse.smarthome.binding.hue.internal.FullLight;
import org.eclipse.smarthome.binding.hue.internal.FullSchedule;
import org.eclipse.smarthome.binding.hue.internal.FullSensor;
import org.eclipse.smarthome.binding.hue.internal.Group;
import org.eclipse.smarthome.binding.hue.internal.HttpClient;
import org.eclipse.smarthome.binding.hue.internal.HueObject;
import org.eclipse.smarthome.binding.hue.internal.NewLightsResponse;
import org.eclipse.smarthome.binding.hue.internal.Schedule;
import org.eclipse.smarthome.binding.hue.internal.ScheduleCommand;
import org.eclipse.smarthome.binding.hue.internal.ScheduleUpdate;
import org.eclipse.smarthome.binding.hue.internal.SearchForLightsRequest;
import org.eclipse.smarthome.binding.hue.internal.SetAttributesRequest;
import org.eclipse.smarthome.binding.hue.internal.StateUpdate;
import org.eclipse.smarthome.binding.hue.internal.SuccessResponse;
import org.eclipse.smarthome.binding.hue.internal.Util;
import org.eclipse.smarthome.binding.hue.internal.exceptions.ApiException;
import org.eclipse.smarthome.binding.hue.internal.exceptions.DeviceOffException;
import org.eclipse.smarthome.binding.hue.internal.exceptions.EntityNotAvailableException;
import org.eclipse.smarthome.binding.hue.internal.exceptions.GroupTableFullException;
import org.eclipse.smarthome.binding.hue.internal.exceptions.InvalidCommandException;
import org.eclipse.smarthome.binding.hue.internal.exceptions.LinkButtonException;
import org.eclipse.smarthome.binding.hue.internal.exceptions.UnauthorizedException;

@NonNullByDefault
public class HueBridge {
    private static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    private final String ip;
    private @Nullable String username;
    private final Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss").create();
    private HttpClient http = new HttpClient();
    private final ScheduledExecutorService scheduler;
    private @Nullable Config cachedConfig;
    private @Nullable ScheduleCommand scheduleCommand = null;

    public HueBridge(String ip, ScheduledExecutorService scheduler) {
        this.ip = ip;
        this.scheduler = scheduler;
    }

    public HueBridge(String ip, String username, ScheduledExecutorService scheduler) throws IOException, ApiException {
        this.ip = ip;
        this.scheduler = scheduler;
        this.authenticate(username);
    }

    public void setTimeout(int timeout) {
        this.http.setTimeout(timeout);
    }

    public String getIPAddress() {
        return this.ip;
    }

    public ApiVersion getVersion() throws IOException, ApiException {
        Config c = this.getCachedConfig();
        return ApiVersion.of(c.getApiVersion());
    }

    private Config getCachedConfig() throws IOException, ApiException {
        if (this.cachedConfig == null) {
            this.cachedConfig = this.getConfig();
        }
        return Objects.requireNonNull(this.cachedConfig);
    }

    public @Nullable String getUsername() {
        return this.username;
    }

    public boolean isAuthenticated() {
        return this.getUsername() != null;
    }

    public List<FullLight> getFullLights() throws IOException, ApiException {
        if (ApiVersionUtils.supportsFullLights(this.getVersion())) {
            Type gsonType = FullLight.GSON_TYPE;
            return this.getTypedLights(gsonType);
        }
        return this.getFullConfig().getLights();
    }

    public List<HueObject> getLights() throws IOException, ApiException {
        Type gsonType = HueObject.GSON_TYPE;
        return this.getTypedLights(gsonType);
    }

    private <T extends HueObject> List<T> getTypedLights(Type gsonType) throws IOException, ApiException {
        this.requireAuthentication();
        HttpClient.Result result = this.http.get(this.getRelativeURL("lights"));
        this.handleErrors(result);
        Map lightMap = (Map)this.safeFromJson(result.getBody(), gsonType);
        ArrayList<HueObject> lightList = new ArrayList<HueObject>();
        for (String id : lightMap.keySet()) {
            HueObject light = (HueObject)lightMap.get(id);
            light.setId(id);
            lightList.add(light);
        }
        return lightList;
    }

    public List<FullSensor> getSensors() throws IOException, ApiException {
        this.requireAuthentication();
        HttpClient.Result result = this.http.get(this.getRelativeURL("sensors"));
        this.handleErrors(result);
        Map sensorMap = (Map)this.safeFromJson(result.getBody(), FullSensor.GSON_TYPE);
        ArrayList<FullSensor> sensorList = new ArrayList<FullSensor>();
        for (String id : sensorMap.keySet()) {
            FullSensor sensor = (FullSensor)sensorMap.get(id);
            sensor.setId(id);
            sensorList.add(sensor);
        }
        return sensorList;
    }

    public @Nullable Date getLastSearch() throws IOException, ApiException {
        String lastScan;
        this.requireAuthentication();
        HttpClient.Result result = this.http.get(this.getRelativeURL("lights/new"));
        this.handleErrors(result);
        switch (lastScan = this.safeFromJson((String)result.getBody(), NewLightsResponse.class).lastscan) {
            case "none": {
                return null;
            }
            case "active": {
                return new Date();
            }
        }
        try {
            return new SimpleDateFormat(DATE_FORMAT).parse(lastScan);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public void startSearch() throws IOException, ApiException {
        this.requireAuthentication();
        HttpClient.Result result = this.http.post(this.getRelativeURL("lights"), "");
        this.handleErrors(result);
    }

    public void startSearch(List<String> serialNumbers) throws IOException, ApiException {
        this.requireAuthentication();
        String body = this.gson.toJson((Object)new SearchForLightsRequest(serialNumbers));
        HttpClient.Result result = this.http.post(this.getRelativeURL("lights"), body);
        this.handleErrors(result);
    }

    public FullHueObject getLight(HueObject light) throws IOException, ApiException {
        this.requireAuthentication();
        HttpClient.Result result = this.http.get(this.getRelativeURL("lights/" + this.enc(light.getId())));
        this.handleErrors(result);
        FullHueObject fullLight = this.safeFromJson(result.getBody(), FullLight.class);
        fullLight.setId(light.getId());
        return fullLight;
    }

    public String setLightName(HueObject light, String name) throws IOException, ApiException {
        this.requireAuthentication();
        String body = this.gson.toJson((Object)new SetAttributesRequest(name));
        HttpClient.Result result = this.http.put(this.getRelativeURL("lights/" + this.enc(light.getId())), body);
        this.handleErrors(result);
        List entries = (List)this.safeFromJson(result.getBody(), SuccessResponse.GSON_TYPE);
        SuccessResponse response = (SuccessResponse)entries.get(0);
        return (String)response.success.get("/lights/" + this.enc(light.getId()) + "/name");
    }

    public CompletableFuture<HttpClient.Result> setLightState(FullLight light, StateUpdate update) {
        this.requireAuthentication();
        String body = update.toJson();
        return this.http.putAsync(this.getRelativeURL("lights/" + this.enc(light.getId()) + "/state"), body, update.getMessageDelay(), this.scheduler);
    }

    public CompletableFuture<HttpClient.Result> updateSensorConfig(FullSensor sensor, ConfigUpdate update) {
        this.requireAuthentication();
        String body = update.toJson();
        return this.http.putAsync(this.getRelativeURL("sensors/" + this.enc(sensor.getId()) + "/config"), body, update.getMessageDelay(), this.scheduler);
    }

    public Group getAllGroup() {
        this.requireAuthentication();
        return new Group();
    }

    public List<Group> getGroups() throws IOException, ApiException {
        this.requireAuthentication();
        HttpClient.Result result = this.http.get(this.getRelativeURL("groups"));
        this.handleErrors(result);
        Map groupMap = (Map)this.safeFromJson(result.getBody(), Group.GSON_TYPE);
        ArrayList<Group> groupList = new ArrayList<Group>();
        groupList.add(new Group());
        for (String id : groupMap.keySet()) {
            Group group = (Group)groupMap.get(id);
            group.setId(id);
            groupList.add(group);
        }
        return groupList;
    }

    public Group createGroup(List<HueObject> lights) throws IOException, ApiException {
        this.requireAuthentication();
        String body = this.gson.toJson((Object)new SetAttributesRequest(lights));
        HttpClient.Result result = this.http.post(this.getRelativeURL("groups"), body);
        this.handleErrors(result);
        List entries = (List)this.safeFromJson(result.getBody(), SuccessResponse.GSON_TYPE);
        SuccessResponse response = (SuccessResponse)entries.get(0);
        Group group = new Group();
        group.setName("Group");
        group.setId(Util.quickMatch("^/groups/([0-9]+)$", (String)response.success.values().toArray()[0]));
        return group;
    }

    public Group createGroup(String name, List<HueObject> lights) throws IOException, ApiException {
        this.requireAuthentication();
        String body = this.gson.toJson((Object)new SetAttributesRequest(name, lights));
        HttpClient.Result result = this.http.post(this.getRelativeURL("groups"), body);
        this.handleErrors(result);
        List entries = (List)this.safeFromJson(result.getBody(), SuccessResponse.GSON_TYPE);
        SuccessResponse response = (SuccessResponse)entries.get(0);
        Group group = new Group();
        group.setName(name);
        group.setId(Util.quickMatch("^/groups/([0-9]+)$", (String)response.success.values().toArray()[0]));
        return group;
    }

    public FullGroup getGroup(Group group) throws IOException, ApiException {
        this.requireAuthentication();
        HttpClient.Result result = this.http.get(this.getRelativeURL("groups/" + this.enc(group.getId())));
        this.handleErrors(result);
        FullGroup fullGroup = this.safeFromJson(result.getBody(), FullGroup.class);
        fullGroup.setId(group.getId());
        return fullGroup;
    }

    public String setGroupName(Group group, String name) throws IOException, ApiException {
        this.requireAuthentication();
        if (!group.isModifiable()) {
            throw new IllegalArgumentException("Group cannot be modified");
        }
        String body = this.gson.toJson((Object)new SetAttributesRequest(name));
        HttpClient.Result result = this.http.put(this.getRelativeURL("groups/" + this.enc(group.getId())), body);
        this.handleErrors(result);
        List entries = (List)this.safeFromJson(result.getBody(), SuccessResponse.GSON_TYPE);
        SuccessResponse response = (SuccessResponse)entries.get(0);
        return (String)response.success.get("/groups/" + this.enc(group.getId()) + "/name");
    }

    public void setGroupLights(Group group, List<HueObject> lights) throws IOException, ApiException {
        this.requireAuthentication();
        if (!group.isModifiable()) {
            throw new IllegalArgumentException("Group cannot be modified");
        }
        String body = this.gson.toJson((Object)new SetAttributesRequest(lights));
        HttpClient.Result result = this.http.put(this.getRelativeURL("groups/" + this.enc(group.getId())), body);
        this.handleErrors(result);
    }

    public String setGroupAttributes(Group group, String name, List<HueObject> lights) throws IOException, ApiException {
        this.requireAuthentication();
        if (!group.isModifiable()) {
            throw new IllegalArgumentException("Group cannot be modified");
        }
        String body = this.gson.toJson((Object)new SetAttributesRequest(name, lights));
        HttpClient.Result result = this.http.put(this.getRelativeURL("groups/" + this.enc(group.getId())), body);
        this.handleErrors(result);
        List entries = (List)this.safeFromJson(result.getBody(), SuccessResponse.GSON_TYPE);
        SuccessResponse response = (SuccessResponse)entries.get(0);
        return (String)response.success.get("/groups/" + this.enc(group.getId()) + "/name");
    }

    public void setGroupState(Group group, StateUpdate update) throws IOException, ApiException {
        this.requireAuthentication();
        String body = update.toJson();
        HttpClient.Result result = this.http.put(this.getRelativeURL("groups/" + this.enc(group.getId()) + "/action"), body);
        this.handleErrors(result);
    }

    public void deleteGroup(Group group) throws IOException, ApiException {
        this.requireAuthentication();
        if (!group.isModifiable()) {
            throw new IllegalArgumentException("Group cannot be modified");
        }
        HttpClient.Result result = this.http.delete(this.getRelativeURL("groups/" + this.enc(group.getId())));
        this.handleErrors(result);
    }

    public List<Schedule> getSchedules() throws IOException, ApiException {
        this.requireAuthentication();
        HttpClient.Result result = this.http.get(this.getRelativeURL("schedules"));
        this.handleErrors(result);
        Map scheduleMap = (Map)this.safeFromJson(result.getBody(), Schedule.GSON_TYPE);
        ArrayList<Schedule> scheduleList = new ArrayList<Schedule>();
        for (String id : scheduleMap.keySet()) {
            Schedule schedule = (Schedule)scheduleMap.get(id);
            schedule.setId(id);
            scheduleList.add(schedule);
        }
        return scheduleList;
    }

    public void createSchedule(Date time, ScheduleCallback callback) throws IOException, ApiException {
        this.createSchedule(null, null, time, callback);
    }

    public void createSchedule(String name, Date time, ScheduleCallback callback) throws IOException, ApiException {
        this.createSchedule(name, null, time, callback);
    }

    public void createSchedule(@Nullable String name, @Nullable String description, Date time, ScheduleCallback callback) throws IOException, ApiException {
        this.requireAuthentication();
        this.handleCommandCallback(callback);
        String body = this.gson.toJson((Object)new CreateScheduleRequest(name, description, this.scheduleCommand, time));
        HttpClient.Result result = this.http.post(this.getRelativeURL("schedules"), body);
        this.handleErrors(result);
    }

    public FullSchedule getSchedule(Schedule schedule) throws IOException, ApiException {
        this.requireAuthentication();
        HttpClient.Result result = this.http.get(this.getRelativeURL("schedules/" + this.enc(schedule.getId())));
        this.handleErrors(result);
        FullSchedule fullSchedule = this.safeFromJson(result.getBody(), FullSchedule.class);
        fullSchedule.setId(schedule.getId());
        return fullSchedule;
    }

    public void setSchedule(Schedule schedule, ScheduleUpdate update) throws IOException, ApiException {
        this.requireAuthentication();
        String body = update.toJson();
        HttpClient.Result result = this.http.put(this.getRelativeURL("schedules/" + this.enc(schedule.getId())), body);
        this.handleErrors(result);
    }

    public void setScheduleCommand(Schedule schedule, ScheduleCallback callback) throws IOException, ApiException {
        this.requireAuthentication();
        this.handleCommandCallback(callback);
        String body = this.gson.toJson((Object)new CreateScheduleRequest(null, null, this.scheduleCommand, null));
        HttpClient.Result result = this.http.put(this.getRelativeURL("schedules/" + this.enc(schedule.getId())), body);
        this.handleErrors(result);
    }

    private @Nullable ScheduleCommand handleCommandCallback(ScheduleCallback callback) throws ApiException {
        HttpClient realClient = this.http;
        this.http = new HttpClient(){

            @Override
            protected HttpClient.Result doNetwork(String address, String requestMethod, @Nullable String body) throws IOException {
                if (requestMethod.equals("GET")) {
                    return super.doNetwork(address, requestMethod, body);
                }
                String extractedAddress = Util.quickMatch("^http://[^/]+(.+)$", address);
                JsonElement commandBody = new JsonParser().parse(body);
                HueBridge.this.scheduleCommand = new ScheduleCommand(extractedAddress, requestMethod, commandBody);
                return new HttpClient.Result("", 405);
            }
        };
        try {
            this.scheduleCommand = null;
            callback.onScheduleCommand(this);
        }
        catch (IOException | RuntimeException exception) {}
        if (this.scheduleCommand != null && Util.stringSize(this.scheduleCommand.getBody()) > 90) {
            throw new InvalidCommandException("Commmand body is larger than 90 bytes");
        }
        this.http = realClient;
        return this.scheduleCommand;
    }

    public void deleteSchedule(Schedule schedule) throws IOException, ApiException {
        this.requireAuthentication();
        HttpClient.Result result = this.http.delete(this.getRelativeURL("schedules/" + this.enc(schedule.getId())));
        this.handleErrors(result);
    }

    public void authenticate(String username) throws IOException, ApiException {
        try {
            this.username = username;
            this.getLights();
        }
        catch (Exception e) {
            this.username = null;
            throw new UnauthorizedException(e.toString());
        }
    }

    public void link(String username, String devicetype) throws IOException, ApiException {
        this.username = this.link(new CreateUserRequest(username, devicetype));
    }

    public String link(String devicetype) throws IOException, ApiException {
        this.username = this.link(new CreateUserRequest(devicetype));
        return this.username;
    }

    private String link(CreateUserRequest request) throws IOException, ApiException {
        if (this.username != null) {
            throw new IllegalStateException("already linked");
        }
        String body = this.gson.toJson((Object)request);
        HttpClient.Result result = this.http.post(this.getRelativeURL(""), body);
        this.handleErrors(result);
        List entries = (List)this.safeFromJson(result.getBody(), SuccessResponse.GSON_TYPE);
        SuccessResponse response = (SuccessResponse)entries.get(0);
        return (String)response.success.get("username");
    }

    public Config getConfig() throws IOException, ApiException {
        this.requireAuthentication();
        HttpClient.Result result = this.http.get(this.getRelativeURL("config"));
        this.handleErrors(result);
        return this.safeFromJson(result.getBody(), Config.class);
    }

    public void setConfig(ConfigUpdate update) throws IOException, ApiException {
        this.requireAuthentication();
        String body = update.toJson();
        HttpClient.Result result = this.http.put(this.getRelativeURL("config"), body);
        this.handleErrors(result);
    }

    public void unlink() throws IOException, ApiException {
        this.requireAuthentication();
        HttpClient.Result result = this.http.delete(this.getRelativeURL("config/whitelist/" + this.enc(this.username)));
        this.handleErrors(result);
    }

    public FullConfig getFullConfig() throws IOException, ApiException {
        this.requireAuthentication();
        HttpClient.Result result = this.http.get(this.getRelativeURL(""));
        this.handleErrors(result);
        return (FullConfig)this.gson.fromJson(result.getBody(), FullConfig.class);
    }

    private void requireAuthentication() {
        if (this.username == null) {
            throw new IllegalStateException("linking is required before interacting with the bridge");
        }
    }

    private <T> T safeFromJson(String json, Type typeOfT) throws ApiException {
        try {
            return (T)this.gson.fromJson(json, typeOfT);
        }
        catch (JsonParseException e) {
            throw new ApiException("API returned unexpected result: " + e.getMessage());
        }
    }

    private <T> T safeFromJson(String json, Class<T> classOfT) throws ApiException {
        try {
            return (T)this.gson.fromJson(json, classOfT);
        }
        catch (JsonParseException e) {
            throw new ApiException("API returned unexpected result: " + e.getMessage());
        }
    }

    public void handleErrors(HttpClient.Result result) throws IOException, ApiException {
        if (result.getResponseCode() != 200) {
            throw new IOException();
        }
        try {
            List errors = (List)this.gson.fromJson(result.getBody(), ErrorResponse.GSON_TYPE);
            if (errors == null) {
                return;
            }
            for (ErrorResponse error : errors) {
                if (error.getType() == null) continue;
                switch (error.getType()) {
                    case 1: {
                        this.username = null;
                        throw new UnauthorizedException(error.getDescription());
                    }
                    case 3: {
                        throw new EntityNotAvailableException(error.getDescription());
                    }
                    case 7: {
                        throw new InvalidCommandException(error.getDescription());
                    }
                    case 101: {
                        throw new LinkButtonException(error.getDescription());
                    }
                    case 201: {
                        throw new DeviceOffException(error.getDescription());
                    }
                    case 301: {
                        throw new GroupTableFullException(error.getDescription());
                    }
                }
                throw new ApiException(error.getDescription());
            }
        }
        catch (JsonParseException jsonParseException) {}
    }

    private String enc(@Nullable String str) {
        try {
            if (str != null) {
                return URLEncoder.encode(str, "utf-8");
            }
            return "";
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new UnsupportedOperationException("UTF-8 not supported");
        }
    }

    private String getRelativeURL(String path) {
        String relativeUrl = "http://" + this.ip + "/api";
        if (this.username != null) {
            relativeUrl = String.valueOf(relativeUrl) + "/" + this.enc(this.username);
        }
        if (!path.isEmpty()) {
            relativeUrl = String.valueOf(relativeUrl) + "/" + path;
        }
        return relativeUrl;
    }

    public static interface ScheduleCallback {
        public void onScheduleCommand(HueBridge var1) throws IOException, ApiException;
    }
}

