/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.hue.internal;

import org.eclipse.smarthome.binding.hue.internal.Command;
import org.eclipse.smarthome.binding.hue.internal.ConfigUpdate;
import org.eclipse.smarthome.binding.hue.internal.State;

public class StateUpdate
extends ConfigUpdate {
    private Integer colorTemperature;
    private Integer brightness;

    public StateUpdate turnOn() {
        return this.setOn(true);
    }

    public StateUpdate turnOff() {
        return this.setOn(false);
    }

    public StateUpdate setOn(boolean on) {
        this.commands.add(new Command("on", on));
        return this;
    }

    public StateUpdate setBrightness(int brightness) {
        if (brightness < 1 || brightness > 254) {
            throw new IllegalArgumentException("Brightness out of range");
        }
        this.commands.add(new Command("bri", brightness));
        this.brightness = brightness;
        return this;
    }

    public Integer getBrightness() {
        return this.brightness;
    }

    public StateUpdate setHue(int hue) {
        if (hue < 0 || hue > 65535) {
            throw new IllegalArgumentException("Hue out of range");
        }
        this.commands.add(new Command("hue", hue));
        return this;
    }

    public StateUpdate setSat(int saturation) {
        if (saturation < 0 || saturation > 254) {
            throw new IllegalArgumentException("Saturation out of range");
        }
        this.commands.add(new Command("sat", saturation));
        return this;
    }

    public StateUpdate setXY(float x, float y) {
        return this.setXY(new float[]{x, y});
    }

    public StateUpdate setXY(float[] xy) {
        if (xy.length != 2) {
            throw new IllegalArgumentException("Invalid coordinate array given");
        }
        if (xy[0] < 0.0f || xy[0] > 1.0f || xy[1] < 0.0f || xy[1] > 1.0f) {
            throw new IllegalArgumentException("X and/or Y coordinate(s) out of bounds");
        }
        this.commands.add(new Command("xy", xy));
        return this;
    }

    public StateUpdate setColorTemperature(int colorTemperature) {
        if (colorTemperature < 153 || colorTemperature > 500) {
            throw new IllegalArgumentException("Color temperature out of range");
        }
        this.commands.add(new Command("ct", colorTemperature));
        this.colorTemperature = colorTemperature;
        return this;
    }

    public Integer getColorTemperature() {
        return this.colorTemperature;
    }

    public StateUpdate setAlert(State.AlertMode mode) {
        this.commands.add(new Command("alert", mode.toString().toLowerCase()));
        return this;
    }

    public StateUpdate setEffect(State.Effect effect) {
        this.commands.add(new Command("effect", effect.toString().toLowerCase()));
        return this;
    }

    public StateUpdate setTransitionTime(int timeMillis) {
        if (timeMillis < 0 || timeMillis > 0x640000) {
            throw new IllegalArgumentException("Transition time out of range");
        }
        this.commands.add(new Command("transitiontime", timeMillis / 100));
        return this;
    }
}

