/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.hue.internal.discovery;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.smarthome.binding.hue.internal.HueBindingConstants;
import org.eclipse.smarthome.binding.hue.internal.discovery.BridgeJsonParameters;
import org.eclipse.smarthome.config.discovery.AbstractDiscoveryService;
import org.eclipse.smarthome.config.discovery.DiscoveryResult;
import org.eclipse.smarthome.config.discovery.DiscoveryResultBuilder;
import org.eclipse.smarthome.config.discovery.DiscoveryService;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.io.net.http.HttpUtil;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(service={DiscoveryService.class}, immediate=true, configurationPid="discovery.hue")
public class HueBridgeNupnpDiscovery
extends AbstractDiscoveryService {
    private static final String MODEL_NAME_PHILIPS_HUE = "<modelName>Philips hue";
    protected static final String BRIDGE_INDICATOR = "fffe";
    private static final String DISCOVERY_URL = "https://www.meethue.com/api/nupnp";
    protected static final String LABEL_PATTERN = "Philips hue (IP)";
    private static final String DESC_URL_PATTERN = "http://HOST/description.xml";
    private static final int REQUEST_TIMEOUT = 5000;
    private static final int DISCOVERY_TIMEOUT = 10;
    private static final Set<ThingTypeUID> SUPPORTED_THING_TYPES = Collections.singleton(HueBindingConstants.THING_TYPE_BRIDGE);
    private final Logger logger = LoggerFactory.getLogger(HueBridgeNupnpDiscovery.class);

    public HueBridgeNupnpDiscovery() {
        super(SUPPORTED_THING_TYPES, 10, false);
    }

    protected void startScan() {
        this.scheduler.schedule(this::discoverHueBridges, 0L, TimeUnit.SECONDS);
    }

    private void discoverHueBridges() {
        for (BridgeJsonParameters bridge : this.getBridgeList()) {
            if (!this.isReachableAndValidHueBridge(bridge)) continue;
            String host = bridge.getInternalIpAddress();
            String serialNumber = String.valueOf(bridge.getId().substring(0, 6)) + bridge.getId().substring(10);
            ThingUID uid = new ThingUID(HueBindingConstants.THING_TYPE_BRIDGE, serialNumber);
            DiscoveryResult result = DiscoveryResultBuilder.create((ThingUID)uid).withProperties(this.buildProperties(host, serialNumber)).withLabel(LABEL_PATTERN.replace("IP", host)).withRepresentationProperty("serialNumber").build();
            this.thingDiscovered(result);
        }
    }

    private Map<String, Object> buildProperties(String host, String serialNumber) {
        HashMap<String, Object> properties = new HashMap<String, Object>(2);
        properties.put("ipAddress", host);
        properties.put("serialNumber", serialNumber);
        return properties;
    }

    private boolean isReachableAndValidHueBridge(BridgeJsonParameters bridge) {
        String description;
        String host = bridge.getInternalIpAddress();
        String id = bridge.getId();
        if (host == null) {
            this.logger.debug("Bridge not discovered: ip is null");
            return false;
        }
        if (id == null) {
            this.logger.debug("Bridge not discovered: id is null");
            return false;
        }
        if (id.length() < 10) {
            this.logger.debug("Bridge not discovered: id {} is shorter then 10.", (Object)id);
            return false;
        }
        if (!id.substring(6, 10).equals(BRIDGE_INDICATOR)) {
            this.logger.debug("Bridge not discovered: id {} does not contain bridge indicator {} or its at the wrong position.", (Object)id, (Object)BRIDGE_INDICATOR);
            return false;
        }
        try {
            description = this.doGetRequest(DESC_URL_PATTERN.replace("HOST", host));
        }
        catch (IOException iOException) {
            this.logger.debug("Bridge not discovered: Failure accessing description file for ip: {}", (Object)host);
            return false;
        }
        if (!description.contains(MODEL_NAME_PHILIPS_HUE)) {
            this.logger.debug("Bridge not discovered: Description does not containing the model name: {}", (Object)description);
            return false;
        }
        return true;
    }

    private List<BridgeJsonParameters> getBridgeList() {
        try {
            Gson gson = new Gson();
            String json = this.doGetRequest(DISCOVERY_URL);
            return (List)gson.fromJson(json, new TypeToken<List<BridgeJsonParameters>>(){}.getType());
        }
        catch (IOException iOException) {
            this.logger.debug("Philips Hue NUPnP service not reachable. Can't discover bridges");
        }
        catch (JsonParseException jsonParseException) {
            this.logger.debug("Invalid json respone from Hue NUPnP service. Can't discover bridges");
        }
        return new ArrayList<BridgeJsonParameters>();
    }

    protected String doGetRequest(String url) throws IOException {
        return HttpUtil.executeUrl((String)"GET", (String)url, (int)5000);
    }
}

