/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.hue.internal.handler;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.binding.hue.internal.FullSensor;
import org.eclipse.smarthome.binding.hue.internal.HueBridge;
import org.eclipse.smarthome.binding.hue.internal.SensorConfigUpdate;
import org.eclipse.smarthome.binding.hue.internal.handler.HueClient;
import org.eclipse.smarthome.binding.hue.internal.handler.SensorStatusListener;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.core.library.types.DateTimeType;
import org.eclipse.smarthome.core.library.types.DecimalType;
import org.eclipse.smarthome.core.library.types.OnOffType;
import org.eclipse.smarthome.core.thing.Bridge;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingStatus;
import org.eclipse.smarthome.core.thing.ThingStatusDetail;
import org.eclipse.smarthome.core.thing.binding.BaseThingHandler;
import org.eclipse.smarthome.core.thing.binding.BridgeHandler;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.State;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public abstract class HueSensorHandler
extends BaseThingHandler
implements SensorStatusListener {
    @NonNullByDefault(value={})
    private String sensorId;
    private final Logger logger = LoggerFactory.getLogger(HueSensorHandler.class);
    private boolean propertiesInitializedSuccessfully;
    private @Nullable HueClient hueClient;

    public HueSensorHandler(Thing thing) {
        super(thing);
    }

    public void initialize() {
        this.logger.debug("Initializing hue sensor handler.");
        Bridge bridge = this.getBridge();
        this.initializeThing(bridge == null ? null : bridge.getStatus());
    }

    private void initializeThing(@Nullable ThingStatus bridgeStatus) {
        this.logger.debug("initializeThing thing {} bridge status {}", (Object)this.getThing().getUID(), (Object)bridgeStatus);
        String configSensorId = (String)this.getConfig().get("sensorId");
        if (configSensorId != null) {
            this.sensorId = configSensorId;
            if (this.getHueClient() != null) {
                if (bridgeStatus == ThingStatus.ONLINE) {
                    this.initializeProperties();
                    this.updateStatus(ThingStatus.ONLINE);
                } else {
                    this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.BRIDGE_OFFLINE);
                }
            } else {
                this.updateStatus(ThingStatus.OFFLINE);
            }
        } else {
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.CONFIGURATION_ERROR, "@text/offline.conf-error-no-sensor-id");
        }
    }

    private synchronized void initializeProperties() {
        FullSensor fullSensor;
        if (!this.propertiesInitializedSuccessfully && (fullSensor = this.getSensor()) != null) {
            String modelId;
            String softwareVersion = fullSensor.getSoftwareVersion();
            if (softwareVersion != null) {
                this.updateProperty("firmwareVersion", softwareVersion);
            }
            if ((modelId = fullSensor.getNormalizedModelID()) != null) {
                this.updateProperty("modelId", modelId);
            }
            this.updateProperty("vendor", fullSensor.getManufacturerName());
            this.updateProperty("productName", fullSensor.getProductName());
            String uniqueID = fullSensor.getUniqueID();
            if (uniqueID != null) {
                this.updateProperty("uniqueId", uniqueID);
            }
            this.propertiesInitializedSuccessfully = true;
        }
    }

    public void dispose() {
        this.logger.debug("Hue sensor handler disposes. Unregistering listener.");
        if (this.sensorId != null) {
            HueClient bridgeHandler = this.getHueClient();
            if (bridgeHandler != null) {
                bridgeHandler.unregisterSensorStatusListener(this);
                this.hueClient = null;
            }
            this.sensorId = null;
        }
    }

    private @Nullable FullSensor getSensor() {
        HueClient bridgeHandler = this.getHueClient();
        if (bridgeHandler != null) {
            return bridgeHandler.getSensorById(this.sensorId);
        }
        return null;
    }

    protected synchronized @Nullable HueClient getHueClient() {
        if (this.hueClient == null) {
            Bridge bridge = this.getBridge();
            if (bridge == null) {
                return null;
            }
            BridgeHandler handler = bridge.getHandler();
            if (handler instanceof HueClient) {
                this.hueClient = (HueClient)handler;
                this.hueClient.registerSensorStatusListener(this);
            } else {
                return null;
            }
        }
        return this.hueClient;
    }

    public void handleCommand(ChannelUID channelUID, Command command) {
    }

    public void handleConfigurationUpdate(Map<String, Object> configurationParameters) {
        SensorConfigUpdate configUpdate = this.doConfigurationUpdate(configurationParameters);
        if (configurationParameters.containsKey("on")) {
            configUpdate.setOn(Boolean.TRUE.equals(configurationParameters.get("on")));
        }
        if (!configUpdate.isEmpty()) {
            HueClient hueBridge = this.getHueClient();
            FullSensor sensor = this.getSensor();
            if (hueBridge != null && sensor != null) {
                hueBridge.updateSensorConfig(sensor, configUpdate);
            } else {
                this.logger.debug("hue bridge handler not found or sensor not known on bridge. Cannot handle configuration update.");
            }
        }
        super.handleConfigurationUpdate(configurationParameters);
    }

    @Override
    public void onSensorStateChanged(@Nullable HueBridge bridge, FullSensor sensor) {
        Object battery;
        this.logger.trace("onSensorStateChanged() was called");
        if (!sensor.getId().equals(this.sensorId)) {
            this.logger.trace("Received state change for another handler's sensor ({}). Will be ignored.", (Object)sensor.getId());
            return;
        }
        this.initializeProperties();
        if (Boolean.TRUE.equals(sensor.getConfig().get("reachable"))) {
            this.updateStatus(ThingStatus.ONLINE);
        } else {
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.NONE, "@text/offline.sensor-not-reachable");
        }
        Configuration config = this.editConfiguration();
        if (sensor.getConfig().containsKey("on")) {
            config.put("on", sensor.getConfig().get("on"));
        }
        this.doSensorStateChanged(bridge, sensor, config);
        Object lastUpdated = sensor.getState().get("lastupdated");
        if (lastUpdated != null) {
            try {
                this.updateState("last_updated", (State)new DateTimeType(ZonedDateTime.ofInstant(LocalDateTime.parse(String.valueOf(lastUpdated), DateTimeFormatter.ISO_LOCAL_DATE_TIME), ZoneOffset.UTC, ZoneId.systemDefault())));
            }
            catch (DateTimeParseException dateTimeParseException) {}
        }
        if ((battery = sensor.getConfig().get("battery")) != null) {
            DecimalType batteryLevel = DecimalType.valueOf((String)String.valueOf(battery));
            this.updateState("battery_level", (State)batteryLevel);
            this.updateState("battery_low", (State)(batteryLevel.intValue() <= 10 ? OnOffType.ON : OnOffType.OFF));
        }
        this.updateConfiguration(config);
    }

    public void channelLinked(ChannelUID channelUID) {
        FullSensor sensor;
        HueClient handler = this.getHueClient();
        if (handler != null && (sensor = handler.getSensorById(this.sensorId)) != null) {
            this.onSensorStateChanged(null, sensor);
        }
    }

    protected abstract SensorConfigUpdate doConfigurationUpdate(Map<String, Object> var1);

    protected abstract void doSensorStateChanged(@Nullable HueBridge var1, FullSensor var2, Configuration var3);

    @Override
    public void onSensorRemoved(@Nullable HueBridge bridge, FullSensor sensor) {
        if (sensor.getId().equals(this.sensorId)) {
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.NONE, "offline.sensor-removed");
        }
    }

    @Override
    public void onSensorAdded(@Nullable HueBridge bridge, FullSensor sensor) {
        if (sensor.getId().equals(this.sensorId)) {
            this.onSensorStateChanged(bridge, sensor);
        }
    }
}

