/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.hue.internal.handler.sensors;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.binding.hue.internal.FullSensor;
import org.eclipse.smarthome.binding.hue.internal.HueBindingConstants;
import org.eclipse.smarthome.binding.hue.internal.HueBridge;
import org.eclipse.smarthome.binding.hue.internal.SensorConfigUpdate;
import org.eclipse.smarthome.binding.hue.internal.handler.HueBridgeHandler;
import org.eclipse.smarthome.binding.hue.internal.handler.HueSensorHandler;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.core.library.types.DecimalType;
import org.eclipse.smarthome.core.thing.Bridge;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.binding.BridgeHandler;
import org.eclipse.smarthome.core.types.State;

@NonNullByDefault
public class DimmerSwitchHandler
extends HueSensorHandler {
    public static final Set<ThingTypeUID> SUPPORTED_THING_TYPES = Collections.singleton(HueBindingConstants.THING_TYPE_DIMMER_SWITCH);
    private long refreshIntervalInNanos = TimeUnit.MILLISECONDS.toNanos(1000L);

    public DimmerSwitchHandler(Thing thing) {
        super(thing);
    }

    @Override
    public void initialize() {
        BridgeHandler bridgeHandler;
        super.initialize();
        Bridge bridge = this.getBridge();
        if (bridge != null && (bridgeHandler = bridge.getHandler()) instanceof HueBridgeHandler) {
            this.refreshIntervalInNanos = TimeUnit.MILLISECONDS.toNanos(((HueBridgeHandler)bridgeHandler).getSensorPollingInterval() * 2L);
        }
    }

    @Override
    protected SensorConfigUpdate doConfigurationUpdate(Map<String, Object> configurationParameters) {
        return new SensorConfigUpdate();
    }

    @Override
    protected void doSensorStateChanged(@Nullable HueBridge bridge, FullSensor sensor, Configuration config) {
        Object buttonState;
        ZonedDateTime now;
        ZoneId zoneId = ZoneId.systemDefault();
        ZonedDateTime timestamp = now = ZonedDateTime.now(zoneId);
        Object lastUpdated = sensor.getState().get("lastupdated");
        if (lastUpdated != null) {
            try {
                timestamp = ZonedDateTime.ofInstant(LocalDateTime.parse(String.valueOf(lastUpdated), DateTimeFormatter.ISO_LOCAL_DATE_TIME), ZoneOffset.UTC, zoneId);
            }
            catch (DateTimeParseException dateTimeParseException) {}
        }
        if ((buttonState = sensor.getState().get("buttonevent")) != null) {
            String value = String.valueOf(buttonState);
            this.updateState("dimmer_switch", (State)new DecimalType(value));
            Instant then = timestamp.toInstant();
            Instant someSecondsEarlier = now.minusNanos(this.refreshIntervalInNanos).toInstant();
            if (then.isAfter(someSecondsEarlier) && then.isBefore(now.toInstant())) {
                this.triggerChannel("dimmer_switch_event", value);
            }
        }
    }
}

