/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.ntp.internal;

import org.eclipse.smarthome.binding.ntp.NtpBindingConstants;
import org.eclipse.smarthome.binding.ntp.handler.NtpHandler;
import org.eclipse.smarthome.core.i18n.LocaleProvider;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.binding.BaseThingHandlerFactory;
import org.eclipse.smarthome.core.thing.binding.ThingHandler;
import org.eclipse.smarthome.core.thing.binding.ThingHandlerFactory;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ThingHandlerFactory.class}, configurationPid="binding.ntp")
public class NtpHandlerFactory
extends BaseThingHandlerFactory {
    private LocaleProvider localeProvider;

    @Reference
    protected void setLocaleProvider(LocaleProvider localeProvider) {
        this.localeProvider = localeProvider;
    }

    protected void unsetLocaleProvider(LocaleProvider localeProvider) {
        this.localeProvider = null;
    }

    public boolean supportsThingType(ThingTypeUID thingTypeUID) {
        return NtpBindingConstants.SUPPORTED_THING_TYPES_UIDS.contains(thingTypeUID);
    }

    protected ThingHandler createHandler(Thing thing) {
        ThingTypeUID thingTypeUID = thing.getThingTypeUID();
        if (NtpBindingConstants.THING_TYPE_NTP.equals((Object)thingTypeUID)) {
            return new NtpHandler(thing, this.localeProvider);
        }
        return null;
    }
}

