/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.sonyaudio.internal.discovery;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.eclipse.smarthome.binding.sonyaudio.SonyAudioBindingConstants;
import org.eclipse.smarthome.config.discovery.DiscoveryResult;
import org.eclipse.smarthome.config.discovery.DiscoveryResultBuilder;
import org.eclipse.smarthome.config.discovery.upnp.UpnpDiscoveryParticipant;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.jupnp.model.meta.RemoteDevice;
import org.jupnp.model.meta.RemoteDeviceIdentity;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class SonyAudioDiscoveryParticipant
implements UpnpDiscoveryParticipant {
    private final Logger logger = LoggerFactory.getLogger(SonyAudioDiscoveryParticipant.class);
    private Set<ThingTypeUID> supportedThingTypes = SonyAudioBindingConstants.SUPPORTED_THING_TYPES_UIDS;

    public Set<ThingTypeUID> getSupportedThingTypeUIDs() {
        return this.supportedThingTypes;
    }

    public DiscoveryResult createResult(RemoteDevice device) {
        DiscoveryResult result = null;
        ThingUID thingUid = this.getThingUID(device);
        if (thingUid != null) {
            String label = StringUtils.isEmpty((String)device.getDetails().getFriendlyName()) ? device.getDisplayString() : device.getDetails().getFriendlyName();
            String host = ((RemoteDeviceIdentity)device.getIdentity()).getDescriptorURL().getHost();
            int port = ((RemoteDeviceIdentity)device.getIdentity()).getDescriptorURL().getPort();
            String path = ((RemoteDeviceIdentity)device.getIdentity()).getDescriptorURL().getPath();
            try {
                Map<String, Object> properties = this.getDescription(host, port, path);
                properties.put("ipAddress", ((RemoteDeviceIdentity)device.getIdentity()).getDescriptorURL().getHost());
                result = DiscoveryResultBuilder.create((ThingUID)thingUid).withLabel(label).withProperties(properties).build();
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return result;
    }

    public ThingUID getThingUID(RemoteDevice device) {
        ThingUID result = null;
        if (!StringUtils.containsIgnoreCase((String)device.getDetails().getManufacturerDetails().getManufacturer(), (String)"SONY")) {
            return result;
        }
        this.logger.debug("Manufacturer matched: search: {}, device value: {}.", (Object)"SONY", (Object)device.getDetails().getManufacturerDetails().getManufacturer());
        if (!StringUtils.containsIgnoreCase((String)device.getType().getType(), (String)"MediaRenderer")) {
            return result;
        }
        this.logger.debug("Device type matched: search: {}, device value: {}.", (Object)"MediaRenderer", (Object)device.getType().getType());
        this.logger.debug("Device services: {}", (Object)device.getServices().toString());
        String deviceModel = device.getDetails().getModelDetails() != null ? device.getDetails().getModelDetails().getModelName() : null;
        this.logger.debug("Device model: {}.", (Object)deviceModel);
        ThingTypeUID thingTypeUID = this.findThingType(deviceModel);
        if (thingTypeUID != null) {
            result = new ThingUID(thingTypeUID, ((RemoteDeviceIdentity)device.getIdentity()).getUdn().getIdentifierString());
        }
        return result;
    }

    private ThingTypeUID findThingType(String deviceModel) {
        ThingTypeUID thingTypeUID = null;
        for (ThingTypeUID thingType : SonyAudioBindingConstants.SUPPORTED_THING_TYPES_UIDS) {
            if (!thingType.getId().equalsIgnoreCase(deviceModel)) continue;
            return thingType;
        }
        return thingTypeUID;
    }

    private Map<String, Object> getDescription(String host, int port, String path) throws IOException {
        HashMap<String, Object> properties = new HashMap<String, Object>(2, 1.0f);
        URL url = new URL("http", host, port, path);
        this.logger.debug("URL: {}", (Object)url.toString());
        Throwable throwable = null;
        Object var7_8 = null;
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(url.openStream()));){
            String s;
            StringBuilder builder = new StringBuilder();
            while ((s = bufferedReader.readLine()) != null) {
                builder.append(s);
            }
            Pattern ScalarWebAPImatch = Pattern.compile("<av:X_ScalarWebAPI_BaseURL>(.*)</av:X_ScalarWebAPI_BaseURL>");
            Pattern baseURLmatch = Pattern.compile("http://(\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}):(\\d+)([^<]*)");
            Matcher tagmatch = ScalarWebAPImatch.matcher(builder.toString());
            if (tagmatch.find()) {
                Matcher matcher = baseURLmatch.matcher(tagmatch.group());
                matcher.find();
                int scalar_port = Integer.parseInt(matcher.group(2));
                String scalar_path = matcher.group(3);
                properties.put("port", scalar_port);
                properties.put("path", scalar_path);
            }
            return properties;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

