/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.sonyaudio.internal.protocol;

import org.eclipse.smarthome.binding.sonyaudio.internal.protocol.SonyAudioMethod;

class SetAudioVolume
extends SonyAudioMethod {
    public Param[] params;

    SetAudioVolume(int volume, int min, int max) {
        super("setAudioVolume", "1.1");
        long scaled_volume = this.scaleVolume(volume, min, max);
        this.params = new Param[]{new Param(scaled_volume)};
    }

    SetAudioVolume(int zone, int volume, int min, int max) {
        super("setAudioVolume", "1.1");
        long scaled_volume = this.scaleVolume(volume, min, max);
        this.params = new Param[]{new Param(scaled_volume, zone)};
    }

    SetAudioVolume(String volume_change) {
        super("setAudioVolume", "1.1");
        this.params = new Param[]{new Param(volume_change)};
    }

    SetAudioVolume(int zone, String volume_change) {
        super("setAudioVolume", "1.1");
        this.params = new Param[]{new Param(volume_change, zone)};
    }

    long scaleVolume(int volume, int min, int max) {
        return Math.round((double)((max - min) * volume) / 100.0 + (double)min);
    }

    class Param {
        String output = "";
        String volume;

        Param(long new_volume) {
            this.volume = Long.toString(new_volume);
        }

        Param(String volume_change) {
            this.volume = volume_change;
        }

        Param(long new_volume, int zone) {
            this.volume = Long.toString(new_volume);
            if (zone > 0) {
                this.output = "extOutput:zone?zone=" + Integer.toString(zone);
            }
        }

        Param(String volume_change, int zone) {
            this.volume = volume_change;
            if (zone > 0) {
                this.output = "extOutput:zone?zone=" + Integer.toString(zone);
            }
        }
    }
}

