/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.sonyaudio.internal.protocol;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.websocket.api.RemoteEndpoint;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.eclipse.smarthome.binding.sonyaudio.internal.protocol.SonyAudioClientSocketEventListener;
import org.eclipse.smarthome.binding.sonyaudio.internal.protocol.SonyAudioMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SonyAudioClientSocket {
    private final Logger logger = LoggerFactory.getLogger(SonyAudioClientSocket.class);
    private final ScheduledExecutorService scheduler;
    private static final int REQUEST_TIMEOUT_MS = 60000;
    private CountDownLatch commandLatch = null;
    private JsonObject commandResponse = null;
    private int nextMessageId = 1;
    private boolean connected = false;
    private final URI uri;
    private Session session;
    private final JsonParser parser = new JsonParser();
    private final Gson mapper = new GsonBuilder().disableHtmlEscaping().create();
    private static int ping = 0;
    private final SonyAudioClientSocketEventListener eventHandler;

    public SonyAudioClientSocket(SonyAudioClientSocketEventListener eventHandler, URI uri, ScheduledExecutorService scheduler) {
        this.eventHandler = eventHandler;
        this.uri = uri;
        this.scheduler = scheduler;
    }

    public synchronized void open(WebSocketClient webSocketClient) {
        try {
            if (this.isConnected()) {
                this.logger.warn("connect: connection is already open");
            }
            SonyAudioWebSocketListener socket = new SonyAudioWebSocketListener();
            ClientUpgradeRequest request = new ClientUpgradeRequest();
            try {
                webSocketClient.connect((Object)socket, this.uri, request).get(1L, TimeUnit.SECONDS);
            }
            catch (TimeoutException timeoutException) {
                this.logger.debug("Could not establish websocket within a second.");
            }
        }
        catch (Exception e) {
            this.logger.debug("Exception then trying to start the websocket {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public void close() {
        this.logger.debug("Closing socket {}", (Object)this.uri);
        if (this.session != null) {
            try {
                this.session.close();
            }
            catch (Exception e) {
                this.logger.debug("Exception during closing the websocket session {}", (Object)e.getMessage(), (Object)e);
            }
            this.session = null;
        }
    }

    public boolean isConnected() {
        if (this.session == null || !this.session.isOpen()) {
            this.connected = false;
            return this.connected;
        }
        RemoteEndpoint remote = this.session.getRemote();
        ByteBuffer payload = ByteBuffer.allocate(4).putInt(ping++);
        try {
            remote.sendPing(payload);
        }
        catch (IOException e) {
            this.logger.error("Connection to {} lost {}", (Object)this.uri, (Object)e);
            this.connected = false;
        }
        return this.connected;
    }

    private void sendMessage(String str) throws IOException {
        if (!this.isConnected()) {
            String stack = "";
            stack = String.valueOf(stack) + "Printing stack trace:\n";
            StackTraceElement[] elements = Thread.currentThread().getStackTrace();
            int i = 1;
            while (i < elements.length) {
                StackTraceElement s = elements[i];
                stack = String.valueOf(stack) + "\tat " + s.getClassName() + "." + s.getMethodName() + "(" + s.getFileName() + ":" + s.getLineNumber() + ")\n";
                ++i;
            }
            this.logger.error("Socket not initialized, trying to send {} {}", (Object)str, (Object)stack);
            throw new IOException("Socket not initialized");
        }
        this.logger.debug("send message fo {}: {}", (Object)this.uri.toString(), (Object)str);
        this.session.getRemote().sendString(str);
    }

    public synchronized JsonElement callMethod(SonyAudioMethod method) throws IOException {
        try {
            method.id = this.nextMessageId++;
            String message = this.mapper.toJson((Object)method);
            this.logger.debug("callMethod send {}", (Object)message);
            this.commandLatch = new CountDownLatch(1);
            this.commandResponse = null;
            this.sendMessage(message);
            if (this.commandLatch.await(60000L, TimeUnit.MILLISECONDS)) {
                this.logger.debug("callMethod {} returns {}", (Object)this.uri.toString(), (Object)this.commandResponse.toString());
                return this.commandResponse.get("result");
            }
            this.logger.debug("Timeout during callMethod({}, {})", (Object)method.method, (Object)message);
            throw new IOException("Timeout during callMethod");
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("Timeout in callMethod");
        }
    }

    public URI getURI() {
        return this.uri;
    }

    @WebSocket
    public class SonyAudioWebSocketListener {
        @OnWebSocketConnect
        public void onConnect(Session wssession) {
            SonyAudioClientSocket.this.logger.debug("Connected to server");
            SonyAudioClientSocket.this.session = wssession;
            SonyAudioClientSocket.this.connected = true;
            if (SonyAudioClientSocket.this.eventHandler != null) {
                SonyAudioClientSocket.this.scheduler.submit(() -> {
                    try {
                        SonyAudioClientSocket.this.eventHandler.onConnectionOpened(SonyAudioClientSocket.this.uri);
                    }
                    catch (Exception e) {
                        SonyAudioClientSocket.this.logger.error("Error handling onConnectionOpened() {}", (Object)e.getMessage(), (Object)e);
                    }
                });
            }
        }

        @OnWebSocketMessage
        public void onMessage(String message) {
            block7: {
                SonyAudioClientSocket.this.logger.debug("Message received from server: {}", (Object)message);
                try {
                    JsonObject json = SonyAudioClientSocket.this.parser.parse(message).getAsJsonObject();
                    if (json.has("id")) {
                        SonyAudioClientSocket.this.logger.debug("Response received from server: {}", (Object)json);
                        int messageId = json.get("id").getAsInt();
                        if (messageId == SonyAudioClientSocket.this.nextMessageId - 1) {
                            SonyAudioClientSocket.this.commandResponse = json;
                            SonyAudioClientSocket.this.commandLatch.countDown();
                        }
                        break block7;
                    }
                    SonyAudioClientSocket.this.logger.debug("Event received from server: {}", (Object)json);
                    try {
                        if (SonyAudioClientSocket.this.eventHandler != null) {
                            SonyAudioClientSocket.this.scheduler.submit(() -> {
                                try {
                                    SonyAudioClientSocket.this.eventHandler.handleEvent(json);
                                }
                                catch (Exception e) {
                                    SonyAudioClientSocket.this.logger.error("Error handling event {} player state change message: {}", new Object[]{json, e.getMessage(), e});
                                }
                            });
                        }
                    }
                    catch (Exception e) {
                        SonyAudioClientSocket.this.logger.error("Error handling player state change message", (Throwable)e);
                    }
                }
                catch (JsonParseException e) {
                    SonyAudioClientSocket.this.logger.debug("Not valid JSON message: {}", (Object)e.getMessage(), (Object)e);
                }
            }
        }

        @OnWebSocketClose
        public void onClose(int statusCode, String reason) {
            SonyAudioClientSocket.this.session = null;
            SonyAudioClientSocket.this.connected = false;
            SonyAudioClientSocket.this.logger.debug("Closing a WebSocket due to {}", (Object)reason);
            SonyAudioClientSocket.this.scheduler.submit(() -> {
                try {
                    SonyAudioClientSocket.this.eventHandler.onConnectionClosed();
                }
                catch (Exception e) {
                    SonyAudioClientSocket.this.logger.error("Error handling onConnectionClosed()", (Throwable)e);
                }
            });
        }
    }
}

